/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import com.adobe.marketing.mobile.campaign.AlertMessage;
import com.adobe.marketing.mobile.campaign.CampaignExtension;
import com.adobe.marketing.mobile.campaign.CampaignMessageRequiredFieldMissingException;
import com.adobe.marketing.mobile.campaign.FullScreenMessage;
import com.adobe.marketing.mobile.campaign.LocalNotificationMessage;
import com.adobe.marketing.mobile.launch.rulesengine.RuleConsequence;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.uri.UriOpening;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

abstract class CampaignMessage {
    private static final String SELF_TAG = "CampaignMessage";
    private static final Map<String, Class> messageTypeDictionary = new HashMap<String, Class>();
    protected final String messageId;
    final CampaignExtension parentModule;

    protected CampaignMessage(CampaignExtension extension, RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        this.parentModule = extension;
        if (consequence == null) {
            throw new CampaignMessageRequiredFieldMissingException("Consequence cannot be null!");
        }
        this.messageId = consequence.getId();
        if (StringUtils.isNullOrEmpty((String)this.messageId)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Invalid consequence. Required field \"id\" is null or empty.", (Object[])new Object[0]);
            throw new CampaignMessageRequiredFieldMissingException("Required field: Message \"id\" is null or empty.");
        }
        String consequenceType = consequence.getType();
        if (!"iam".equals(consequenceType)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Invalid consequence. Required field \"type\" is (%s) should be of type (iam).", (Object[])new Object[]{consequenceType});
            throw new CampaignMessageRequiredFieldMissingException("Required field: \"type\" is not equal to \"iam\".");
        }
        Map details = consequence.getDetail();
        if (details == null || details.isEmpty()) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Invalid consequence. Required field \"detail\" is null or empty.", (Object[])new Object[0]);
            throw new CampaignMessageRequiredFieldMissingException("Required field: \"detail\" is null or empty.");
        }
    }

    static CampaignMessage createMessageObject(CampaignExtension extension, RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        if (consequence == null) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  No message consequence found. Unable to proceed.", (Object[])new Object[0]);
            throw new CampaignMessageRequiredFieldMissingException("Message consequence is null.");
        }
        Map detailObject = consequence.getDetail();
        String template = DataReader.optString((Map)detailObject, (String)"template", (String)"");
        if (StringUtils.isNullOrEmpty((String)template)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  No message template found. Unable to proceed.", (Object[])new Object[0]);
            throw new CampaignMessageRequiredFieldMissingException("Required message field: Message template is null or empty.");
        }
        Class messageClass = messageTypeDictionary.get(template);
        if (messageClass == null) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  Provided message type is not supported. Unable to proceed.", (Object[])new Object[0]);
            return null;
        }
        CampaignMessage msgObject = null;
        try {
            msgObject = (CampaignMessage)messageClass.getDeclaredConstructor(CampaignExtension.class, RuleConsequence.class).newInstance(new Object[]{extension, consequence});
        }
        catch (IllegalAccessException e) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  Caught IllegalAccessException exception while trying to instantiate Message object. \n (%s)", (Object[])new Object[]{e});
        }
        catch (InstantiationException e) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  Caught InstantiationException exception while trying to instantiate Message object.\n (%s)", (Object[])new Object[]{e});
        }
        catch (NoSuchMethodException e) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  Caught NoSuchMethodException exception while trying to instantiate Message object. \n (%s)", (Object[])new Object[]{e});
        }
        catch (InvocationTargetException e) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"createMessageObject -  Caught InvocationTargetException exception while trying to instantiate Message object. \n (%s)", (Object[])new Object[]{e});
        }
        return msgObject;
    }

    abstract void showMessage();

    protected void triggered() {
        HashMap<String, Object> msgData = new HashMap<String, Object>();
        msgData.put("a.message.id", this.messageId);
        msgData.put("a.message.triggered", String.valueOf(1));
        this.callDispatchMessageInteraction(msgData);
    }

    protected void viewed() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("a.message.id", this.messageId);
        contextData.put("a.message.viewed", String.valueOf(1));
        this.callDispatchMessageInteraction(contextData);
    }

    protected void clickedThrough() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("a.message.id", this.messageId);
        contextData.put("a.message.clicked", String.valueOf(1));
        this.callDispatchMessageInteraction(contextData);
    }

    protected void clickedWithData(Map<String, String> data) {
        HashMap<String, Object> messageData = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("url")) {
                String url = null;
                try {
                    url = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.warning((String)"Campaign", (String)SELF_TAG, (String)"Failed to decode message interaction url (%s)", (Object[])new Object[]{e.getMessage()});
                }
                HashMap<String, String> urlTokens = new HashMap<String, String>();
                urlTokens.put("messageId", this.messageId);
                url = this.expandTokens(url, urlTokens);
                this.openUrl(url);
                messageData.put(key, url);
                continue;
            }
            messageData.put(key, value);
        }
        messageData.put("a.message.id", this.messageId);
        messageData.put("a.message.clicked", String.valueOf(1));
        this.callDispatchMessageInteraction(messageData);
    }

    protected void openUrl(String url) {
        if (StringUtils.isNullOrEmpty((String)url)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Cannot open a null or empty URL.", (Object[])new Object[0]);
            return;
        }
        UriOpening uriService = ServiceProvider.getInstance().getUriService();
        if (uriService == null || !uriService.openUri(url)) {
            Log.debug((String)"Campaign", (String)"Could not open URL (%s)", (String)url, (Object[])new Object[0]);
        }
    }

    String expandTokens(String input, Map<String, String> tokens) {
        if (StringUtils.isNullOrEmpty((String)input)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"expandTokens -  Unable to expand tokens, input string is null or empty", (Object[])new Object[0]);
            return input;
        }
        if (tokens == null || tokens.isEmpty()) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"expandTokens -  Unable to expand tokens, provided tokens Map is null or empty", (Object[])new Object[0]);
            return input;
        }
        String returnString = input;
        for (Map.Entry<String, String> entry : tokens.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) continue;
            returnString = returnString.replace(entry.getKey(), entry.getValue());
        }
        return returnString;
    }

    protected void callDispatchMessageInteraction(Map<String, Object> data) {
        this.parentModule.dispatchMessageInteraction(data);
    }

    protected void callDispatchMessageInfo(String broadlogId, String deliveryId, String action) {
        this.parentModule.dispatchMessageInfo(broadlogId, deliveryId, action);
    }

    abstract boolean shouldDownloadAssets();

    static {
        messageTypeDictionary.put("fullscreen", FullScreenMessage.class);
        messageTypeDictionary.put("alert", AlertMessage.class);
        messageTypeDictionary.put("local", LocalNotificationMessage.class);
    }
}

