/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.campaign.CampaignExtension;
import com.adobe.marketing.mobile.campaign.CampaignMessage;
import com.adobe.marketing.mobile.campaign.CampaignMessageRequiredFieldMissingException;
import com.adobe.marketing.mobile.launch.rulesengine.RuleConsequence;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.ui.Alert;
import com.adobe.marketing.mobile.services.ui.Presentable;
import com.adobe.marketing.mobile.services.ui.Presentation;
import com.adobe.marketing.mobile.services.ui.PresentationError;
import com.adobe.marketing.mobile.services.ui.PresentationUtilityProvider;
import com.adobe.marketing.mobile.services.ui.UIService;
import com.adobe.marketing.mobile.services.ui.alert.AlertEventListener;
import com.adobe.marketing.mobile.services.ui.alert.AlertSettings;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DefaultPresentationUtilityProvider;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

class AlertMessage
extends CampaignMessage {
    private final String SELF_TAG = "AlertMessage";
    private final UIService uiService = ServiceProvider.getInstance().getUIService();
    String title;
    String content;
    String url;
    String confirmButtonText;
    String cancelButtonText;

    AlertMessage(CampaignExtension extension, RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        super(extension, consequence);
        this.parseAlertMessagePayload(consequence);
    }

    private void parseAlertMessagePayload(RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        Log.trace((String)"Campaign", (String)"AlertMessage", (String)"parseAlertMessagePayload - Parsing rule consequence to show alert message with messageid %s", (Object[])new Object[]{this.messageId});
        Map detailDictionary = consequence.getDetail();
        this.title = DataReader.optString((Map)detailDictionary, (String)"title", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.title)) {
            throw new CampaignMessageRequiredFieldMissingException("Alert Message title is empty.");
        }
        this.content = DataReader.optString((Map)detailDictionary, (String)"content", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.content)) {
            throw new CampaignMessageRequiredFieldMissingException("Alert Message content is empty.");
        }
        this.cancelButtonText = DataReader.optString((Map)detailDictionary, (String)"cancel", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.cancelButtonText)) {
            throw new CampaignMessageRequiredFieldMissingException("Alert Message cancel button text is empty.");
        }
        this.confirmButtonText = DataReader.optString((Map)detailDictionary, (String)"confirm", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.confirmButtonText)) {
            Log.trace((String)"Campaign", (String)"AlertMessage", (String)"Tried to read \"confirm\" for Alert message but found none. This is not a required field.", (Object[])new Object[0]);
        }
        this.url = DataReader.optString((Map)detailDictionary, (String)"url", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.url)) {
            Log.trace((String)"Campaign", (String)"AlertMessage", (String)"Tried to read url for Alert message but found none. This is not a required field.", (Object[])new Object[0]);
        }
    }

    @Override
    void showMessage() {
        Log.debug((String)"Campaign", (String)"AlertMessage", (String)"Attempting to show Alert message with ID %s ", (Object[])new Object[]{this.messageId});
        UIAlertMessageUIListener alertListener = new UIAlertMessageUIListener();
        AlertSettings alertSetting = new AlertSettings.Builder().title(this.title).message(this.content).positiveButtonText(this.confirmButtonText).negativeButtonText(this.cancelButtonText).build();
        Presentable alertPresentable = this.uiService.create((Presentation)new Alert(alertSetting, (AlertEventListener)alertListener), (PresentationUtilityProvider)new DefaultPresentationUtilityProvider());
        alertPresentable.show();
    }

    @Override
    boolean shouldDownloadAssets() {
        return false;
    }

    void showUrl() {
        super.openUrl(this.url);
    }

    class UIAlertMessageUIListener
    implements AlertEventListener {
        UIAlertMessageUIListener() {
        }

        public void onPositiveResponse(@NonNull Presentable<Alert> presentable) {
            AlertMessage.this.viewed();
            if (!StringUtils.isNullOrEmpty((String)AlertMessage.this.url)) {
                HashMap<String, String> contextData = new HashMap<String, String>();
                contextData.put("url", AlertMessage.this.url);
                AlertMessage.this.clickedWithData(contextData);
            } else {
                AlertMessage.this.clickedThrough();
            }
        }

        public void onNegativeResponse(@NonNull Presentable<Alert> presentable) {
            AlertMessage.this.viewed();
        }

        public void onShow(@NonNull Presentable<Alert> presentable) {
            AlertMessage.this.triggered();
        }

        public void onDismiss(@NonNull Presentable<Alert> presentable) {
            AlertMessage.this.viewed();
        }

        public void onHide(@NonNull Presentable<Alert> presentable) {
        }

        public void onError(@NonNull Presentable<Alert> presentable, @NonNull PresentationError presentationError) {
            Log.debug((String)"Campaign", (String)"AlertMessage", (String)"Error occurred when attempting to display the alert message", (Object[])new Object[0]);
        }
    }
}

