/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import android.app.Activity;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.NotificationDismissalHandler;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.HashMap;

public class LocalNotificationHandler
extends BroadcastReceiver {
    private static final String LOG_TAG = "Campaign";
    private static final String SELF_TAG = "LocalNotificationHandler";
    private static final String NOTIFICATION_CHANNEL_NAME = "ADOBE_EXPERIENCE_PLATFORM_SDK";
    private static final String NOTIFICATION_CHANNEL_ID = "ADOBE_EXPERIENCE_PLATFORM_SDK";
    private static final String NOTIFICATION_CHANNEL_DESCRIPTION = "Adobe Experience Platform SDK Notifications";
    private static final String NOTIFICATION_CONTENT_KEY = "NOTIFICATION_CONTENT";
    private static final String NOTIFICATION_USER_INFO_KEY = "NOTIFICATION_USER_INFO";
    private static final String NOTIFICATION_IDENTIFIER_KEY = "NOTIFICATION_IDENTIFIER";
    private static final String NOTIFICATION_DEEPLINK_KEY = "NOTIFICATION_DEEPLINK";
    private static final String NOTIFICATION_SOUND_KEY = "NOTIFICATION_SOUND";
    private static final String NOTIFICATION_SENDER_CODE_KEY = "NOTIFICATION_SENDER_CODE";
    private static final int NOTIFICATION_SENDER_CODE = 750183;
    private static final String NOTIFICATION_REQUEST_CODE_KEY = "NOTIFICATION_REQUEST_CODE";
    private static final String NOTIFICATION_TITLE = "NOTIFICATION_TITLE";
    private static final int DEFAULT_ICON_RESOURCE_ID = -1;

    public void onReceive(Context context, Intent intent) {
        Intent resumeIntent;
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Log.debug((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to load extras from local notification intent", (Object[])new Object[0]);
            return;
        }
        Context appContext = context.getApplicationContext();
        String message = bundle.getString(NOTIFICATION_CONTENT_KEY);
        int requestCode = bundle.getInt(NOTIFICATION_REQUEST_CODE_KEY);
        int senderCode = bundle.getInt(NOTIFICATION_SENDER_CODE_KEY);
        String messageID = bundle.getString(NOTIFICATION_IDENTIFIER_KEY);
        String deeplink = bundle.getString(NOTIFICATION_DEEPLINK_KEY);
        String sound = bundle.getString(NOTIFICATION_SOUND_KEY);
        HashMap userInfo = (HashMap)bundle.getSerializable(NOTIFICATION_USER_INFO_KEY);
        String title = bundle.getString(NOTIFICATION_TITLE);
        if (senderCode != 750183) {
            Log.trace((String)LOG_TAG, (String)SELF_TAG, (String)"Request code does not match", (Object[])new Object[0]);
            return;
        }
        if (message == null) {
            Log.debug((String)LOG_TAG, (String)SELF_TAG, (String)"%s (local notification message)", (Object[])new Object[]{"Unexpected Null Value"});
            return;
        }
        Activity currentActivity = ServiceProvider.getInstance().getAppContextService().getCurrentActivity();
        if (deeplink != null && !deeplink.isEmpty()) {
            resumeIntent = new Intent("android.intent.action.VIEW");
            resumeIntent.setData(Uri.parse((String)deeplink));
        } else {
            resumeIntent = currentActivity != null ? currentActivity.getIntent() : intent;
        }
        resumeIntent.setFlags(0x24000000);
        resumeIntent.putExtra(NOTIFICATION_IDENTIFIER_KEY, messageID);
        resumeIntent.putExtra(NOTIFICATION_USER_INFO_KEY, (Serializable)userInfo);
        int buildVersion = Build.VERSION.SDK_INT;
        NotificationManager notificationManager = (NotificationManager)appContext.getSystemService("notification");
        try {
            int flags = buildVersion >= 23 ? 0xC000000 : 0x8000000;
            PendingIntent sender = PendingIntent.getActivity((Context)appContext, (int)senderCode, (Intent)resumeIntent, (int)flags);
            if (sender == null) {
                Log.debug((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to retrieve sender from broadcast, unable to post notification", (Object[])new Object[0]);
                return;
            }
            DeviceInforming systemInfoService = ServiceProvider.getInstance().getDeviceInfoService();
            String appName = systemInfoService.getApplicationName();
            if (buildVersion >= 26 && notificationManager.getNotificationChannel("ADOBE_EXPERIENCE_PLATFORM_SDK") == null) {
                NotificationChannel notificationChannel = new NotificationChannel("ADOBE_EXPERIENCE_PLATFORM_SDK", (CharSequence)"ADOBE_EXPERIENCE_PLATFORM_SDK", 4);
                notificationChannel.setDescription(NOTIFICATION_CHANNEL_DESCRIPTION);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, "ADOBE_EXPERIENCE_PLATFORM_SDK").setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle()).setSound(RingtoneManager.getDefaultUri((int)2)).setPriority(1).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle()).setSmallIcon(this.getSmallIcon());
            Bitmap largeIcon = this.getLargeIcon(context);
            if (largeIcon != null) {
                notificationBuilder.setLargeIcon(largeIcon);
            }
            if (!StringUtils.isNullOrEmpty((String)title)) {
                notificationBuilder.setContentTitle((CharSequence)title);
            } else {
                notificationBuilder.setContentTitle((CharSequence)appName);
            }
            notificationBuilder.setContentText((CharSequence)message);
            notificationBuilder.setContentIntent(sender);
            Intent deleteIntent = new Intent(appContext, NotificationDismissalHandler.class);
            deleteIntent.putExtra(NOTIFICATION_USER_INFO_KEY, (Serializable)userInfo);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)appContext, (int)senderCode, (Intent)deleteIntent, (int)flags);
            notificationBuilder.setDeleteIntent(pendingIntent);
            notificationBuilder.setAutoCancel(true);
            notificationManager.notify(new SecureRandom().nextInt(), notificationBuilder.build());
        }
        catch (Exception e) {
            Log.warning((String)LOG_TAG, (String)SELF_TAG, (String)"unexpected error posting notification (%s)", (Object[])new Object[]{e});
        }
    }

    private int getSmallIcon() {
        return MobileCore.getSmallIconResourceID() != -1 ? MobileCore.getSmallIconResourceID() : 17301651;
    }

    private Bitmap getLargeIcon(Context appContext) {
        if (appContext == null) {
            return null;
        }
        Drawable iconDrawable = null;
        int largeIconResourceId = MobileCore.getLargeIconResourceID();
        if (largeIconResourceId != -1) {
            iconDrawable = ContextCompat.getDrawable((Context)appContext, (int)largeIconResourceId);
        } else {
            ApplicationInfo applicationInfo = appContext.getApplicationInfo();
            if (applicationInfo != null && appContext.getPackageManager() != null) {
                PackageManager packageManager = appContext.getPackageManager();
                iconDrawable = packageManager.getApplicationIcon(applicationInfo);
            }
        }
        if (iconDrawable == null) {
            return null;
        }
        Bitmap icon = iconDrawable instanceof BitmapDrawable ? ((BitmapDrawable)iconDrawable).getBitmap() : this.getBitmapFromDrawable(iconDrawable);
        return icon;
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        Bitmap bmp = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmp);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bmp;
    }
}

