/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.campaign.CampaignExtension;
import com.adobe.marketing.mobile.services.Log;
import java.util.HashMap;
import java.util.Map;

public class Campaign {
    public static final String EXTENSION_VERSION = "3.0.3";
    private static final String LOG_TAG = "Campaign";
    private static final String LINKAGE_FIELDS = "linkagefields";
    public static final Class<? extends Extension> EXTENSION = CampaignExtension.class;

    private Campaign() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void setLinkageFields(@NonNull Map<String, String> linkageFields) {
        if (linkageFields == null || linkageFields.isEmpty()) {
            Log.warning((String)LOG_TAG, (String)"setLinkageFields", (String)"Provided LinkageFields Map is null or empty. Ignoring the setLinkageField request.", (Object[])new Object[0]);
            return;
        }
        HashMap<String, Map<String, String>> eventData = new HashMap<String, Map<String, String>>();
        eventData.put(LINKAGE_FIELDS, linkageFields);
        Event event = new Event.Builder("setLinkageFields Event", "com.adobe.eventType.campaign", "com.adobe.eventSource.requestIdentity").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void resetLinkageFields() {
        Event event = new Event.Builder("resetLinkageFields Event", "com.adobe.eventType.campaign", "com.adobe.eventSource.requestReset").build();
        MobileCore.dispatchEvent((Event)event);
    }
}

