/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.audience;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.audience.AudienceDataEntity;
import com.adobe.marketing.mobile.audience.AudienceNetworkResponseHandler;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HitProcessingResult;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.NetworkingConstants;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StreamUtils;
import java.io.InputStream;

class AudienceHitProcessor
implements HitProcessing {
    private static final String LOG_SOURCE = "AudienceHitProcessor";
    private static final int HIT_QUEUE_RETRY_TIME_SECONDS = 30;
    private final Networking networkService = ServiceProvider.getInstance().getNetworkService();
    private final AudienceNetworkResponseHandler networkResponseHandler;

    AudienceHitProcessor(AudienceNetworkResponseHandler networkResponseHandler) {
        this.networkResponseHandler = networkResponseHandler;
    }

    public int retryInterval(@NonNull DataEntity dataEntity) {
        return 30;
    }

    public void processHit(@NonNull DataEntity dataEntity, @NonNull HitProcessingResult processingResult) {
        if (this.networkService == null) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unexpected null NetworkService, unable to execute the request at this time.", (Object[])new Object[0]);
            processingResult.complete(false);
            return;
        }
        AudienceDataEntity entity = AudienceDataEntity.fromDataEntity(dataEntity);
        if (entity == null) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Unable to deserialize DataEntity to AudienceDataEntity, discarding hit.", (Object[])new Object[0]);
            processingResult.complete(true);
            return;
        }
        Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Processing hit request: %s", (Object[])new Object[]{entity.getUrl()});
        NetworkRequest networkRequest = new NetworkRequest(entity.getUrl(), HttpMethod.GET, null, null, entity.getTimeoutSec(), entity.getTimeoutSec());
        this.networkService.connectAsync(networkRequest, connection -> this.handleNetworkResponse(connection, entity.getEvent(), processingResult));
    }

    private void handleNetworkResponse(HttpConnecting connection, Event requestEvent, @NonNull HitProcessingResult processingResult) {
        boolean processingComplete;
        if (connection == null) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"AAM could not process network connection because it was null, Will retry later.", (Object[])new Object[0]);
            this.networkResponseHandler.complete(null, requestEvent);
            processingResult.complete(false);
            return;
        }
        if (connection.getResponseCode() == 200) {
            String response = StreamUtils.readAsString((InputStream)connection.getInputStream());
            this.networkResponseHandler.complete(response, requestEvent);
            processingComplete = true;
        } else if (!NetworkingConstants.RECOVERABLE_ERROR_CODES.contains(connection.getResponseCode())) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unrecoverable network error code (%d) while processing AAM requests, discarding hit.", (Object[])new Object[]{connection.getResponseCode()});
            this.networkResponseHandler.complete(null, requestEvent);
            processingComplete = true;
        } else {
            processingComplete = false;
        }
        connection.close();
        processingResult.complete(processingComplete);
    }
}

