/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.audience.AudienceExtension;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.HashMap;
import java.util.Map;

public final class Audience {
    private static final String LOG_TAG = "Audience";
    private static final String LOG_SOURCE = "Audience";
    private static final String EXTENSION_VERSION = "3.0.1";
    private static final int CALLBACK_TIMEOUT_MILLIS = 5000;
    @NonNull
    public static final Class<? extends Extension> EXTENSION = AudienceExtension.class;

    private Audience() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void getVisitorProfile(final @NonNull AdobeCallback<Map<String, String>> adobeCallback) {
        if (adobeCallback == null) {
            Log.debug((String)"Audience", (String)"Audience", (String)"Unexpected null callback, provide a callback to retrieve current visitorProfile.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("AudienceRequestIdentity", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.requestIdentity").build();
        Log.debug((String)"Audience", (String)"Audience", (String)"Dispatching Audience IdentityRequest event: %s", (Object[])new Object[]{event});
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                AdobeCallbackWithError adobeCallbackWithError;
                Log.warning((String)"Audience", (String)"Audience", (String)"An error occurred retrieving Audience Profile data: %s", (Object[])new Object[]{adobeError.getErrorName()});
                AdobeCallbackWithError adobeCallbackWithError2 = adobeCallbackWithError = adobeCallback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)adobeCallback : null;
                if (adobeCallbackWithError != null) {
                    adobeCallbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map value = DataReader.optStringMap((Map)event.getEventData(), (String)"aamprofile", null);
                adobeCallback.call((Object)value);
            }
        });
    }

    public static void signalWithData(final @NonNull Map<String, String> data, final @Nullable AdobeCallback<Map<String, String>> adobeCallback) {
        HashMap<String, Object> eventData = new HashMap<String, Object>(){
            {
                this.put("aamtraits", data);
            }
        };
        Event event = new Event.Builder("AudienceRequestContent", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.requestContent").setEventData((Map)eventData).build();
        Log.debug((String)"Audience", (String)"Audience", (String)"Audience event was submitted for signalWithData: %s", (Object[])new Object[]{data != null ? data.toString() : "no data"});
        if (adobeCallback == null) {
            MobileCore.dispatchEvent((Event)event);
            return;
        }
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                AdobeCallbackWithError adobeCallbackWithError;
                Log.warning((String)"Audience", (String)"Audience", (String)"An error occurred dispatching Audience Profile data: %s", (Object[])new Object[]{adobeError.getErrorName()});
                AdobeCallbackWithError adobeCallbackWithError2 = adobeCallbackWithError = adobeCallback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)adobeCallback : null;
                if (adobeCallbackWithError != null) {
                    adobeCallbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map profileMap = DataReader.optStringMap((Map)event.getEventData(), (String)"aamprofile", null);
                adobeCallback.call((Object)profileMap);
            }
        });
    }

    public static void reset() {
        Event event = new Event.Builder("AudienceRequestReset", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.requestReset").build();
        MobileCore.dispatchEvent((Event)event);
        Log.debug((String)"Audience", (String)"Audience", (String)"Request to reset Audience Manager values for this device has been dispatched.", (Object[])new Object[0]);
    }

    private static final class EventDataKeys {
        static final String VISITOR_TRAITS = "aamtraits";
        static final String VISITOR_PROFILE = "aamprofile";

        private EventDataKeys() {
        }
    }
}

