/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal.ui.quickconnect;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.lifecycle.ViewModel;
import com.adobe.marketing.mobile.assurance.internal.AssuranceComponentRegistry;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceStateManager;
import com.adobe.marketing.mobile.assurance.internal.QuickConnectCallback;
import com.adobe.marketing.mobile.assurance.internal.QuickConnectManager;
import com.adobe.marketing.mobile.assurance.internal.SessionAuthorizingPresentationType;
import com.adobe.marketing.mobile.assurance.internal.SessionUIOperationHandler;
import com.adobe.marketing.mobile.assurance.internal.ui.common.ConnectionState;
import com.adobe.marketing.mobile.assurance.internal.ui.quickconnect.AssuranceStatusListenerWrapper;
import com.adobe.marketing.mobile.assurance.internal.ui.quickconnect.QuickConnectScreenAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\b\u0012\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB-\b\u0011\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB%\b\u0011\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/quickconnect/QuickConnectViewModel;", "Landroidx/lifecycle/ViewModel;", "assuranceStateManager", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;", "environment", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;)V", "state", "Landroidx/compose/runtime/MutableState;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/common/ConnectionState;", "(Landroidx/compose/runtime/MutableState;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;)V", "assuranceStatusListenerWrapper", "Lcom/adobe/marketing/mobile/assurance/internal/ui/quickconnect/AssuranceStatusListenerWrapper;", "(Landroidx/compose/runtime/MutableState;Lcom/adobe/marketing/mobile/assurance/internal/ui/quickconnect/AssuranceStatusListenerWrapper;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;)V", "quickConnectManager", "Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectManager;", "(Landroidx/compose/runtime/MutableState;Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectManager;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;)V", "_state", "Landroidx/compose/runtime/State;", "getState$assurance_phoneRelease", "()Landroidx/compose/runtime/State;", "onAction", "", "quickConnectScreenAction", "Lcom/adobe/marketing/mobile/assurance/internal/ui/quickconnect/QuickConnectScreenAction;", "onAction$assurance_phoneRelease", "assurance_phoneRelease"})
public final class QuickConnectViewModel
extends ViewModel {
    @NotNull
    private final QuickConnectManager quickConnectManager;
    @NotNull
    private final AssuranceConstants.AssuranceEnvironment environment;
    @NotNull
    private final MutableState<ConnectionState> _state;

    @NotNull
    public final State<ConnectionState> getState$assurance_phoneRelease() {
        return (State)this._state;
    }

    public QuickConnectViewModel(@NotNull AssuranceStateManager assuranceStateManager2, @NotNull AssuranceConstants.AssuranceEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)assuranceStateManager2, (String)"assuranceStateManager");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this((MutableState<ConnectionState>)SnapshotStateKt.mutableStateOf$default((Object)new ConnectionState.Disconnected(null), null, (int)2, null), assuranceStateManager2, environment);
    }

    private QuickConnectViewModel(MutableState<ConnectionState> state, AssuranceStateManager assuranceStateManager2, AssuranceConstants.AssuranceEnvironment environment) {
        this(state, new AssuranceStatusListenerWrapper(state), assuranceStateManager2, environment);
    }

    @VisibleForTesting
    public QuickConnectViewModel(final @NotNull MutableState<ConnectionState> state, final @NotNull AssuranceStatusListenerWrapper assuranceStatusListenerWrapper, @NotNull AssuranceStateManager assuranceStateManager2, final @NotNull AssuranceConstants.AssuranceEnvironment environment) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)assuranceStatusListenerWrapper, (String)"assuranceStatusListenerWrapper");
        Intrinsics.checkNotNullParameter((Object)assuranceStateManager2, (String)"assuranceStateManager");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
        this(state, new QuickConnectManager(assuranceStateManager2, scheduledExecutorService, new QuickConnectCallback(){

            @Override
            public void onError(@NotNull AssuranceConstants.AssuranceConnectionError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                state.setValue((Object)new ConnectionState.Disconnected(error));
            }

            @Override
            public void onSuccess(@NotNull String sessionUUID, @NotNull String token) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)sessionUUID, (String)"sessionUUID");
                    Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                    SessionUIOperationHandler sessionUIOperationHandler = AssuranceComponentRegistry.INSTANCE.getSessionUIOperationHandler$assurance_phoneRelease();
                    if (sessionUIOperationHandler == null) break block0;
                    sessionUIOperationHandler.onConnect$assurance_phoneRelease(sessionUUID, token, environment, assuranceStatusListenerWrapper, SessionAuthorizingPresentationType.QUICK_CONNECT);
                }
            }
        }), AssuranceConstants.AssuranceEnvironment.PROD);
    }

    @VisibleForTesting
    public QuickConnectViewModel(@NotNull MutableState<ConnectionState> state, @NotNull QuickConnectManager quickConnectManager, @NotNull AssuranceConstants.AssuranceEnvironment environment) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)quickConnectManager, (String)"quickConnectManager");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this._state = state;
        this.quickConnectManager = quickConnectManager;
        this.environment = environment;
    }

    public final void onAction$assurance_phoneRelease(@NotNull QuickConnectScreenAction quickConnectScreenAction) {
        Intrinsics.checkNotNullParameter((Object)quickConnectScreenAction, (String)"quickConnectScreenAction");
        QuickConnectScreenAction quickConnectScreenAction2 = quickConnectScreenAction;
        if (quickConnectScreenAction2 instanceof QuickConnectScreenAction.Cancel) {
            this._state.setValue((Object)new ConnectionState.Disconnected(null));
            this.quickConnectManager.cancel$assurance_phoneRelease();
            SessionUIOperationHandler sessionUIOperationHandler = AssuranceComponentRegistry.INSTANCE.getSessionUIOperationHandler$assurance_phoneRelease();
            if (sessionUIOperationHandler != null) {
                sessionUIOperationHandler.onCancel$assurance_phoneRelease();
            }
        } else if (quickConnectScreenAction2 instanceof QuickConnectScreenAction.Retry) {
            this._state.setValue((Object)ConnectionState.Connecting.INSTANCE);
            this.quickConnectManager.registerDevice$assurance_phoneRelease();
        } else if (quickConnectScreenAction2 instanceof QuickConnectScreenAction.Connect) {
            this._state.setValue((Object)ConnectionState.Connecting.INSTANCE);
            this.quickConnectManager.registerDevice$assurance_phoneRelease();
        }
    }
}

