/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal.ui.pin;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.lifecycle.ViewModel;
import com.adobe.marketing.mobile.assurance.internal.AssuranceComponentRegistry;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionStatusListener;
import com.adobe.marketing.mobile.assurance.internal.SessionAuthorizingPresentationType;
import com.adobe.marketing.mobile.assurance.internal.SessionUIOperationHandler;
import com.adobe.marketing.mobile.assurance.internal.ui.common.ConnectionState;
import com.adobe.marketing.mobile.assurance.internal.ui.pin.PinScreenAction;
import com.adobe.marketing.mobile.assurance.internal.ui.pin.PinScreenState;
import com.adobe.marketing.mobile.assurance.internal.ui.pin.PinScreenViewModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/pin/PinScreenViewModel;", "Landroidx/lifecycle/ViewModel;", "sessionId", "", "environment", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;", "(Ljava/lang/String;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;)V", "_state", "Landroidx/compose/runtime/MutableState;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/pin/PinScreenState;", "assuranceStatusListener", "com/adobe/marketing/mobile/assurance/internal/ui/pin/PinScreenViewModel$assuranceStatusListener$1", "Lcom/adobe/marketing/mobile/assurance/internal/ui/pin/PinScreenViewModel$assuranceStatusListener$1;", "state", "Landroidx/compose/runtime/State;", "getState$assurance_phoneRelease", "()Landroidx/compose/runtime/State;", "connect", "", "pin", "onAction", "action", "Lcom/adobe/marketing/mobile/assurance/internal/ui/pin/PinScreenAction;", "onAction$assurance_phoneRelease", "assurance_phoneRelease"})
public final class PinScreenViewModel
extends ViewModel {
    @NotNull
    private final String sessionId;
    @NotNull
    private final AssuranceConstants.AssuranceEnvironment environment;
    @NotNull
    private final MutableState<PinScreenState> _state;
    @NotNull
    private final State<PinScreenState> state;
    @NotNull
    private final assuranceStatusListener.1 assuranceStatusListener;

    public PinScreenViewModel(@NotNull String sessionId, @NotNull AssuranceConstants.AssuranceEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this.sessionId = sessionId;
        this.environment = environment;
        this._state = SnapshotStateKt.mutableStateOf$default((Object)new PinScreenState(null, null, 3, null), null, (int)2, null);
        this.state = (State)this._state;
        this.assuranceStatusListener = new AssuranceSessionStatusListener(this){
            final /* synthetic */ PinScreenViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSessionConnected() {
                PinScreenViewModel.access$get_state$p(this.this$0).setValue((Object)PinScreenState.copy$default((PinScreenState)this.this$0.getState$assurance_phoneRelease().getValue(), null, ConnectionState.Connected.INSTANCE, 1, null));
            }

            public void onSessionDisconnected(@Nullable AssuranceConstants.AssuranceConnectionError error) {
                PinScreenViewModel.access$get_state$p(this.this$0).setValue((Object)PinScreenState.copy$default((PinScreenState)this.this$0.getState$assurance_phoneRelease().getValue(), null, new ConnectionState.Disconnected(error), 1, null));
            }

            public void onSessionTerminated(@Nullable AssuranceConstants.AssuranceConnectionError error) {
                PinScreenViewModel.access$get_state$p(this.this$0).setValue((Object)PinScreenState.copy$default((PinScreenState)this.this$0.getState$assurance_phoneRelease().getValue(), null, new ConnectionState.Disconnected(error), 1, null));
            }
        };
    }

    @NotNull
    public final State<PinScreenState> getState$assurance_phoneRelease() {
        return this.state;
    }

    public final void onAction$assurance_phoneRelease(@NotNull PinScreenAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        String text = ((PinScreenState)this.state.getValue()).getPin();
        PinScreenAction pinScreenAction = action;
        if (pinScreenAction instanceof PinScreenAction.Number) {
            if (text.length() >= 4) {
                return;
            }
            this._state.setValue((Object)PinScreenState.copy$default((PinScreenState)this.state.getValue(), text + ((PinScreenAction.Number)action).getNumber(), null, 2, null));
        } else if (pinScreenAction instanceof PinScreenAction.Delete) {
            if (StringsKt.isBlank((CharSequence)text)) {
                return;
            }
            this._state.setValue((Object)PinScreenState.copy$default((PinScreenState)this.state.getValue(), StringsKt.dropLast((String)text, (int)1), null, 2, null));
        } else if (pinScreenAction instanceof PinScreenAction.Connect) {
            this.connect(((PinScreenAction.Connect)action).getNumber());
        } else if (pinScreenAction instanceof PinScreenAction.Cancel) {
            SessionUIOperationHandler sessionUIOperationHandler = AssuranceComponentRegistry.INSTANCE.getSessionUIOperationHandler$assurance_phoneRelease();
            if (sessionUIOperationHandler != null) {
                sessionUIOperationHandler.onCancel$assurance_phoneRelease();
            }
        } else if (pinScreenAction instanceof PinScreenAction.Retry) {
            this._state.setValue((Object)new PinScreenState(null, null, 3, null));
        }
    }

    private final void connect(String pin) {
        SessionUIOperationHandler uiOperationHandler = AssuranceComponentRegistry.INSTANCE.getSessionUIOperationHandler$assurance_phoneRelease();
        if (StringsKt.isBlank((CharSequence)this.sessionId)) {
            this._state.setValue((Object)PinScreenState.copy$default((PinScreenState)this.state.getValue(), null, new ConnectionState.Disconnected(AssuranceConstants.AssuranceConnectionError.UNEXPECTED_ERROR), 1, null));
            return;
        }
        SessionUIOperationHandler sessionUIOperationHandler = uiOperationHandler;
        if (sessionUIOperationHandler != null) {
            sessionUIOperationHandler.onConnect$assurance_phoneRelease(this.sessionId, pin, this.environment, this.assuranceStatusListener, SessionAuthorizingPresentationType.PIN);
        }
        this._state.setValue((Object)PinScreenState.copy$default((PinScreenState)this.state.getValue(), null, ConnectionState.Connecting.INSTANCE, 1, null));
    }

    public static final /* synthetic */ MutableState access$get_state$p(PinScreenViewModel $this) {
        return $this._state;
    }
}

