/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal.ui.floatingbutton;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableKt;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.assurance.R;
import com.adobe.marketing.mobile.assurance.internal.ui.AssuranceActivity;
import com.adobe.marketing.mobile.assurance.internal.ui.floatingbutton.AssuranceFloatingButton;
import com.adobe.marketing.mobile.services.AppContextService;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.ui.FloatingButton;
import com.adobe.marketing.mobile.services.ui.Presentable;
import com.adobe.marketing.mobile.services.ui.Presentation;
import com.adobe.marketing.mobile.services.ui.PresentationError;
import com.adobe.marketing.mobile.services.ui.PresentationUtilityProvider;
import com.adobe.marketing.mobile.services.ui.floatingbutton.FloatingButtonEventListener;
import com.adobe.marketing.mobile.services.ui.floatingbutton.FloatingButtonSettings;
import com.adobe.marketing.mobile.util.DefaultPresentationUtilityProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\r\u0010\u001b\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/floatingbutton/AssuranceFloatingButton;", "", "appContextService", "Lcom/adobe/marketing/mobile/services/AppContextService;", "(Lcom/adobe/marketing/mobile/services/AppContextService;)V", "backupGraphic", "Landroid/graphics/Bitmap;", "floatingButtonEventListener", "Lcom/adobe/marketing/mobile/services/ui/floatingbutton/FloatingButtonEventListener;", "floatingButtonPresentable", "Lcom/adobe/marketing/mobile/services/ui/Presentable;", "Lcom/adobe/marketing/mobile/services/ui/FloatingButton;", "floatingButtonPresentation", "floatingButtonSettings", "Lcom/adobe/marketing/mobile/services/ui/floatingbutton/FloatingButtonSettings;", "initialGraphic", "getGraphic", "context", "Landroid/content/Context;", "resource", "", "hide", "", "hide$assurance_phoneRelease", "isActive", "", "isActive$assurance_phoneRelease", "remove", "remove$assurance_phoneRelease", "show", "show$assurance_phoneRelease", "updateGraphic", "connected", "updateGraphic$assurance_phoneRelease", "Companion", "assurance_phoneRelease"})
public final class AssuranceFloatingButton {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Bitmap backupGraphic;
    @NotNull
    private final Bitmap initialGraphic;
    @NotNull
    private final FloatingButtonSettings floatingButtonSettings;
    @NotNull
    private final FloatingButtonEventListener floatingButtonEventListener;
    @NotNull
    private final FloatingButton floatingButtonPresentation;
    @NotNull
    private final Presentable<FloatingButton> floatingButtonPresentable;
    @NotNull
    private static final String LOG_TAG = "AssuranceFloatingButton";
    private static final int GRAPHIC_HEIGHT_DP = 80;
    private static final int GRAPHIC_WIDTH_DP = 80;
    private static final float GRAPHIC_CORNER_RADIUS = 10.0f;

    public AssuranceFloatingButton(@NotNull AppContextService appContextService) {
        Intrinsics.checkNotNullParameter((Object)appContextService, (String)"appContextService");
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
        this.backupGraphic = bitmap;
        this.initialGraphic = this.getGraphic(appContextService.getApplicationContext(), R.drawable.ic_assurance_active);
        this.floatingButtonSettings = new FloatingButtonSettings.Builder().height(80).width(80).cornerRadius(10.0f).initialGraphic(this.initialGraphic).build();
        this.floatingButtonEventListener = new FloatingButtonEventListener(){

            public void onDismiss(@NotNull Presentable<FloatingButton> presentable) {
                Intrinsics.checkNotNullParameter(presentable, (String)"presentable");
            }

            public void onError(@NotNull Presentable<FloatingButton> presentable, @NotNull PresentationError error) {
                Intrinsics.checkNotNullParameter(presentable, (String)"presentable");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public void onHide(@NotNull Presentable<FloatingButton> presentable) {
                Intrinsics.checkNotNullParameter(presentable, (String)"presentable");
            }

            public void onPanDetected(@NotNull Presentable<FloatingButton> presentable) {
                Intrinsics.checkNotNullParameter(presentable, (String)"presentable");
            }

            public void onShow(@NotNull Presentable<FloatingButton> presentable) {
                Intrinsics.checkNotNullParameter(presentable, (String)"presentable");
            }

            public void onTapDetected(@NotNull Presentable<FloatingButton> presentable) {
                block2: {
                    Unit unit;
                    Intrinsics.checkNotNullParameter(presentable, (String)"presentable");
                    Context hostApplication = (Context)MobileCore.getApplication();
                    Intent intent = new Intent(hostApplication, AssuranceActivity.class);
                    intent.addFlags(65536);
                    intent.addFlags(131072);
                    intent.addFlags(0x10000000);
                    Context context = hostApplication;
                    if (context != null) {
                        context.startActivity(intent);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block2;
                    floatingButtonEventListener.1 $this$onTapDetected_u24lambda_u240 = this;
                    boolean bl = false;
                    Log.debug((String)"Assurance", (String)"AssuranceFloatingButton", (String)"Failed to launch Assurance activity on floating button tap. Host application is null", (Object[])new Object[0]);
                }
            }
        };
        this.floatingButtonPresentation = new FloatingButton(this.floatingButtonSettings, this.floatingButtonEventListener);
        this.floatingButtonPresentable = ServiceProvider.getInstance().getUIService().create((Presentation)this.floatingButtonPresentation, (PresentationUtilityProvider)new DefaultPresentationUtilityProvider());
    }

    public final void show$assurance_phoneRelease() {
        this.floatingButtonPresentable.show();
    }

    public final void hide$assurance_phoneRelease() {
        this.floatingButtonPresentable.hide();
    }

    public final void remove$assurance_phoneRelease() {
        this.floatingButtonPresentable.dismiss();
    }

    public final boolean isActive$assurance_phoneRelease() {
        return this.floatingButtonPresentable.getState() != Presentable.State.DETACHED;
    }

    public final void updateGraphic$assurance_phoneRelease(boolean connected) {
        block2: {
            Unit unit;
            Context context;
            Context context2 = context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
            if (context2 != null) {
                Context it = context2;
                boolean bl = false;
                Bitmap bitmap = this.getGraphic(it, connected ? R.drawable.ic_assurance_active : R.drawable.ic_assurance_inactive);
                ((FloatingButton)this.floatingButtonPresentable.getPresentation()).getEventHandler().updateGraphic(bitmap);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            AssuranceFloatingButton $this$updateGraphic_u24lambda_u241 = this;
            boolean bl = false;
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Failed to update Assurance floating button graphic. Application context is null", (Object[])new Object[0]);
        }
    }

    private final Bitmap getGraphic(Context context, int resource) {
        if (context == null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Failed to get Assurance floating button graphic. Application context is null", (Object[])new Object[0]);
            return this.backupGraphic;
        }
        Drawable drawable2 = AppCompatResources.getDrawable((Context)context, (int)resource);
        if (drawable2 == null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Failed to get Assurance floating button graphic. Drawable is null", (Object[])new Object[0]);
            return this.backupGraphic;
        }
        return DrawableKt.toBitmap$default((Drawable)drawable2, (int)0, (int)0, null, (int)7, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/floatingbutton/AssuranceFloatingButton$Companion;", "", "()V", "GRAPHIC_CORNER_RADIUS", "", "GRAPHIC_HEIGHT_DP", "", "GRAPHIC_WIDTH_DP", "LOG_TAG", "", "assurance_phoneRelease"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

