/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.adobe.marketing.mobile.assurance.internal.AssuranceAppState;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.ui.AssuranceNavRoute;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00072\u00020\u0001:\u0006\u0007\b\t\n\u000b\fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "", "route", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceNavRoute;", "(Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceNavRoute;)V", "getRoute", "()Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceNavRoute;", "Companion", "ErrorDestination", "PinDestination", "QuickConnectDestination", "StatusDestination", "Unknown", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$ErrorDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$PinDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$QuickConnectDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$StatusDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$Unknown;", "assurance_phoneRelease"})
public abstract class AssuranceDestination {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssuranceNavRoute route;

    private AssuranceDestination(AssuranceNavRoute route) {
        this.route = route;
    }

    @NotNull
    public final AssuranceNavRoute getRoute() {
        return this.route;
    }

    public /* synthetic */ AssuranceDestination(AssuranceNavRoute route, DefaultConstructorMarker $constructor_marker) {
        this(route);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$Companion;", "", "()V", "fromSessionPhase", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "sessionPhase", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$SessionPhase;", "fromSessionPhase$assurance_phoneRelease", "mapAuthorizingPhase", "authorizing", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$SessionPhase$Authorizing;", "mapDisconnectedPhase", "disconnected", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$SessionPhase$Disconnected;", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AssuranceDestination fromSessionPhase$assurance_phoneRelease(@NotNull AssuranceAppState.SessionPhase sessionPhase) {
            AssuranceDestination assuranceDestination;
            Intrinsics.checkNotNullParameter((Object)sessionPhase, (String)"sessionPhase");
            AssuranceAppState.SessionPhase sessionPhase2 = sessionPhase;
            if (sessionPhase2 instanceof AssuranceAppState.SessionPhase.Disconnected) {
                assuranceDestination = this.mapDisconnectedPhase((AssuranceAppState.SessionPhase.Disconnected)sessionPhase);
            } else if (sessionPhase2 instanceof AssuranceAppState.SessionPhase.Authorizing) {
                assuranceDestination = this.mapAuthorizingPhase((AssuranceAppState.SessionPhase.Authorizing)sessionPhase);
            } else if (Intrinsics.areEqual((Object)sessionPhase2, (Object)AssuranceAppState.SessionPhase.Connected.INSTANCE)) {
                assuranceDestination = StatusDestination.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return assuranceDestination;
        }

        private final AssuranceDestination mapAuthorizingPhase(AssuranceAppState.SessionPhase.Authorizing authorizing) {
            AssuranceDestination assuranceDestination;
            AssuranceAppState.AssuranceAuthorization assuranceAuthorization = authorizing.getAssuranceAuthorization();
            if (assuranceAuthorization instanceof AssuranceAppState.AssuranceAuthorization.PinConnect) {
                String sessionId = ((AssuranceAppState.AssuranceAuthorization.PinConnect)authorizing.getAssuranceAuthorization()).getSessionId();
                AssuranceConstants.AssuranceEnvironment environment = ((AssuranceAppState.AssuranceAuthorization.PinConnect)authorizing.getAssuranceAuthorization()).getEnvironment();
                assuranceDestination = new PinDestination(new AssuranceAppState.AssuranceAuthorization.PinConnect(sessionId, environment));
            } else if (assuranceAuthorization instanceof AssuranceAppState.AssuranceAuthorization.QuickConnect) {
                AssuranceConstants.AssuranceEnvironment environment = ((AssuranceAppState.AssuranceAuthorization.QuickConnect)authorizing.getAssuranceAuthorization()).getEnvironment();
                assuranceDestination = new QuickConnectDestination(new AssuranceAppState.AssuranceAuthorization.QuickConnect(environment));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return assuranceDestination;
        }

        private final AssuranceDestination mapDisconnectedPhase(AssuranceAppState.SessionPhase.Disconnected disconnected) {
            return disconnected.getReconnecting() ? (AssuranceDestination)StatusDestination.INSTANCE : (disconnected.getError() != null ? (AssuranceDestination)new ErrorDestination(disconnected) : (AssuranceDestination)Unknown.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$ErrorDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "disconnected", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$SessionPhase$Disconnected;", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$SessionPhase$Disconnected;)V", "getDisconnected", "()Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$SessionPhase$Disconnected;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "assurance_phoneRelease"})
    @StabilityInferred(parameters=0)
    public static final class ErrorDestination
    extends AssuranceDestination {
        @NotNull
        private final AssuranceAppState.SessionPhase.Disconnected disconnected;
        public static final int $stable;

        public ErrorDestination(@NotNull AssuranceAppState.SessionPhase.Disconnected disconnected) {
            Intrinsics.checkNotNullParameter((Object)disconnected, (String)"disconnected");
            super(AssuranceNavRoute.ErrorRoute.INSTANCE, null);
            this.disconnected = disconnected;
        }

        @NotNull
        public final AssuranceAppState.SessionPhase.Disconnected getDisconnected() {
            return this.disconnected;
        }

        @NotNull
        public final AssuranceAppState.SessionPhase.Disconnected component1() {
            return this.disconnected;
        }

        @NotNull
        public final ErrorDestination copy(@NotNull AssuranceAppState.SessionPhase.Disconnected disconnected) {
            Intrinsics.checkNotNullParameter((Object)disconnected, (String)"disconnected");
            return new ErrorDestination(disconnected);
        }

        public static /* synthetic */ ErrorDestination copy$default(ErrorDestination errorDestination, AssuranceAppState.SessionPhase.Disconnected disconnected, int n, Object object) {
            if ((n & 1) != 0) {
                disconnected = errorDestination.disconnected;
            }
            return errorDestination.copy(disconnected);
        }

        @NotNull
        public String toString() {
            return "ErrorDestination(disconnected=" + this.disconnected + ')';
        }

        public int hashCode() {
            return this.disconnected.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorDestination)) {
                return false;
            }
            ErrorDestination errorDestination = (ErrorDestination)other;
            return Intrinsics.areEqual((Object)this.disconnected, (Object)errorDestination.disconnected);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$PinDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "pinConnect", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$AssuranceAuthorization$PinConnect;", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$AssuranceAuthorization$PinConnect;)V", "getPinConnect", "()Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$AssuranceAuthorization$PinConnect;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "assurance_phoneRelease"})
    @StabilityInferred(parameters=0)
    public static final class PinDestination
    extends AssuranceDestination {
        @NotNull
        private final AssuranceAppState.AssuranceAuthorization.PinConnect pinConnect;
        public static final int $stable;

        public PinDestination(@NotNull AssuranceAppState.AssuranceAuthorization.PinConnect pinConnect) {
            Intrinsics.checkNotNullParameter((Object)pinConnect, (String)"pinConnect");
            super(AssuranceNavRoute.PinCodeRoute.INSTANCE, null);
            this.pinConnect = pinConnect;
        }

        @NotNull
        public final AssuranceAppState.AssuranceAuthorization.PinConnect getPinConnect() {
            return this.pinConnect;
        }

        @NotNull
        public final AssuranceAppState.AssuranceAuthorization.PinConnect component1() {
            return this.pinConnect;
        }

        @NotNull
        public final PinDestination copy(@NotNull AssuranceAppState.AssuranceAuthorization.PinConnect pinConnect) {
            Intrinsics.checkNotNullParameter((Object)pinConnect, (String)"pinConnect");
            return new PinDestination(pinConnect);
        }

        public static /* synthetic */ PinDestination copy$default(PinDestination pinDestination, AssuranceAppState.AssuranceAuthorization.PinConnect pinConnect, int n, Object object) {
            if ((n & 1) != 0) {
                pinConnect = pinDestination.pinConnect;
            }
            return pinDestination.copy(pinConnect);
        }

        @NotNull
        public String toString() {
            return "PinDestination(pinConnect=" + this.pinConnect + ')';
        }

        public int hashCode() {
            return this.pinConnect.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PinDestination)) {
                return false;
            }
            PinDestination pinDestination = (PinDestination)other;
            return Intrinsics.areEqual((Object)this.pinConnect, (Object)pinDestination.pinConnect);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$QuickConnectDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "quickConnect", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$AssuranceAuthorization$QuickConnect;", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$AssuranceAuthorization$QuickConnect;)V", "getQuickConnect", "()Lcom/adobe/marketing/mobile/assurance/internal/AssuranceAppState$AssuranceAuthorization$QuickConnect;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "assurance_phoneRelease"})
    @StabilityInferred(parameters=0)
    public static final class QuickConnectDestination
    extends AssuranceDestination {
        @NotNull
        private final AssuranceAppState.AssuranceAuthorization.QuickConnect quickConnect;
        public static final int $stable;

        public QuickConnectDestination(@NotNull AssuranceAppState.AssuranceAuthorization.QuickConnect quickConnect) {
            Intrinsics.checkNotNullParameter((Object)quickConnect, (String)"quickConnect");
            super(AssuranceNavRoute.QuickConnectRoute.INSTANCE, null);
            this.quickConnect = quickConnect;
        }

        @NotNull
        public final AssuranceAppState.AssuranceAuthorization.QuickConnect getQuickConnect() {
            return this.quickConnect;
        }

        @NotNull
        public final AssuranceAppState.AssuranceAuthorization.QuickConnect component1() {
            return this.quickConnect;
        }

        @NotNull
        public final QuickConnectDestination copy(@NotNull AssuranceAppState.AssuranceAuthorization.QuickConnect quickConnect) {
            Intrinsics.checkNotNullParameter((Object)quickConnect, (String)"quickConnect");
            return new QuickConnectDestination(quickConnect);
        }

        public static /* synthetic */ QuickConnectDestination copy$default(QuickConnectDestination quickConnectDestination, AssuranceAppState.AssuranceAuthorization.QuickConnect quickConnect, int n, Object object) {
            if ((n & 1) != 0) {
                quickConnect = quickConnectDestination.quickConnect;
            }
            return quickConnectDestination.copy(quickConnect);
        }

        @NotNull
        public String toString() {
            return "QuickConnectDestination(quickConnect=" + this.quickConnect + ')';
        }

        public int hashCode() {
            return this.quickConnect.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuickConnectDestination)) {
                return false;
            }
            QuickConnectDestination quickConnectDestination = (QuickConnectDestination)other;
            return Intrinsics.areEqual((Object)this.quickConnect, (Object)quickConnectDestination.quickConnect);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$StatusDestination;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "()V", "assurance_phoneRelease"})
    @StabilityInferred(parameters=0)
    public static final class StatusDestination
    extends AssuranceDestination {
        @NotNull
        public static final StatusDestination INSTANCE = new StatusDestination();
        public static final int $stable;

        private StatusDestination() {
            super(AssuranceNavRoute.StatusRoute.INSTANCE, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination$Unknown;", "Lcom/adobe/marketing/mobile/assurance/internal/ui/AssuranceDestination;", "()V", "assurance_phoneRelease"})
    @StabilityInferred(parameters=0)
    public static final class Unknown
    extends AssuranceDestination {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();
        public static final int $stable;

        private Unknown() {
            super(AssuranceNavRoute.UnknownRoute.INSTANCE, null);
        }
    }
}

