/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionOrchestrator;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionStatusListener;
import com.adobe.marketing.mobile.assurance.internal.SessionAuthorizingPresentationType;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J5\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/SessionUIOperationHandler;", "", "orchestrator", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSessionOrchestrator;", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSessionOrchestrator;)V", "onCancel", "", "onCancel$assurance_phoneRelease", "onConnect", "sessionId", "", "token", "environment", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;", "listener", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSessionStatusListener;", "authorizingPresentationType", "Lcom/adobe/marketing/mobile/assurance/internal/SessionAuthorizingPresentationType;", "onConnect$assurance_phoneRelease", "onDisconnect", "onDisconnect$assurance_phoneRelease", "Companion", "assurance_phoneRelease"})
public final class SessionUIOperationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssuranceSessionOrchestrator orchestrator;
    @NotNull
    private static final String LOG_TAG = "SessionUIOperationHandler";

    public SessionUIOperationHandler(@NotNull AssuranceSessionOrchestrator orchestrator) {
        Intrinsics.checkNotNullParameter((Object)orchestrator, (String)"orchestrator");
        this.orchestrator = orchestrator;
    }

    public final void onConnect$assurance_phoneRelease(@NotNull String sessionId, @NotNull String token, @NotNull AssuranceConstants.AssuranceEnvironment environment, @NotNull AssuranceSessionStatusListener listener, @NotNull SessionAuthorizingPresentationType authorizingPresentationType) {
        AssuranceSession activeSession;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)((Object)authorizingPresentationType), (String)"authorizingPresentationType");
        AssuranceSession assuranceSession = activeSession = this.orchestrator.getActiveSession();
        if (assuranceSession != null) {
            AssuranceSession it = assuranceSession;
            boolean bl = false;
            if (activeSession.getAuthorizingPresentationType() != authorizingPresentationType) {
                Log.warning((String)"Assurance", (String)LOG_TAG, (String)("Cannot start " + (Object)((Object)authorizingPresentationType) + " session. A " + (Object)((Object)activeSession.getAuthorizingPresentationType()) + " session exists."), (Object[])new Object[0]);
                listener.onSessionDisconnected(AssuranceConstants.AssuranceConnectionError.UNEXPECTED_ERROR);
            } else {
                Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Disconnecting active session of and recreating.", (Object[])new Object[0]);
                this.orchestrator.terminateSession(false);
            }
        }
        this.orchestrator.createSession(sessionId, environment, token, listener, authorizingPresentationType);
    }

    public final void onDisconnect$assurance_phoneRelease() {
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"On Disconnect clicked. Disconnecting session.", (Object[])new Object[0]);
        this.orchestrator.terminateSession(true);
    }

    public final void onCancel$assurance_phoneRelease() {
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"On Cancel Clicked. Disconnecting session.", (Object[])new Object[0]);
        this.orchestrator.terminateSession(true);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/SessionUIOperationHandler$Companion;", "", "()V", "LOG_TAG", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

