/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceStateManager;
import com.adobe.marketing.mobile.assurance.internal.QuickConnectCallback;
import com.adobe.marketing.mobile.assurance.internal.QuickConnectDeviceCreator;
import com.adobe.marketing.mobile.assurance.internal.QuickConnectDeviceStatusChecker;
import com.adobe.marketing.mobile.assurance.internal.Response;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002/0B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0001\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u001dH\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010!H\u0002J,\u0010(\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*H\u0002J\r\u0010-\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n8\u0000@BX\u0081\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR2\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00108\u0000@BX\u0081\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00158\u0000@BX\u0081\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectManager;", "", "assuranceSharedStateManager", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "quickConnectCallback", "Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectCallback;", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;Ljava/util/concurrent/ScheduledExecutorService;Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectCallback;)V", "<set-?>", "Ljava/util/concurrent/Future;", "deviceCreationTaskHandle", "getDeviceCreationTaskHandle$assurance_phoneRelease$annotations", "()V", "getDeviceCreationTaskHandle$assurance_phoneRelease", "()Ljava/util/concurrent/Future;", "Ljava/util/concurrent/ScheduledFuture;", "deviceStatusTaskHandle", "getDeviceStatusTaskHandle$assurance_phoneRelease$annotations", "getDeviceStatusTaskHandle$assurance_phoneRelease", "()Ljava/util/concurrent/ScheduledFuture;", "", "isActive", "isActive$assurance_phoneRelease$annotations", "isActive$assurance_phoneRelease", "()Z", "retryCount", "", "cancel", "", "cancel$assurance_phoneRelease", "checkDeviceStatus", "orgId", "", "clientId", "checkDeviceStatus$assurance_phoneRelease", "cleanup", "extractSessionDetails", "Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectManager$QuickConnectSessionDetails;", "jsonString", "handleStatusCheckResponse", "response", "Lcom/adobe/marketing/mobile/assurance/internal/Response;", "Lcom/adobe/marketing/mobile/services/HttpConnecting;", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceConnectionError;", "registerDevice", "registerDevice$assurance_phoneRelease", "Companion", "QuickConnectSessionDetails", "assurance_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nQuickConnectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickConnectManager.kt\ncom/adobe/marketing/mobile/assurance/internal/QuickConnectManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class QuickConnectManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssuranceStateManager assuranceSharedStateManager;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final QuickConnectCallback quickConnectCallback;
    private volatile int retryCount;
    private volatile boolean isActive;
    @Nullable
    private Future<?> deviceCreationTaskHandle;
    @Nullable
    private ScheduledFuture<?> deviceStatusTaskHandle;
    @NotNull
    private static final String LOG_SOURCE = "QuickConnectManager";

    public QuickConnectManager(@NotNull AssuranceStateManager assuranceSharedStateManager, @NotNull ScheduledExecutorService executorService, @NotNull QuickConnectCallback quickConnectCallback) {
        Intrinsics.checkNotNullParameter((Object)assuranceSharedStateManager, (String)"assuranceSharedStateManager");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)quickConnectCallback, (String)"quickConnectCallback");
        this.assuranceSharedStateManager = assuranceSharedStateManager;
        this.executorService = executorService;
        this.quickConnectCallback = quickConnectCallback;
    }

    public final boolean isActive$assurance_phoneRelease() {
        return this.isActive;
    }

    @VisibleForTesting
    public static /* synthetic */ void isActive$assurance_phoneRelease$annotations() {
    }

    @Nullable
    public final Future<?> getDeviceCreationTaskHandle$assurance_phoneRelease() {
        return this.deviceCreationTaskHandle;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDeviceCreationTaskHandle$assurance_phoneRelease$annotations() {
    }

    @Nullable
    public final ScheduledFuture<?> getDeviceStatusTaskHandle$assurance_phoneRelease() {
        return this.deviceStatusTaskHandle;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDeviceStatusTaskHandle$assurance_phoneRelease$annotations() {
    }

    public final void registerDevice$assurance_phoneRelease() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        String orgId = this.assuranceSharedStateManager.getOrgId(false);
        String clientId = this.assuranceSharedStateManager.getClientId();
        String deviceName = ServiceProvider.getInstance().getDeviceInfoService().getDeviceName();
        Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)("Attempting to register device with deviceName:" + deviceName + ", orgId: " + orgId + ", clientId: " + clientId + '.'), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)deviceName, (String)"deviceName");
        QuickConnectDeviceCreator quickConnectDeviceCreator = new QuickConnectDeviceCreator(orgId, clientId, deviceName, (AdobeCallback<Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError>>)((AdobeCallback)arg_0 -> QuickConnectManager.registerDevice$lambda$0(this, orgId, clientId, arg_0)));
        this.deviceCreationTaskHandle = this.executorService.submit(quickConnectDeviceCreator);
    }

    @VisibleForTesting
    public final void checkDeviceStatus$assurance_phoneRelease(@NotNull String orgId, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        QuickConnectDeviceStatusChecker statusCheckerTask = new QuickConnectDeviceStatusChecker(orgId, clientId, (AdobeCallback<Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError>>)((AdobeCallback)arg_0 -> QuickConnectManager.checkDeviceStatus$lambda$1(this, orgId, clientId, arg_0)));
        this.deviceStatusTaskHandle = this.executorService.schedule(statusCheckerTask, AssuranceConstants.QuickConnect.INSTANCE.getSTATUS_CHECK_DELAY_MS(), TimeUnit.MILLISECONDS);
    }

    public final void cancel$assurance_phoneRelease() {
        this.cleanup();
    }

    private final void handleStatusCheckResponse(String orgId, String clientId, Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError> response) {
        Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError> response2 = response;
        if (response2 instanceof Response.Success) {
            QuickConnectSessionDetails sessionDetails = this.extractSessionDetails(StreamUtils.readAsString((InputStream)((HttpConnecting)((Response.Success)response).getData()).getInputStream()));
            if (sessionDetails != null) {
                Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)"Received session details.", (Object[])new Object[0]);
                this.quickConnectCallback.onSuccess(sessionDetails.getSessionId(), sessionDetails.getToken());
                this.cleanup();
                return;
            }
            if (!this.isActive) {
                Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)"Will not retry. QuickConnect workflow already cancelled.", (Object[])new Object[0]);
                return;
            }
            ++this.retryCount;
            if (this.retryCount < 300) {
                Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)"Will retry device status check.", (Object[])new Object[0]);
                this.checkDeviceStatus$assurance_phoneRelease(orgId, clientId);
            } else {
                Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)"Will not retry. Maximum allowed retries for status check have been reached.", (Object[])new Object[0]);
                this.quickConnectCallback.onError(AssuranceConstants.AssuranceConnectionError.RETRY_LIMIT_REACHED);
                this.cleanup();
            }
        } else if (response2 instanceof Response.Failure) {
            Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)"Device status check request failed.", (Object[])new Object[0]);
            this.quickConnectCallback.onError((AssuranceConstants.AssuranceConnectionError)((Object)((Response.Failure)response).getError()));
            this.cleanup();
        }
    }

    private final QuickConnectSessionDetails extractSessionDetails(String jsonString) {
        CharSequence charSequence = jsonString;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        try {
            QuickConnectSessionDetails quickConnectSessionDetails;
            JSONObject jsonObject = new JSONObject(new JSONTokener(jsonString));
            String sessionUUID = jsonObject.optString("sessionUuid");
            String token = jsonObject.optString("token");
            if (StringUtils.isNullOrEmpty((String)sessionUUID) || StringUtils.isNullOrEmpty((String)token) || StringsKt.equals((String)"null", (String)sessionUUID, (boolean)true) || StringsKt.equals((String)"null", (String)token, (boolean)true)) {
                quickConnectSessionDetails = null;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)sessionUUID, (String)"sessionUUID");
                Intrinsics.checkNotNullExpressionValue((Object)token, (String)"token");
                quickConnectSessionDetails = new QuickConnectSessionDetails(sessionUUID, token);
            }
            charSequence = quickConnectSessionDetails;
        }
        catch (JSONException e) {
            charSequence = null;
        }
        return charSequence;
    }

    private final void cleanup() {
        Unit unit;
        Unit unit2;
        Unit unit3;
        Future<?> future = this.deviceCreationTaskHandle;
        if (future != null) {
            Future<?> it = future;
            boolean bl = false;
            it.cancel(true);
            Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)"QuickConnect device creation task cancelled", (Object[])new Object[0]);
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = null;
        }
        Unit it = unit2 = unit3;
        boolean bl = false;
        this.deviceCreationTaskHandle = null;
        ScheduledFuture<?> scheduledFuture = this.deviceStatusTaskHandle;
        if (scheduledFuture != null) {
            ScheduledFuture<?> it2 = scheduledFuture;
            boolean bl2 = false;
            it2.cancel(true);
            Log.debug((String)"Assurance", (String)LOG_SOURCE, (String)"QuickConnect device status task cancelled", (Object[])new Object[0]);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        it = unit2 = unit;
        boolean bl3 = false;
        this.deviceStatusTaskHandle = null;
        this.retryCount = 0;
        this.isActive = false;
    }

    private static final void registerDevice$lambda$0(QuickConnectManager this$0, String $orgId, String $clientId, Response it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$orgId, (String)"$orgId");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Response response = it;
        if (response instanceof Response.Success) {
            this$0.checkDeviceStatus$assurance_phoneRelease($orgId, $clientId);
        } else if (response instanceof Response.Failure) {
            this$0.quickConnectCallback.onError((AssuranceConstants.AssuranceConnectionError)((Object)((Response.Failure)it).getError()));
            this$0.cleanup();
        }
    }

    private static final void checkDeviceStatus$lambda$1(QuickConnectManager this$0, String $orgId, String $clientId, Response response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$orgId, (String)"$orgId");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        this$0.handleStatusCheckResponse($orgId, $clientId, response);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectManager$Companion;", "", "()V", "LOG_SOURCE", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectManager$QuickConnectSessionDetails;", "", "sessionId", "", "token", "(Ljava/lang/String;Ljava/lang/String;)V", "getSessionId", "()Ljava/lang/String;", "getToken", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "assurance_phoneRelease"})
    public static final class QuickConnectSessionDetails {
        @NotNull
        private final String sessionId;
        @NotNull
        private final String token;

        public QuickConnectSessionDetails(@NotNull String sessionId, @NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.sessionId = sessionId;
            this.token = token;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final String component2() {
            return this.token;
        }

        @NotNull
        public final QuickConnectSessionDetails copy(@NotNull String sessionId, @NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return new QuickConnectSessionDetails(sessionId, token);
        }

        public static /* synthetic */ QuickConnectSessionDetails copy$default(QuickConnectSessionDetails quickConnectSessionDetails, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = quickConnectSessionDetails.sessionId;
            }
            if ((n & 2) != 0) {
                string3 = quickConnectSessionDetails.token;
            }
            return quickConnectSessionDetails.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "QuickConnectSessionDetails(sessionId=" + this.sessionId + ", token=" + this.token + ')';
        }

        public int hashCode() {
            int result = this.sessionId.hashCode();
            result = result * 31 + this.token.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuickConnectSessionDetails)) {
                return false;
            }
            QuickConnectSessionDetails quickConnectSessionDetails = (QuickConnectSessionDetails)other;
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)quickConnectSessionDetails.sessionId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.token, (Object)quickConnectSessionDetails.token);
        }
    }
}

