/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.Response;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectDeviceCreator;", "Ljava/lang/Runnable;", "orgId", "", "clientId", "deviceName", "callback", "Lcom/adobe/marketing/mobile/AdobeCallback;", "Lcom/adobe/marketing/mobile/assurance/internal/Response;", "Lcom/adobe/marketing/mobile/services/HttpConnecting;", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceConnectionError;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/adobe/marketing/mobile/AdobeCallback;)V", "buildRequest", "Lcom/adobe/marketing/mobile/services/NetworkRequest;", "getCallback", "makeRequest", "", "networkRequest", "run", "Companion", "assurance_phoneRelease"})
public final class QuickConnectDeviceCreator
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String orgId;
    @NotNull
    private final String clientId;
    @NotNull
    private final String deviceName;
    @NotNull
    private final AdobeCallback<Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError>> callback;
    @NotNull
    private static final String LOG_SOURCE = "QuickConnectDeviceCreator";

    public QuickConnectDeviceCreator(@NotNull String orgId, @NotNull String clientId, @NotNull String deviceName, @NotNull AdobeCallback<Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError>> callback) {
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.orgId = orgId;
        this.clientId = clientId;
        this.deviceName = deviceName;
        this.callback = callback;
    }

    @Override
    public void run() {
        NetworkRequest networkRequest;
        try {
            networkRequest = this.buildRequest();
        }
        catch (Exception e) {
            Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)("Exception attempting to build request. " + e.getMessage()), (Object[])new Object[0]);
            networkRequest = null;
        }
        NetworkRequest networkRequest2 = networkRequest;
        if (networkRequest2 == null) {
            this.callback.call(new Response.Failure(AssuranceConstants.AssuranceConnectionError.CREATE_DEVICE_REQUEST_MALFORMED));
            return;
        }
        this.makeRequest(networkRequest2);
    }

    private final NetworkRequest buildRequest() {
        String url = "https://device.griffon.adobe.com/device/create";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Content-Type", (Object)"application/json")};
        Map headers = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"orgId", (Object)this.orgId), TuplesKt.to((Object)"deviceName", (Object)this.deviceName), TuplesKt.to((Object)"clientId", (Object)this.clientId)};
        Map body = MapsKt.mapOf((Pair[])pairArray2);
        JSONObject jsonBody = new JSONObject(body);
        String string2 = jsonBody.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonBody.toString()");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bodyBytes = byArray;
        return new NetworkRequest(url, HttpMethod.POST, bodyBytes, headers, AssuranceConstants.QuickConnect.INSTANCE.getCONNECTION_TIMEOUT_MS(), AssuranceConstants.QuickConnect.INSTANCE.getREAD_TIMEOUT_MS());
    }

    private final void makeRequest(NetworkRequest networkRequest) {
        ServiceProvider.getInstance().getNetworkService().connectAsync(networkRequest, arg_0 -> QuickConnectDeviceCreator.makeRequest$lambda$0(this, arg_0));
    }

    @VisibleForTesting
    @NotNull
    public final AdobeCallback<Response<HttpConnecting, AssuranceConstants.AssuranceConnectionError>> getCallback() {
        return this.callback;
    }

    private static final void makeRequest$lambda$0(QuickConnectDeviceCreator this$0, HttpConnecting response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (response == null) {
            this$0.callback.call(new Response.Failure(AssuranceConstants.AssuranceConnectionError.UNEXPECTED_ERROR));
            return;
        }
        int responseCode = response.getResponseCode();
        if (responseCode == 201 || 200 == responseCode) {
            Object[] objectArray = new Object[]{responseCode};
            Log.debug((String)"Assurance", (String)"Assurance", (String)"Registration request succeeded: %s", (Object[])objectArray);
            this$0.callback.call(new Response.Success(response));
        } else {
            Log.trace((String)"Assurance", (String)LOG_SOURCE, (String)("Device registration failed with code : " + responseCode + " and message: " + response.getResponseMessage() + '.'), (Object[])new Object[0]);
            this$0.callback.call(new Response.Failure(AssuranceConstants.AssuranceConnectionError.CREATE_DEVICE_REQUEST_FAILED));
        }
        response.close();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/QuickConnectDeviceCreator$Companion;", "", "()V", "LOG_SOURCE", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

