/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.assurance.internal.AssuranceClientInfo;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssuranceWebViewSocket;
import com.adobe.marketing.mobile.assurance.internal.EventQueueWorker;
import com.adobe.marketing.mobile.services.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.json.JSONObject;

class OutboundEventQueueWorker
extends EventQueueWorker<AssuranceEvent> {
    private static final String LOG_TAG = "OutboundEventQueueWorker";
    @VisibleForTesting
    static final int MAX_EVENT_SIZE = (int)Math.floor(24576.0);
    @VisibleForTesting
    static final int MAX_PAYLOAD_CHUNK_SIZE = (int)Math.floor(11520.0);
    private final AssuranceWebViewSocket socket;
    private final AssuranceClientInfo clientInfo;
    private final OutboundEventChunker outboundEventChunker;
    private volatile boolean canStartForwarding;

    OutboundEventQueueWorker(ExecutorService executorService, AssuranceWebViewSocket socket, AssuranceClientInfo clientInfo) {
        this(executorService, socket, clientInfo, new LinkedBlockingQueue<AssuranceEvent>(), new OutboundEventChunker(MAX_PAYLOAD_CHUNK_SIZE));
    }

    @VisibleForTesting
    OutboundEventQueueWorker(ExecutorService executorService, AssuranceWebViewSocket socket, AssuranceClientInfo clientInfo, LinkedBlockingQueue<AssuranceEvent> queue, OutboundEventChunker outboundEventChunker) {
        super(executorService, queue);
        this.socket = socket;
        this.clientInfo = clientInfo;
        this.outboundEventChunker = outboundEventChunker;
        this.canStartForwarding = false;
    }

    @Override
    protected void prepare() {
        this.sendClientInfoEvent();
    }

    @Override
    protected boolean canWork() {
        return this.canStartForwarding && this.socket != null && this.socket.getState() == AssuranceWebViewSocket.SocketReadyState.OPEN;
    }

    @Override
    protected void doWork(AssuranceEvent assuranceEvent) {
        this.sendEventToSocket(assuranceEvent);
    }

    void block() {
        this.canStartForwarding = false;
    }

    void unblock() {
        this.canStartForwarding = true;
        this.resume();
    }

    void sendClientInfoEvent() {
        if (this.canStartForwarding) {
            return;
        }
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Sending client info event to Assurance", (Object[])new Object[0]);
        AssuranceEvent clientInfoEvent = new AssuranceEvent("client", this.clientInfo.getData());
        this.sendEventToSocket(clientInfoEvent);
    }

    private void sendEventToSocket(AssuranceEvent event) {
        if (event == null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Cannot send null event.", (Object[])new Object[0]);
            return;
        }
        try {
            byte[] eventData = event.getJSONRepresentation().getBytes(Charset.forName("UTF-8"));
            if (eventData.length < MAX_EVENT_SIZE) {
                this.socket.sendData(eventData);
            } else {
                if (event.getPayload() == null) {
                    Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Cannot send eventId: %s that exceeds permitted limitbut has an empty payload!", (Object[])new Object[]{event.eventID});
                    return;
                }
                List<AssuranceEvent> chunkedEvents = this.outboundEventChunker.chunk(event);
                for (AssuranceEvent chunkedEvent : chunkedEvents) {
                    this.socket.sendData(chunkedEvent.getJSONRepresentation().getBytes(Charset.forName("UTF-8")));
                }
            }
        }
        catch (UnsupportedCharsetException ex) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)String.format("UnsupportedCharsetException while converting Assurance event object to bytes representation: %s", ex.getLocalizedMessage()), (Object[])new Object[0]);
        }
    }

    @Override
    void stop() {
        super.stop();
        this.canStartForwarding = false;
    }

    @VisibleForTesting
    static class OutboundEventChunker
    implements EventQueueWorker.EventChunker<AssuranceEvent, AssuranceEvent> {
        private final int maxChunkSize;

        OutboundEventChunker(int maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
        }

        @Override
        public List<AssuranceEvent> chunk(AssuranceEvent event) {
            if (event == null) {
                return Collections.EMPTY_LIST;
            }
            if (event.getPayload() == null) {
                Log.warning((String)"Assurance", (String)OutboundEventQueueWorker.LOG_TAG, (String)"Cannot chunk event: %s with an empty payload!", (Object[])new Object[]{event.eventID});
                return Collections.singletonList(event);
            }
            JSONObject payloadJson = new JSONObject(event.getPayload());
            byte[] payloadBytes = payloadJson.toString().getBytes(Charset.forName("UTF-8"));
            if (payloadBytes.length < this.maxChunkSize) {
                return Collections.singletonList(event);
            }
            ArrayList<AssuranceEvent> chunkedEvents = new ArrayList<AssuranceEvent>();
            double totalChunks = Math.ceil((double)payloadBytes.length / (double)this.maxChunkSize);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(payloadBytes);
            byte[] buffer = new byte[this.maxChunkSize];
            try {
                int bytesRead;
                String chunkId = UUID.randomUUID().toString();
                int chunkNumber = 0;
                while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                    HashMap<String, Object> payload = new HashMap<String, Object>();
                    payload.put("chunkData", new String(buffer, 0, bytesRead, Charset.forName("UTF-8")));
                    HashMap<String, Object> metadata = new HashMap<String, Object>();
                    metadata.put("chunkId", chunkId);
                    metadata.put("chunkTotal", (int)totalChunks);
                    metadata.put("chunkSequenceNumber", chunkNumber++);
                    AssuranceEvent assuranceEvent = new AssuranceEvent(event.vendor, event.type, metadata, payload, event.timestamp);
                    chunkedEvents.add(assuranceEvent);
                }
            }
            catch (IOException e) {
                Log.warning((String)"Assurance", (String)OutboundEventQueueWorker.LOG_TAG, (String)"Failed to chunk event with ID: %s. Exception: %s", (Object[])new Object[]{event.eventID, e.getMessage()});
                return Collections.EMPTY_LIST;
            }
            return chunkedEvents;
        }
    }
}

