/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.EventStitcher;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.SerialWorkDispatcher;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0011\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/InboundEventQueueWorker;", "", "listener", "Lcom/adobe/marketing/mobile/assurance/internal/InboundEventQueueWorker$InboundQueueEventListener;", "(Lcom/adobe/marketing/mobile/assurance/internal/InboundEventQueueWorker$InboundQueueEventListener;)V", "workDispatcher", "Lcom/adobe/marketing/mobile/util/SerialWorkDispatcher;", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceEvent;", "(Lcom/adobe/marketing/mobile/util/SerialWorkDispatcher;)V", "offer", "", "event", "start", "", "stop", "Companion", "InboundQueueEventListener", "WorkHandlerImpl", "assurance_phoneRelease"})
public final class InboundEventQueueWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SerialWorkDispatcher<AssuranceEvent> workDispatcher;
    @NotNull
    private static final String LOG_TAG = "InboundEventQueueWorker";

    public InboundEventQueueWorker(@NotNull InboundQueueEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this((SerialWorkDispatcher<AssuranceEvent>)new SerialWorkDispatcher(LOG_TAG, (SerialWorkDispatcher.WorkHandler)new WorkHandlerImpl(new EventStitcher((AdobeCallback<AssuranceEvent>)((AdobeCallback)listener::onInboundEvent)))));
    }

    @VisibleForTesting
    public InboundEventQueueWorker(@NotNull SerialWorkDispatcher<AssuranceEvent> workDispatcher) {
        Intrinsics.checkNotNullParameter(workDispatcher, (String)"workDispatcher");
        this.workDispatcher = workDispatcher;
    }

    public final void start() {
        SerialWorkDispatcher.State dispatcherState = this.workDispatcher.getState();
        if (dispatcherState != SerialWorkDispatcher.State.NOT_STARTED) {
            Log.trace((String)"Assurance", (String)LOG_TAG, (String)("Work dispatcher was already started and is in " + dispatcherState + " state."), (Object[])new Object[0]);
            return;
        }
        this.workDispatcher.start();
    }

    public final boolean offer(@NotNull AssuranceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.workDispatcher.getState() == SerialWorkDispatcher.State.SHUTDOWN) {
            Log.trace((String)"Assurance", (String)LOG_TAG, (String)"Cannot queue event. Work dispatcher was shutdown.", (Object[])new Object[0]);
            return false;
        }
        return this.workDispatcher.offer((Object)event);
    }

    public final void stop() {
        this.workDispatcher.shutdown();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/InboundEventQueueWorker$Companion;", "", "()V", "LOG_TAG", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/InboundEventQueueWorker$InboundQueueEventListener;", "", "onInboundEvent", "", "event", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceEvent;", "assurance_phoneRelease"})
    public static interface InboundQueueEventListener {
        public void onInboundEvent(@NotNull AssuranceEvent var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/InboundEventQueueWorker$WorkHandlerImpl;", "Lcom/adobe/marketing/mobile/util/SerialWorkDispatcher$WorkHandler;", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceEvent;", "eventStitcher", "Lcom/adobe/marketing/mobile/assurance/internal/EventStitcher;", "(Lcom/adobe/marketing/mobile/assurance/internal/EventStitcher;)V", "doWork", "", "item", "assurance_phoneRelease"})
    @VisibleForTesting
    public static final class WorkHandlerImpl
    implements SerialWorkDispatcher.WorkHandler<AssuranceEvent> {
        @NotNull
        private final EventStitcher eventStitcher;

        public WorkHandlerImpl(@NotNull EventStitcher eventStitcher) {
            Intrinsics.checkNotNullParameter((Object)eventStitcher, (String)"eventStitcher");
            this.eventStitcher = eventStitcher;
        }

        public boolean doWork(@NotNull AssuranceEvent item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!EventStitcher.Companion.isChunked(item) && item.getControlType() == null) {
                String string2 = "Received a nonControl Assurance event.Ignoring processing of the inbound event - %s";
                Object[] objectArray = new Object[]{item.toString()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                Log.warning((String)"Assurance", (String)InboundEventQueueWorker.LOG_TAG, (String)string3, (Object[])new Object[0]);
                return true;
            }
            try {
                this.eventStitcher.onEvent(item);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{e.getLocalizedMessage()};
                Log.debug((String)"Assurance", (String)InboundEventQueueWorker.LOG_TAG, (String)"Error while processing inbound event", (Object[])objectArray);
            }
            return true;
        }
    }
}

