/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.Response;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.JSONUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B/\b\u0016\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0001J+\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0001\u00a2\u0006\u0002\b\u0013R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/EventStitcher;", "", "notifier", "Lcom/adobe/marketing/mobile/AdobeCallback;", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceEvent;", "(Lcom/adobe/marketing/mobile/AdobeCallback;)V", "queue", "", "", "", "(Ljava/util/Map;Lcom/adobe/marketing/mobile/AdobeCallback;)V", "onEvent", "", "event", "stitch", "Lcom/adobe/marketing/mobile/assurance/internal/Response;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "chunkedEvents", "stitch$assurance_phoneRelease", "Companion", "assurance_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nEventStitcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventStitcher.kt\ncom/adobe/marketing/mobile/assurance/internal/EventStitcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1002#2,2:145\n1855#2,2:147\n*S KotlinDebug\n*F\n+ 1 EventStitcher.kt\ncom/adobe/marketing/mobile/assurance/internal/EventStitcher\n*L\n108#1:145,2\n118#1:147,2\n*E\n"})
public final class EventStitcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<AssuranceEvent>> queue;
    @NotNull
    private final AdobeCallback<AssuranceEvent> notifier;
    @NotNull
    public static final String LOG_TAG = "EventStitcher";

    public EventStitcher(@NotNull AdobeCallback<AssuranceEvent> notifier) {
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        this(new LinkedHashMap(), notifier);
    }

    public EventStitcher(@NotNull Map<String, List<AssuranceEvent>> queue, @NotNull AdobeCallback<AssuranceEvent> notifier) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        this.queue = queue;
        this.notifier = notifier;
    }

    @JvmName(name="onEvent")
    public final void onEvent(@NotNull AssuranceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Companion.isChunked(event)) {
            this.notifier.call((Object)event);
            return;
        }
        String string2 = (String)event.metadata.get("chunkId");
        if (string2 == null) {
            return;
        }
        String chunkId = string2;
        Integer n = (Integer)event.metadata.get("chunkTotal");
        if (n == null) {
            return;
        }
        int totalChunks = n;
        List list = this.queue.get(chunkId);
        if (list == null) {
            list = new ArrayList();
        }
        List chunkedEventsForId = list;
        chunkedEventsForId.add((AssuranceEvent)event);
        if (chunkedEventsForId.size() == totalChunks) {
            Response<AssuranceEvent, Exception> result = this.stitch$assurance_phoneRelease(chunkedEventsForId);
            Response<AssuranceEvent, Exception> response = result;
            if (response instanceof Response.Success) {
                this.notifier.call(((Response.Success)result).getData());
            } else if (response instanceof Response.Failure) {
                Log.error((String)"Assurance", (String)LOG_TAG, (String)("Failed to stitch events for chunkId: " + chunkId + " due to: " + ((Exception)((Response.Failure)result).getError()).getMessage()), (Object[])new Object[0]);
            }
            this.queue.remove(chunkId);
        } else {
            this.queue.put(chunkId, chunkedEventsForId);
        }
    }

    @VisibleForTesting
    @NotNull
    public final Response<AssuranceEvent, Exception> stitch$assurance_phoneRelease(@NotNull List<AssuranceEvent> chunkedEvents) {
        Response response;
        Intrinsics.checkNotNullParameter(chunkedEvents, (String)"chunkedEvents");
        if (chunkedEvents.isEmpty()) {
            return new Response.Failure(new Exception("No events to stitch"));
        }
        Log.trace((String)"Assurance", (String)LOG_TAG, (String)("Stitching " + chunkedEvents.size() + " events"), (Object[])new Object[0]);
        List<AssuranceEvent> $this$sortBy$iv = chunkedEvents;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AssuranceEvent it = (AssuranceEvent)a;
                    boolean bl = false;
                    Object object = it.metadata.get("chunkSequenceNumber");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    it = (AssuranceEvent)b;
                    Comparable comparable = (Integer)object;
                    bl = false;
                    Object object2 = it.metadata.get("chunkSequenceNumber");
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)object2));
                }
            });
        }
        String eventType = chunkedEvents.get(0).getEventType();
        String eventVendor = chunkedEvents.get((int)0).vendor;
        long eventTimeStamp = chunkedEvents.get((int)0).timestamp;
        StringBuilder payload = new StringBuilder();
        Iterable $this$forEach$iv = chunkedEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            String it;
            AssuranceEvent chunkedEvent = (AssuranceEvent)element$iv;
            boolean bl = false;
            String chunkData = (String)chunkedEvent.payload.get("chunkData");
            if (chunkData == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getBytes(Charsets.UTF_8), (String)"this as java.lang.String).getBytes(charset)");
            Charset charset = Charsets.UTF_8;
            String utf8ChunkData = new String(byArray, charset);
            payload.append(utf8ChunkData);
        }
        try {
            JSONObject payloadJson = new JSONObject(payload.toString());
            Map payloadMap = JSONUtils.toMap((JSONObject)payloadJson);
            response = new Response.Success(new AssuranceEvent(eventVendor, eventType, null, payloadMap, eventTimeStamp));
        }
        catch (JSONException e) {
            response = new Response.Failure(e);
        }
        return response;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/EventStitcher$Companion;", "", "()V", "LOG_TAG", "", "isChunked", "", "event", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceEvent;", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="isChunked")
        public final boolean isChunked(@NotNull AssuranceEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.metadata == null) {
                return false;
            }
            String chunkId = (String)event.metadata.get("chunkId");
            Integer chunkSequenceNumber = (Integer)event.metadata.get("chunkSequenceNumber");
            return chunkId != null && chunkSequenceNumber != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

