/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.services.Log;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

abstract class EventQueueWorker<T>
implements Runnable {
    private static final String LOG_TAG = "EventChunker";
    private final LinkedBlockingQueue<T> workQueue;
    private final ExecutorService executorService;
    private Future<?> future;
    private boolean isActive;
    private final Object activenessMutex = new Object();

    @VisibleForTesting
    EventQueueWorker(ExecutorService executorService, LinkedBlockingQueue<T> workQueue) {
        this.workQueue = workQueue;
        this.executorService = executorService;
    }

    boolean offer(T workItem) {
        boolean result = this.workQueue.offer(workItem);
        this.resume();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean start() {
        Object object = this.activenessMutex;
        synchronized (object) {
            if (this.isActive) {
                Log.debug((String)"Assurance", (String)LOG_TAG, (String)"EventQueueWorker is already running.", (Object[])new Object[0]);
                return false;
            }
            this.isActive = true;
        }
        this.prepare();
        this.resume();
        return true;
    }

    protected abstract void prepare();

    protected abstract boolean canWork();

    @Override
    public void run() {
        while (!Thread.interrupted() && this.canWork() && this.workQueue.peek() != null) {
            try {
                T event = this.workQueue.poll();
                this.doWork(event);
            }
            catch (InterruptedException exception) {
                Log.error((String)"Assurance", (String)LOG_TAG, (String)("Background worker thread(InboundEventWorker) interrupted: " + exception.getLocalizedMessage()), (Object[])new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"No more items to process. Finishing current job : %s for %s", (Object[])new Object[]{Thread.currentThread().toString(), this.getClass().getSimpleName()});
    }

    protected abstract void doWork(T var1) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.activenessMutex;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.isActive = false;
        }
        this.workQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        Object object = this.activenessMutex;
        synchronized (object) {
            if (!this.isActive || this.future != null && !this.future.isDone()) {
                return;
            }
            this.future = this.executorService.submit(this);
        }
    }

    static interface EventChunker<T, V> {
        public List<V> chunk(T var1);
    }
}

