/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.webkit.ConsoleMessage;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.assurance.internal.AssuranceWebViewSocketHandler;
import com.adobe.marketing.mobile.services.Log;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

final class AssuranceWebViewSocket {
    private static final String LOG_TAG = "AssuranceWebViewSocket";
    private static final String WEBSOCKET_HTML_PATH = "file:///android_asset/WebviewSocket.html";
    static final int MAX_DATA_LENGTH = 32768;
    private final ExecutorService webViewExecutor;
    private final Semaphore initSemaphore;
    private final Semaphore mainThreadJoinSemaphore;
    private final AssuranceWebViewSocketHandler handler;
    private WebView webView;
    private SocketReadyState state;
    private String connectionURL;
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    AssuranceWebViewSocket(AssuranceWebViewSocketHandler handler) {
        this(handler, null);
    }

    AssuranceWebViewSocket(AssuranceWebViewSocketHandler handler, WebView webView) {
        this.handler = handler;
        this.setState(SocketReadyState.UNKNOWN);
        this.webViewExecutor = Executors.newSingleThreadExecutor();
        this.initSemaphore = new Semaphore(0);
        this.mainThreadJoinSemaphore = new Semaphore(1);
    }

    void connect(String url) {
        if (!AssuranceUtil.isSafe(url)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"URL is malformed, will not attempt to connect.", (Object[])new Object[0]);
            return;
        }
        this.setState(SocketReadyState.CONNECTING);
        this.runJavascript("connect('" + url + "')");
        this.connectionURL = url;
    }

    void disconnect() {
        this.setState(SocketReadyState.CLOSING);
        this.runJavascript("disconnect()");
        this.connectionURL = null;
    }

    void sendData(byte[] data) {
        String encodedData = Base64.encodeToString((byte[])data, (int)3);
        if (encodedData.length() > 32768) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)("Unable to send data packet, payload was " + encodedData.length() + " bytes, maximum is " + 32768 + "."), (Object[])new Object[0]);
            return;
        }
        this.runJavascript("sendData('" + encodedData + "')");
    }

    String getConnectionURL() {
        return this.connectionURL;
    }

    SocketReadyState getState() {
        return this.state;
    }

    private void setState(SocketReadyState newState) {
        this.state = newState;
        if (this.handler != null) {
            this.handler.onSocketStateChange(this, newState);
        }
    }

    private void runJavascript(final String jsString) {
        this.runOnSocketThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AssuranceWebViewSocket.this.webView == null) {
                        AssuranceWebViewSocket.this.initializeWebView();
                        AssuranceWebViewSocket.this.initSemaphore.acquire();
                    }
                    AssuranceWebViewSocket.this.mainThreadJoinSemaphore.acquire();
                }
                catch (InterruptedException ex) {
                    Log.error((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)String.format("Socket unable to wait for JS semaphore: %s", ex.getLocalizedMessage()), (Object[])new Object[0]);
                }
                AssuranceWebViewSocket.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AssuranceWebViewSocket.this.webView != null) {
                            AssuranceWebViewSocket.this.webView.loadUrl("javascript: " + jsString);
                        } else {
                            Log.error((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)"WebView is null, unable to execute JS for socket communication.", (Object[])new Object[0]);
                        }
                        AssuranceWebViewSocket.this.mainThreadJoinSemaphore.release();
                    }
                });
            }
        });
    }

    private void initializeWebView() {
        final WeakReference<AssuranceWebViewSocket> weakThisReference = new WeakReference<AssuranceWebViewSocket>(this);
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AssuranceWebViewSocket currentSocket = (AssuranceWebViewSocket)weakThisReference.get();
                    if (currentSocket == null) {
                        Log.error((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)"Current Socket is null", (Object[])new Object[0]);
                        return;
                    }
                    ClassLoader cl = currentSocket.getClass().getClassLoader();
                    if (cl == null) {
                        Log.error((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)"Socket unable to get class loader.", (Object[])new Object[0]);
                        return;
                    }
                    currentSocket.webView = AssuranceWebViewSocket.this.webView == null ? new WebView((Context)MobileCore.getApplication()) : AssuranceWebViewSocket.this.webView;
                    WebSettings webSettings = currentSocket.webView.getSettings();
                    webSettings.setJavaScriptEnabled(true);
                    webSettings.setAllowContentAccess(false);
                    webSettings.setAllowFileAccess(false);
                    currentSocket.webView.setWebViewClient((WebViewClient)new WebViewSocketClient());
                    currentSocket.webView.setWebChromeClient(new WebChromeClient(){

                        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                            if (consoleMessage.messageLevel() == ConsoleMessage.MessageLevel.ERROR) {
                                Log.error((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)consoleMessage.message(), (Object[])new Object[0]);
                            }
                            return super.onConsoleMessage(consoleMessage);
                        }
                    });
                    currentSocket.webView.addJavascriptInterface((Object)new WebViewJavascriptInterface(currentSocket), "nativeCode");
                    currentSocket.webView.loadUrl(AssuranceWebViewSocket.WEBSOCKET_HTML_PATH);
                }
                catch (Exception ex) {
                    Log.error((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)("Unexpected exception while initializing webview: " + ex.getLocalizedMessage()), (Object[])new Object[0]);
                }
            }
        });
    }

    private void runOnSocketThread(Runnable r) {
        this.webViewExecutor.submit(r);
    }

    private void runOnMainThread(Runnable r) {
        this.mainThreadHandler.post(r);
    }

    public static enum SocketReadyState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED,
        UNKNOWN;

    }

    private final class WebViewSocketClient
    extends WebViewClient {
        private WebViewSocketClient() {
        }

        public void onPageFinished(WebView wv, String url) {
            Log.trace((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)"Socket web content finished loading.", (Object[])new Object[0]);
            AssuranceWebViewSocket.this.initSemaphore.release();
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            Log.debug((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)"Socket encountered page error: %s", (Object[])new Object[]{error});
        }
    }

    private final class WebViewJavascriptInterface {
        private WeakReference<AssuranceWebViewSocket> parentSocket;

        WebViewJavascriptInterface(AssuranceWebViewSocket parentSocket) {
            this.parentSocket = new WeakReference<AssuranceWebViewSocket>(parentSocket);
        }

        @JavascriptInterface
        public void onMessageReceived(String data) {
            if (AssuranceWebViewSocket.this.handler != null) {
                AssuranceWebViewSocket.this.handler.onSocketDataReceived((AssuranceWebViewSocket)this.parentSocket.get(), data);
            }
        }

        @JavascriptInterface
        public void onSocketOpened() {
            AssuranceWebViewSocket.this.setState(SocketReadyState.OPEN);
            if (AssuranceWebViewSocket.this.handler != null) {
                AssuranceWebViewSocket.this.handler.onSocketConnected((AssuranceWebViewSocket)this.parentSocket.get());
            }
        }

        @JavascriptInterface
        public void onSocketClosed(String reason, short closeCode, boolean wasClean) {
            AssuranceWebViewSocket.this.setState(SocketReadyState.CLOSED);
            if (AssuranceWebViewSocket.this.handler != null) {
                AssuranceWebViewSocket.this.handler.onSocketDisconnected((AssuranceWebViewSocket)this.parentSocket.get(), reason, closeCode, wasClean);
            }
        }

        @JavascriptInterface
        public void onSocketError() {
            AssuranceWebViewSocket.this.setState(SocketReadyState.CLOSED);
            if (AssuranceWebViewSocket.this.handler != null) {
                AssuranceWebViewSocket.this.handler.onSocketError((AssuranceWebViewSocket)this.parentSocket.get());
            }
        }

        @JavascriptInterface
        public void log(String logMsg) {
            Log.trace((String)"Assurance", (String)AssuranceWebViewSocket.LOG_TAG, (String)("JSLog: " + logMsg), (Object[])new Object[0]);
        }
    }
}

