/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Activity;
import android.app.Application;
import android.net.ParseException;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.ui.AssuranceActivity;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class AssuranceUtil {
    private static final HashSet<String> VALID_CONNECTION_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("clientId", "orgId", "sessionId", "token"));
    private static final Pattern CONNECTION_ROUTE_REGEX = Pattern.compile("(connect)(-)?(.*)(\\.griffon\\.adobe\\.com)");

    AssuranceUtil() {
    }

    static String getURLFormatForEnvironment(AssuranceConstants.AssuranceEnvironment assuranceEnvironment) {
        if (assuranceEnvironment == null || assuranceEnvironment == AssuranceConstants.AssuranceEnvironment.PROD) {
            return "";
        }
        return String.format("-%s", assuranceEnvironment.stringValue);
    }

    static AssuranceConstants.AssuranceEnvironment getEnvironmentFromQueryValue(String queryValue) {
        if (StringUtils.isNullOrEmpty((String)queryValue)) {
            return AssuranceConstants.AssuranceEnvironment.PROD;
        }
        return AssuranceConstants.AssuranceEnvironment.get(queryValue);
    }

    @NonNull
    static AssuranceConstants.AssuranceEnvironment getEnvironmentFromSocketUri(Uri uri) {
        if (uri == null || uri.getHost() == null) {
            return AssuranceConstants.AssuranceEnvironment.PROD;
        }
        Matcher matcher = CONNECTION_ROUTE_REGEX.matcher(uri.getHost());
        if (!matcher.find()) {
            return AssuranceConstants.AssuranceEnvironment.PROD;
        }
        if (matcher.groupCount() < 3) {
            return AssuranceConstants.AssuranceEnvironment.PROD;
        }
        String environment = matcher.group(3);
        return AssuranceConstants.AssuranceEnvironment.get(environment);
    }

    static String getValidSessionIDFromUri(Uri deeplinkUri) {
        if (deeplinkUri == null) {
            return null;
        }
        String uuidSessionID = deeplinkUri.getQueryParameter("adb_validation_sessionid");
        if (StringUtils.isNullOrEmpty((String)uuidSessionID)) {
            return null;
        }
        try {
            UUID id = UUID.fromString(uuidSessionID);
            if (id.toString().equals(uuidSessionID)) {
                return uuidSessionID;
            }
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
        return null;
    }

    static boolean isNullOrEmpty(Map<String, Object> map) {
        return map == null || map.isEmpty();
    }

    static boolean isStringMap(Map<?, ?> map) {
        if (map == null) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() != null && entry.getKey() instanceof String) continue;
            return false;
        }
        return true;
    }

    static boolean isSafe(String url) {
        if (url == null) {
            return true;
        }
        Uri uri = Uri.parse((String)url);
        if (uri == null) {
            return false;
        }
        String host = uri.getHost();
        String scheme = uri.getScheme();
        String path = uri.getPath();
        if (!(AssuranceUtil.isValidScheme(scheme) && AssuranceUtil.isValidHostPath(host, path) && AssuranceUtil.hasValidQueryParams(uri))) {
            return false;
        }
        String sessionId = uri.getQueryParameter("sessionId");
        if (sessionId != null && !AssuranceUtil.isValidUUID(sessionId)) {
            return false;
        }
        String clientId = uri.getQueryParameter("clientId");
        if (clientId != null && !AssuranceUtil.isValidUUID(clientId)) {
            return false;
        }
        String orgId = uri.getQueryParameter("orgId");
        if (orgId != null && !AssuranceUtil.isValidOrgId(orgId)) {
            return false;
        }
        String token = uri.getQueryParameter("token");
        return token == null || AssuranceUtil.isValidToken(token);
    }

    static boolean isDebugBuild(@NonNull Application application) {
        return (application.getApplicationContext().getApplicationInfo().flags & 2) != 0;
    }

    static boolean isAssuranceActivity(@NonNull Activity activity2) {
        return activity2 instanceof AssuranceActivity;
    }

    private static boolean isValidScheme(String scheme) {
        return "wss".equalsIgnoreCase(scheme);
    }

    private static boolean isValidHostPath(String host, String path) {
        Matcher matcher = CONNECTION_ROUTE_REGEX.matcher(host);
        if (!matcher.find()) {
            return false;
        }
        String env = matcher.group(3);
        if (!AssuranceUtil.isValidEnvironment(env)) {
            return false;
        }
        return "/client/v1".equalsIgnoreCase(path);
    }

    private static boolean isValidUUID(@NonNull String uuid) {
        try {
            UUID uUID = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidOrgId(@NonNull String orgId) {
        return orgId.endsWith("@AdobeOrg");
    }

    private static boolean isValidEnvironment(String env) {
        if (StringUtils.isNullOrEmpty((String)env)) {
            return true;
        }
        String resolvedEnv = AssuranceConstants.AssuranceEnvironment.get((String)env).stringValue;
        return resolvedEnv.equalsIgnoreCase(env);
    }

    private static boolean isValidToken(@NonNull String token) {
        try {
            return token.length() == 4 && Integer.parseInt(token) > 0;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static boolean hasValidQueryParams(@NonNull Uri uri) {
        for (String param : uri.getQueryParameterNames()) {
            if (VALID_CONNECTION_PARAMETER_NAMES.contains(param)) continue;
            return false;
        }
        return true;
    }
}

