/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSharedStateManager;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0001J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0001J&\u0010\u0011\u001a\u00020\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0001J\b\u0010\u0018\u001a\u00020\u0010H\u0001J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0012\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\tH\u0001J8\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0012\u0010%\u001a\u00020\u000b2\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0001J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager;", "", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/ExtensionApi;)V", "assuranceSharedStateManager", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedStateManager;", "(Lcom/adobe/marketing/mobile/ExtensionApi;Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedStateManager;)V", "lastSDKEvent", "Lcom/adobe/marketing/mobile/Event;", "clearAssuranceSharedState", "", "getAllExtensionStateData", "", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceEvent;", "getClientId", "", "getFriendlyExtensionName", "extensionsMap", "", "extensionName", "getOrgId", "urlEncoded", "", "getSessionId", "getStateForExtension", "stateOwner", "eventName", "isSharedStateSet", "result", "Lcom/adobe/marketing/mobile/SharedStateResult;", "onSDKEvent", "event", "prepareSharedStateEvent", "owner", "stateContent", "stateType", "shareAssuranceSharedState", "sessionID", "urlEncode", "content", "Companion", "assurance_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nAssuranceStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssuranceStateManager.kt\ncom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n1855#2,2:325\n*S KotlinDebug\n*F\n+ 1 AssuranceStateManager.kt\ncom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager\n*L\n186#1:325,2\n*E\n"})
public final class AssuranceStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionApi extensionApi;
    @NotNull
    private final AssuranceSharedStateManager assuranceSharedStateManager;
    @Nullable
    private Event lastSDKEvent;
    @NotNull
    private static final String LOG_TAG = "AssuranceStateManager";

    public AssuranceStateManager(@NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        DataStoring dataStoring = ServiceProvider.getInstance().getDataStoreService();
        Intrinsics.checkNotNullExpressionValue((Object)dataStoring, (String)"getInstance().dataStoreService");
        this(extensionApi, new AssuranceSharedStateManager(dataStoring));
    }

    @VisibleForTesting
    public AssuranceStateManager(@NotNull ExtensionApi extensionApi, @NotNull AssuranceSharedStateManager assuranceSharedStateManager) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        Intrinsics.checkNotNullParameter((Object)assuranceSharedStateManager, (String)"assuranceSharedStateManager");
        this.extensionApi = extensionApi;
        this.assuranceSharedStateManager = assuranceSharedStateManager;
    }

    @JvmName(name="getSessionId")
    @NotNull
    public final String getSessionId() {
        return this.assuranceSharedStateManager.getAssuranceSharedState().getSessionId();
    }

    @JvmName(name="getClientId")
    @NotNull
    public final String getClientId() {
        return this.assuranceSharedStateManager.getAssuranceSharedState().getClientId();
    }

    @JvmName(name="onSDKEvent")
    public final void onSDKEvent(@Nullable Event event) {
        this.lastSDKEvent = event;
    }

    @JvmName(name="shareAssuranceSharedState")
    public final void shareAssuranceSharedState(@Nullable String sessionID) {
        this.assuranceSharedStateManager.setSessionId(sessionID);
        Map<String, Object> sharedState = this.assuranceSharedStateManager.getAssuranceSharedState().asMap$assurance_phoneRelease();
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)("Assurance shared state updated: \n " + sharedState), (Object[])new Object[0]);
        this.extensionApi.createSharedState(sharedState, this.lastSDKEvent);
    }

    @JvmName(name="clearAssuranceSharedState")
    public final void clearAssuranceSharedState() {
        this.assuranceSharedStateManager.setSessionId(null);
        this.extensionApi.createSharedState(MapsKt.emptyMap(), null);
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Assurance shared state cleared", (Object[])new Object[0]);
    }

    @JvmName(name="getOrgId")
    @NotNull
    public final String getOrgId(boolean urlEncoded) {
        String string2;
        SharedStateResult latestConfigSharedStateResult = this.extensionApi.getSharedState("com.adobe.module.configuration", this.lastSDKEvent, false, SharedStateResolution.ANY);
        if (!this.isSharedStateSet(latestConfigSharedStateResult)) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"SDK configuration is not available to read OrgId", (Object[])new Object[0]);
            return "";
        }
        SharedStateResult sharedStateResult = latestConfigSharedStateResult;
        Map latestConfigSharedState = sharedStateResult != null ? sharedStateResult.getValue() : null;
        Map map = latestConfigSharedState;
        if (map == null || map.isEmpty()) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"SDK configuration is not available to read OrgId", (Object[])new Object[0]);
            return "";
        }
        String orgId = DataReader.optString((Map)latestConfigSharedState, (String)"experienceCloud.org", (String)"");
        CharSequence charSequence = orgId;
        if (charSequence == null || charSequence.length() == 0) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Org id is null or empty", (Object[])new Object[0]);
            return "";
        }
        if (!urlEncoded) {
            String string3 = orgId;
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            orgId\n        }");
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)orgId, (String)"orgId");
            string2 = this.urlEncode(orgId);
        }
        return string2;
    }

    @JvmName(name="getAllExtensionStateData")
    @NotNull
    public final List<AssuranceEvent> getAllExtensionStateData() {
        List states = new ArrayList();
        SharedStateResult eventHubSharedStateResult = this.extensionApi.getSharedState("com.adobe.module.eventhub", this.lastSDKEvent, false, SharedStateResolution.ANY);
        if (!this.isSharedStateSet(eventHubSharedStateResult)) {
            return states;
        }
        SharedStateResult sharedStateResult = eventHubSharedStateResult;
        Map registeredExtensions = sharedStateResult != null ? sharedStateResult.getValue() : null;
        Map map = registeredExtensions;
        if (map == null || map.isEmpty()) {
            return states;
        }
        states.addAll((Collection)this.getStateForExtension("com.adobe.module.eventhub", "EventHub State"));
        Map map2 = DataReader.optTypedMap(Object.class, (Map)registeredExtensions, (String)"extensions", null);
        if (map2 == null) {
            return states;
        }
        Map extensionsMap = map2;
        Iterable $this$forEach$iv = extensionsMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String extensionName = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)extensionName, (String)"extensionName");
            String friendlyName = this.getFriendlyExtensionName(extensionsMap, extensionName);
            states.addAll((Collection)this.getStateForExtension(extensionName, friendlyName + " State"));
        }
        return states;
    }

    private final List<AssuranceEvent> getStateForExtension(String stateOwner, String eventName) {
        SharedStateResult xdmSharedState;
        List stateEvents = new ArrayList();
        SharedStateResult regularSharedState = this.extensionApi.getSharedState(stateOwner, this.lastSDKEvent, false, SharedStateResolution.ANY);
        if (this.isSharedStateSet(regularSharedState)) {
            SharedStateResult sharedStateResult = regularSharedState;
            Map map = sharedStateResult != null ? sharedStateResult.getValue() : null;
            if (!(map == null || map.isEmpty())) {
                SharedStateResult sharedStateResult2 = regularSharedState;
                stateEvents.add(this.prepareSharedStateEvent(stateOwner, eventName, sharedStateResult2 != null ? sharedStateResult2.getValue() : null, "state.data"));
            }
        }
        if (this.isSharedStateSet(xdmSharedState = this.extensionApi.getXDMSharedState(stateOwner, this.lastSDKEvent, false, SharedStateResolution.ANY))) {
            SharedStateResult sharedStateResult = xdmSharedState;
            Map map = sharedStateResult != null ? sharedStateResult.getValue() : null;
            if (!(map == null || map.isEmpty())) {
                SharedStateResult sharedStateResult3 = xdmSharedState;
                stateEvents.add(this.prepareSharedStateEvent(stateOwner, eventName, sharedStateResult3 != null ? sharedStateResult3.getValue() : null, "xdm.state.data"));
            }
        }
        return stateEvents;
    }

    private final AssuranceEvent prepareSharedStateEvent(String owner, String eventName, Map<String, ? extends Object> stateContent, String stateType) {
        Map payload = new HashMap();
        payload.put("ACPExtensionEventName", eventName);
        payload.put("ACPExtensionEventType", "com.adobe.eventType.hub");
        payload.put("ACPExtensionEventSource", "com.adobe.eventSource.sharedState");
        payload.put("ACPExtensionEventData", MapsKt.mapOf((Pair)TuplesKt.to((Object)"stateowner", (Object)owner)));
        Map stateData = new HashMap();
        stateData.put(stateType, stateContent);
        payload.put("metadata", stateData);
        return new AssuranceEvent("generic", payload);
    }

    private final String getFriendlyExtensionName(Map<String, ? extends Object> extensionsMap, String extensionName) {
        String string2;
        try {
            Object object = extensionsMap.get(extensionName);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map extensionDetails = (Map)object;
            Object v = extensionDetails.get("friendlyName");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            string2 = (String)v;
        }
        catch (Exception ignored) {
            string2 = extensionName;
        }
        return string2;
    }

    private final String urlEncode(String content) {
        String string2;
        try {
            String string3 = URLEncoder.encode(content, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            URLEncoder\u2026ntent, \"UTF-8\")\n        }");
            string2 = string3;
        }
        catch (UnsupportedEncodingException e) {
            Object[] objectArray = new Object[]{e.getLocalizedMessage()};
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Error while encoding the content. Error %s", (Object[])objectArray);
            string2 = "";
        }
        return string2;
    }

    private final boolean isSharedStateSet(SharedStateResult result) {
        return result != null && result.getStatus() == SharedStateStatus.SET;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceStateManager$Companion;", "", "()V", "LOG_TAG", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

