/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.assurance.internal.AssuranceSharedState;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0001R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedStateManager;", "", "dataStoreService", "Lcom/adobe/marketing/mobile/services/DataStoring;", "(Lcom/adobe/marketing/mobile/services/DataStoring;)V", "assuranceDataStore", "Lcom/adobe/marketing/mobile/services/NamedCollection;", "assuranceSharedState", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedState;", "getAssuranceSharedState", "()Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedState;", "setAssuranceSharedState", "(Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedState;)V", "adjustPersistedState", "persistedState", "loadFromPersistence", "persist", "", "stateToPersist", "setSessionId", "sessionId", "", "Companion", "assurance_phoneRelease"})
public final class AssuranceSharedStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final NamedCollection assuranceDataStore;
    @NotNull
    private AssuranceSharedState assuranceSharedState;
    @NotNull
    private static final String LOG_TAG = "AssuranceSharedStateManager";

    public AssuranceSharedStateManager(@NotNull DataStoring dataStoreService) {
        Intrinsics.checkNotNullParameter((Object)dataStoreService, (String)"dataStoreService");
        this.assuranceDataStore = dataStoreService.getNamedCollection("com.adobe.assurance.preferences");
        this.assuranceSharedState = this.adjustPersistedState(this.loadFromPersistence());
    }

    @NotNull
    public final AssuranceSharedState getAssuranceSharedState() {
        return this.assuranceSharedState;
    }

    public final void setAssuranceSharedState(@NotNull AssuranceSharedState assuranceSharedState) {
        Intrinsics.checkNotNullParameter((Object)assuranceSharedState, (String)"<set-?>");
        this.assuranceSharedState = assuranceSharedState;
    }

    @JvmName(name="setSessionId")
    public final void setSessionId(@Nullable String sessionId) {
        String string2 = sessionId;
        if (string2 == null) {
            string2 = "";
        }
        this.assuranceSharedState = AssuranceSharedState.copy$default(this.assuranceSharedState, null, string2, 1, null);
        this.persist(this.assuranceSharedState);
    }

    private final AssuranceSharedState loadFromPersistence() {
        if (this.assuranceDataStore == null) {
            return new AssuranceSharedState("", "");
        }
        String persistedClientId = this.assuranceDataStore.getString("clientid", "");
        String persistedSessionId = this.assuranceDataStore.getString("sessionid", "");
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)("Assurance state loaded, sessionID : " + persistedSessionId + " and clientId " + persistedClientId + " from persistence."), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)persistedClientId, (String)"persistedClientId");
        Intrinsics.checkNotNullExpressionValue((Object)persistedSessionId, (String)"persistedSessionId");
        return new AssuranceSharedState(persistedClientId, persistedSessionId);
    }

    private final AssuranceSharedState adjustPersistedState(AssuranceSharedState persistedState) {
        AssuranceSharedState assuranceSharedState;
        AssuranceSharedState assuranceSharedState2;
        if (((CharSequence)persistedState.getClientId()).length() == 0) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Assurance clientId persisted is empty, generating a new one.", (Object[])new Object[0]);
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            assuranceSharedState2 = new AssuranceSharedState(string2, persistedState.getSessionId());
        } else {
            assuranceSharedState2 = persistedState;
        }
        AssuranceSharedState it = assuranceSharedState = assuranceSharedState2;
        boolean bl = false;
        this.persist(it);
        return assuranceSharedState;
    }

    private final void persist(AssuranceSharedState stateToPersist) {
        if (this.assuranceDataStore == null) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Assurance datastore is null, unable to persist assurance state.", (Object[])new Object[0]);
            return;
        }
        if (StringsKt.isBlank((CharSequence)stateToPersist.getClientId())) {
            this.assuranceDataStore.remove("clientid");
        } else {
            this.assuranceDataStore.setString("clientid", stateToPersist.getClientId());
        }
        if (StringsKt.isBlank((CharSequence)stateToPersist.getSessionId())) {
            this.assuranceDataStore.remove("sessionid");
        } else {
            this.assuranceDataStore.setString("sessionid", stateToPersist.getSessionId());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSharedStateManager$Companion;", "", "()V", "LOG_TAG", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

