/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.assurance.internal.AssuranceAppState;
import com.adobe.marketing.mobile.assurance.internal.AssuranceComponentRegistry;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.assurance.internal.AssuranceWebViewSocket;
import com.adobe.marketing.mobile.assurance.internal.SessionAuthorizingPresentationType;
import com.adobe.marketing.mobile.assurance.internal.ui.AssuranceActivity;
import com.adobe.marketing.mobile.assurance.internal.ui.floatingbutton.AssuranceFloatingButton;
import com.adobe.marketing.mobile.services.AppContextService;
import com.adobe.marketing.mobile.services.ServiceProvider;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0001J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0001J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0001J\b\u0010\u0014\u001a\u00020\fH\u0001J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0001J\b\u0010\u0018\u001a\u00020\fH\u0001J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0001J\u0012\u0010\u001c\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSessionPresentationManager;", "", "authorizingPresentationType", "Lcom/adobe/marketing/mobile/assurance/internal/SessionAuthorizingPresentationType;", "(Lcom/adobe/marketing/mobile/assurance/internal/SessionAuthorizingPresentationType;)V", "assuranceFloatingButton", "Lcom/adobe/marketing/mobile/assurance/internal/ui/floatingbutton/AssuranceFloatingButton;", "(Lcom/adobe/marketing/mobile/assurance/internal/SessionAuthorizingPresentationType;Lcom/adobe/marketing/mobile/assurance/internal/ui/floatingbutton/AssuranceFloatingButton;)V", "button", "isAuthorizingPresentationActive", "", "logLocalUI", "", "visibility", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$UILogColorVisibility;", "message", "", "onActivityResumed", "activity", "Landroid/app/Activity;", "onSessionConnected", "onSessionDisconnected", "closeCode", "", "onSessionReconnecting", "onSessionStateChange", "newState", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceWebViewSocket$SocketReadyState;", "showAssuranceActivity", "currentActivity", "Companion", "assurance_phoneRelease"})
public final class AssuranceSessionPresentationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionAuthorizingPresentationType authorizingPresentationType;
    @NotNull
    private final AssuranceFloatingButton button;
    @NotNull
    private static final String LOG_TAG = "AssuranceSessionPresentationManager";

    public AssuranceSessionPresentationManager(@NotNull SessionAuthorizingPresentationType authorizingPresentationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)authorizingPresentationType), (String)"authorizingPresentationType");
        AppContextService appContextService = ServiceProvider.getInstance().getAppContextService();
        Intrinsics.checkNotNullExpressionValue((Object)appContextService, (String)"getInstance().appContextService");
        this(authorizingPresentationType, new AssuranceFloatingButton(appContextService));
    }

    @VisibleForTesting
    public AssuranceSessionPresentationManager(@NotNull SessionAuthorizingPresentationType authorizingPresentationType, @NotNull AssuranceFloatingButton assuranceFloatingButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)authorizingPresentationType), (String)"authorizingPresentationType");
        Intrinsics.checkNotNullParameter((Object)assuranceFloatingButton, (String)"assuranceFloatingButton");
        this.authorizingPresentationType = authorizingPresentationType;
        this.button = assuranceFloatingButton;
    }

    @JvmName(name="onSessionConnected")
    public final void onSessionConnected() {
        AssuranceFloatingButton assuranceFloatingButton;
        AssuranceComponentRegistry.appState.onSessionPhaseChange(AssuranceAppState.SessionPhase.Connected.INSTANCE);
        AssuranceFloatingButton $this$onSessionConnected_u24lambda_u240 = assuranceFloatingButton = this.button;
        boolean bl = false;
        $this$onSessionConnected_u24lambda_u240.show$assurance_phoneRelease();
        $this$onSessionConnected_u24lambda_u240.updateGraphic$assurance_phoneRelease(true);
        this.logLocalUI(AssuranceConstants.UILogColorVisibility.LOW, "Assurance connection established.");
    }

    @JvmName(name="onSessionDisconnected")
    public final void onSessionDisconnected(int closeCode) {
        this.button.remove$assurance_phoneRelease();
        AssuranceConstants.AssuranceConnectionError error = AssuranceConstants.SocketCloseCode.toAssuranceConnectionError(closeCode);
        if (error == null) {
            AssuranceComponentRegistry.appState.onSessionPhaseChange(new AssuranceAppState.SessionPhase.Disconnected(null, false, 3, null));
            this.logLocalUI(AssuranceConstants.UILogColorVisibility.LOW, "Assurance disconnected.");
            return;
        }
        if (!this.isAuthorizingPresentationActive()) {
            AssuranceComponentRegistry.appState.onSessionPhaseChange(new AssuranceAppState.SessionPhase.Disconnected(error, false));
            this.showAssuranceActivity(ServiceProvider.getInstance().getAppContextService().getCurrentActivity());
        }
    }

    @JvmName(name="onSessionReconnecting")
    public final void onSessionReconnecting() {
        AssuranceFloatingButton assuranceFloatingButton;
        AssuranceFloatingButton $this$onSessionReconnecting_u24lambda_u241 = assuranceFloatingButton = this.button;
        boolean bl = false;
        $this$onSessionReconnecting_u24lambda_u241.show$assurance_phoneRelease();
        $this$onSessionReconnecting_u24lambda_u241.updateGraphic$assurance_phoneRelease(false);
        this.logLocalUI(AssuranceConstants.UILogColorVisibility.HIGH, "Assurance disconnected, attempting to reconnect ...");
        AssuranceComponentRegistry.appState.onSessionPhaseChange(new AssuranceAppState.SessionPhase.Disconnected(null, true, 1, null));
    }

    @JvmName(name="onSessionStateChange")
    public final void onSessionStateChange(@NotNull AssuranceWebViewSocket.SocketReadyState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.button.updateGraphic$assurance_phoneRelease(newState == AssuranceWebViewSocket.SocketReadyState.OPEN);
    }

    @JvmName(name="onActivityResumed")
    public final void onActivityResumed(@NotNull Activity activity2) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        if (AssuranceUtil.isAssuranceActivity(activity2)) {
            if (this.button.isActive$assurance_phoneRelease()) {
                this.button.hide$assurance_phoneRelease();
            }
        } else if (this.button.isActive$assurance_phoneRelease()) {
            this.button.show$assurance_phoneRelease();
        }
        if (this.isAuthorizingPresentationActive()) {
            this.showAssuranceActivity(activity2);
        }
    }

    @JvmName(name="isAuthorizingPresentationActive")
    public final boolean isAuthorizingPresentationActive() {
        AssuranceAppState.SessionPhase phase = (AssuranceAppState.SessionPhase)AssuranceComponentRegistry.appState.getSessionPhase().getValue();
        if (phase instanceof AssuranceAppState.SessionPhase.Authorizing) {
            boolean isPinConnect = this.authorizingPresentationType == SessionAuthorizingPresentationType.PIN && ((AssuranceAppState.SessionPhase.Authorizing)phase).getAssuranceAuthorization() instanceof AssuranceAppState.AssuranceAuthorization.PinConnect;
            boolean isQuickConnect = this.authorizingPresentationType == SessionAuthorizingPresentationType.QUICK_CONNECT && ((AssuranceAppState.SessionPhase.Authorizing)phase).getAssuranceAuthorization() instanceof AssuranceAppState.AssuranceAuthorization.QuickConnect;
            return isPinConnect || isQuickConnect;
        }
        return false;
    }

    @JvmName(name="logLocalUI")
    public final void logLocalUI(@Nullable AssuranceConstants.UILogColorVisibility visibility, @Nullable String message) {
        if (visibility == null || message == null) {
            return;
        }
        AssuranceComponentRegistry.appState.logStatus(visibility, message);
    }

    private final void showAssuranceActivity(Activity currentActivity) {
        if (currentActivity == null) {
            return;
        }
        if (currentActivity instanceof AssuranceActivity) {
            return;
        }
        Intent intent = new Intent((Context)currentActivity, AssuranceActivity.class);
        intent.addFlags(65536);
        intent.addFlags(131072);
        currentActivity.startActivity(intent);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceSessionPresentationManager$Companion;", "", "()V", "LOG_TAG", "", "assurance_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

