/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Assurance;
import com.adobe.marketing.mobile.assurance.internal.AssuranceComponentRegistry;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConnectionDataStore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionStatusListener;
import com.adobe.marketing.mobile.assurance.internal.AssuranceStateManager;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.assurance.internal.SessionAuthorizingPresentationType;
import com.adobe.marketing.mobile.assurance.internal.SessionUIOperationHandler;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

class AssuranceSessionOrchestrator {
    private static final String LOG_TAG = "AssuranceSessionOrchestrator";
    private final HostAppActivityLifecycleObserver activityLifecycleObserver;
    private final AssuranceStateManager assuranceStateManager;
    private final List<AssurancePlugin> plugins;
    private final AssuranceConnectionDataStore connectionURLStore;
    private final AssuranceSessionCreator sessionCreator;
    private AssuranceSession session;
    private List<AssuranceEvent> outboundEventBuffer;
    private final SessionUIOperationHandler sessionUIOperationHandler;
    private final AssuranceSessionStatusListener sessionStatusListener = new AssuranceSessionStatusListener(){

        @Override
        public void onSessionConnected() {
            if (AssuranceSessionOrchestrator.this.outboundEventBuffer == null) {
                return;
            }
            AssuranceSessionOrchestrator.this.outboundEventBuffer.clear();
            AssuranceSessionOrchestrator.this.outboundEventBuffer = null;
        }

        @Override
        public void onSessionDisconnected(AssuranceConstants.AssuranceConnectionError error) {
        }

        @Override
        public void onSessionTerminated(@Nullable AssuranceConstants.AssuranceConnectionError error) {
            AssuranceSessionOrchestrator.this.terminateSession(true);
        }
    };

    AssuranceSessionOrchestrator(Application application, AssuranceStateManager assuranceStateManager2, List<AssurancePlugin> plugins, AssuranceConnectionDataStore connectionURLStore) {
        this(application, assuranceStateManager2, plugins, connectionURLStore, new AssuranceSessionCreator());
    }

    @VisibleForTesting
    AssuranceSessionOrchestrator(Application application, AssuranceStateManager assuranceStateManager2, List<AssurancePlugin> plugins, AssuranceConnectionDataStore connectionURLStore, AssuranceSessionCreator sessionCreator) {
        this.assuranceStateManager = assuranceStateManager2;
        this.plugins = plugins;
        this.connectionURLStore = connectionURLStore;
        this.activityLifecycleObserver = new HostAppActivityLifecycleObserver(this);
        this.outboundEventBuffer = new ArrayList<AssuranceEvent>();
        this.sessionCreator = sessionCreator;
        this.sessionUIOperationHandler = new SessionUIOperationHandler(this);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleObserver);
        AssuranceComponentRegistry.INSTANCE.initialize(assuranceStateManager2, this.sessionUIOperationHandler);
    }

    synchronized void createSession(@NonNull String sessionId, @NonNull AssuranceConstants.AssuranceEnvironment environment, @NonNull String code, @Nullable AssuranceSessionStatusListener statusListener, @NonNull SessionAuthorizingPresentationType authorizingPresentationType) {
        if (this.session != null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"An active session already exists. Cannot create a new one.", (Object[])new Object[0]);
            return;
        }
        this.session = this.sessionCreator.create(sessionId, code, environment, this.assuranceStateManager, this.plugins, this.connectionURLStore, this.outboundEventBuffer, statusListener, authorizingPresentationType);
        this.session.registerStatusListener(this.sessionStatusListener);
        this.assuranceStateManager.shareAssuranceSharedState(sessionId);
        this.session.connect();
    }

    synchronized void terminateSession(boolean purgeBuffer) {
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Terminating active session purging Assurance shared state", (Object[])new Object[0]);
        if (purgeBuffer && this.outboundEventBuffer != null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Clearing the queued events.", (Object[])new Object[0]);
            this.outboundEventBuffer.clear();
            this.outboundEventBuffer = null;
        }
        this.assuranceStateManager.clearAssuranceSharedState();
        if (this.session != null) {
            this.session.unregisterStatusListener(this.sessionStatusListener);
            this.session.disconnect();
            this.session = null;
        }
    }

    boolean reconnectToStoredSession() {
        String connectionURL = this.connectionURLStore.getStoredConnectionURL();
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)("Attempting to reconnect to stored URL: " + connectionURL), (Object[])new Object[0]);
        if (StringUtils.isNullOrEmpty((String)connectionURL)) {
            return false;
        }
        Uri uri = Uri.parse((String)connectionURL);
        String sessionId = uri.getQueryParameter("sessionId");
        if (StringUtils.isNullOrEmpty((String)sessionId)) {
            return false;
        }
        String pin = uri.getQueryParameter("token");
        if (StringUtils.isNullOrEmpty((String)pin)) {
            return false;
        }
        AssuranceConstants.AssuranceEnvironment environment = AssuranceUtil.getEnvironmentFromSocketUri(uri);
        Log.trace((String)"Assurance", (String)LOG_TAG, (String)"Initializing Assurance session. %s using stored connection details:%s ", (Object[])new Object[]{sessionId, connectionURL});
        this.createSession(sessionId, environment, pin, null, SessionAuthorizingPresentationType.PIN);
        return true;
    }

    AssuranceSession getActiveSession() {
        return this.session;
    }

    void queueEvent(AssuranceEvent event) {
        if (event == null) {
            return;
        }
        if (this.session != null) {
            this.session.queueOutboundEvent(event);
        }
        if (this.outboundEventBuffer != null) {
            this.outboundEventBuffer.add(event);
        }
    }

    @VisibleForTesting
    boolean canProcessSDKEvents() {
        return this.session != null || this.outboundEventBuffer != null;
    }

    @VisibleForTesting
    SessionUIOperationHandler getSessionUIOperationHandler() {
        return this.sessionUIOperationHandler;
    }

    @VisibleForTesting
    AssuranceSessionStatusListener getAssuranceSessionStatusListener() {
        return this.sessionStatusListener;
    }

    @VisibleForTesting
    static class AssuranceSessionCreator {
        AssuranceSessionCreator() {
        }

        AssuranceSession create(String sessionId, String pin, AssuranceConstants.AssuranceEnvironment environment, AssuranceStateManager assuranceStateManager2, List<AssurancePlugin> plugins, AssuranceConnectionDataStore connectionURLStore, List<AssuranceEvent> outboundEventBuffer, AssuranceSessionStatusListener authorizingPresentationListener, SessionAuthorizingPresentationType authorizingPresentationType) {
            return new AssuranceSession(assuranceStateManager2, sessionId, pin, environment, connectionURLStore, plugins, outboundEventBuffer, authorizingPresentationType, authorizingPresentationListener);
        }
    }

    static class HostAppActivityLifecycleObserver
    implements Application.ActivityLifecycleCallbacks {
        private final AssuranceSessionOrchestrator sessionOrchestrator;

        HostAppActivityLifecycleObserver(AssuranceSessionOrchestrator sessionOrchestrator) {
            this.sessionOrchestrator = sessionOrchestrator;
        }

        public void onActivityCreated(@NonNull Activity activity2, @Nullable Bundle savedInstanceState) {
            Intent intent = activity2.getIntent();
            Uri data = intent.getData();
            if (data != null) {
                Assurance.startSession(data.toString());
            }
            Log.trace((String)"Assurance", (String)AssuranceSessionOrchestrator.LOG_TAG, (String)("Session Activity Hook - onActivityCreated called " + activity2.getClass().getCanonicalName()), (Object[])new Object[0]);
        }

        public void onActivityResumed(@NonNull Activity activity2) {
            Log.trace((String)"Assurance", (String)AssuranceSessionOrchestrator.LOG_TAG, (String)("Session Activity Hook - onActivityResumed called " + activity2.getClass().getCanonicalName()), (Object[])new Object[0]);
            AssuranceSession activeSession = this.sessionOrchestrator.getActiveSession();
            if (activeSession != null) {
                activeSession.onActivityResumed(activity2);
            }
        }

        public void onActivityStarted(@NonNull Activity activity2) {
        }

        public void onActivityPaused(@NonNull Activity activity2) {
        }

        public void onActivityStopped(@NonNull Activity activity2) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity2, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity2) {
        }
    }
}

