/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Activity;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.assurance.internal.AssuranceClientInfo;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConnectionDataStore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssurancePluginManager;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionPresentationManager;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionStatusListener;
import com.adobe.marketing.mobile.assurance.internal.AssuranceStateManager;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.assurance.internal.AssuranceWebViewSocket;
import com.adobe.marketing.mobile.assurance.internal.AssuranceWebViewSocketHandler;
import com.adobe.marketing.mobile.assurance.internal.InboundEventQueueWorker;
import com.adobe.marketing.mobile.assurance.internal.OutboundEventQueueWorker;
import com.adobe.marketing.mobile.assurance.internal.SessionAuthorizingPresentationType;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

class AssuranceSession
implements AssuranceWebViewSocketHandler {
    private static final String LOG_TAG = "AssuranceSession";
    private static final String CONNECTION_URL_FORMAT = "wss://connect%s.griffon.adobe.com/client/v1?sessionId=%s&token=%s&orgId=%s&clientId=%s";
    private static final long SOCKET_RECONNECT_TIME_DELAY = TimeUnit.SECONDS.toMillis(5L);
    private final AssuranceStateManager assuranceStateManager;
    private final AssuranceConstants.AssuranceEnvironment assuranceEnvironment;
    private final String sessionId;
    private final String pin;
    private final OutboundEventQueueWorker outboundEventQueueWorker;
    private final InboundEventQueueWorker inboundEventQueueWorker;
    private final AssuranceWebViewSocket socket;
    private final HandlerThread socketReconnectThread = new HandlerThread("com.adobe.assurance.mobile.socketreconnectworker");
    private final Handler socketReconnectHandler;
    private final AssurancePluginManager pluginManager;
    private final AssuranceSessionPresentationManager assuranceSessionPresentationManager;
    private final Set<AssuranceSessionStatusListener> sessionStatusListeners;
    private final AssuranceConnectionDataStore connectionDataStore;
    private final SessionAuthorizingPresentationType authorizingPresentationType;
    @VisibleForTesting
    final InboundEventQueueWorker.InboundQueueEventListener inboundQueueEventListener = new InboundEventQueueWorker.InboundQueueEventListener(){

        @Override
        public void onInboundEvent(AssuranceEvent event) {
            if ("startEventForwarding".equals(event.getControlType())) {
                AssuranceSession.this.onStartForwardingEvent();
                return;
            }
            AssuranceSession.this.pluginManager.onAssuranceEvent(event);
        }
    };
    private boolean isAttemptingToReconnect = false;
    private boolean didClearBootEvents = false;
    final AssuranceSessionStatusListener authorizingPresentationDelegate;

    AssuranceSession(AssuranceStateManager assuranceStateManager2, String sessionId, String pin, AssuranceConstants.AssuranceEnvironment assuranceEnvironment, AssuranceConnectionDataStore connectionDataStore, List<AssurancePlugin> plugins, List<AssuranceEvent> bufferedEvents, SessionAuthorizingPresentationType authorizingPresentationType, AssuranceSessionStatusListener authorizingPresentationDelegate) {
        this.assuranceStateManager = assuranceStateManager2;
        this.assuranceEnvironment = assuranceEnvironment;
        this.sessionId = sessionId;
        this.pin = pin;
        this.sessionStatusListeners = new HashSet<AssuranceSessionStatusListener>();
        this.connectionDataStore = connectionDataStore;
        this.authorizingPresentationType = authorizingPresentationType;
        this.assuranceSessionPresentationManager = new AssuranceSessionPresentationManager(authorizingPresentationType);
        this.authorizingPresentationDelegate = authorizingPresentationDelegate;
        this.registerStatusListener(authorizingPresentationDelegate);
        this.pluginManager = new AssurancePluginManager(this);
        this.socketReconnectThread.start();
        Looper socketLooper = this.socketReconnectThread.getLooper();
        this.socketReconnectHandler = new Handler(socketLooper);
        this.socket = new AssuranceWebViewSocket(this);
        this.outboundEventQueueWorker = new OutboundEventQueueWorker(Executors.newSingleThreadExecutor(), this.socket, new AssuranceClientInfo());
        this.inboundEventQueueWorker = new InboundEventQueueWorker(this.inboundQueueEventListener);
        if (bufferedEvents != null) {
            ArrayList<AssuranceEvent> buffer = new ArrayList<AssuranceEvent>(bufferedEvents);
            for (AssuranceEvent event : buffer) {
                this.queueOutboundEvent(event);
            }
        } else {
            this.didClearBootEvents = true;
        }
        if (plugins != null) {
            for (AssurancePlugin plugin : plugins) {
                this.addPlugin(plugin);
            }
        }
    }

    void connect() {
        String envString = AssuranceUtil.getURLFormatForEnvironment(this.assuranceEnvironment);
        String orgId = this.assuranceStateManager.getOrgId(true);
        if (StringUtils.isNullOrEmpty((String)orgId)) {
            String reconnectionURL = this.connectionDataStore.getStoredConnectionURL();
            if (reconnectionURL == null) {
                Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Cannot connect. No orgId from Configuration state or stored url.", (Object[])new Object[0]);
                return;
            }
            Uri uri = Uri.parse((String)reconnectionURL);
            orgId = uri.getQueryParameter("orgId");
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Using orgId from stored reconnection url.", (Object[])new Object[0]);
        }
        String connectionString = String.format(CONNECTION_URL_FORMAT, envString, this.sessionId, this.pin, orgId, this.assuranceStateManager.getClientId());
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)("Connecting to session with URL: " + connectionString), (Object[])new Object[0]);
        this.socket.connect(connectionString);
    }

    void disconnect() {
        if (this.socket != null && this.socket.getState() != AssuranceWebViewSocket.SocketReadyState.CLOSED) {
            this.socket.disconnect();
        }
        this.clearSessionData();
        this.pluginManager.onSessionTerminated();
    }

    void queueOutboundEvent(AssuranceEvent event) {
        if (event == null) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Assurance cannot send event, event cannot be null.", (Object[])new Object[0]);
            return;
        }
        if (!this.outboundEventQueueWorker.offer(event)) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Assurance cannot send event, problem queuing event in outBoundEventQueue", (Object[])new Object[0]);
        }
    }

    void addPlugin(AssurancePlugin plugin) {
        this.pluginManager.addPlugin(plugin);
    }

    void logLocalUI(AssuranceConstants.UILogColorVisibility visibility, String message) {
        this.assuranceSessionPresentationManager.logLocalUI(visibility, message);
    }

    AssuranceConstants.AssuranceEnvironment getAssuranceEnvironment() {
        return this.assuranceEnvironment;
    }

    String getSessionId() {
        return this.sessionId;
    }

    SessionAuthorizingPresentationType getAuthorizingPresentationType() {
        return this.authorizingPresentationType;
    }

    @Override
    public void onSocketConnected(AssuranceWebViewSocket socket) {
        boolean outboundWorkerAlreadyStarted;
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Websocket connected.", (Object[])new Object[0]);
        this.isAttemptingToReconnect = false;
        this.connectionDataStore.saveConnectionURL(socket.getConnectionURL());
        this.inboundEventQueueWorker.start();
        boolean bl = outboundWorkerAlreadyStarted = !this.outboundEventQueueWorker.start();
        if (outboundWorkerAlreadyStarted) {
            this.outboundEventQueueWorker.sendClientInfoEvent();
        }
    }

    @Override
    public void onSocketDataReceived(AssuranceWebViewSocket socket, String message) {
        try {
            AssuranceEvent event = new AssuranceEvent(message);
            if (!this.inboundEventQueueWorker.offer(event)) {
                Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Cannnot process the inbound Assurance event from server, problem queuing event in inboundEventsQueue", (Object[])new Object[0]);
            }
        }
        catch (UnsupportedCharsetException ex) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)String.format("Unable to marshal inbound event due to encoding. Error - %s", ex.getLocalizedMessage()), (Object[])new Object[0]);
        }
        catch (JSONException ex) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)String.format("Unable to marshal inbound event due to json format. Error - %s", ex.getLocalizedMessage()), (Object[])new Object[0]);
        }
    }

    @Override
    public void onSocketDisconnected(AssuranceWebViewSocket socket, String errorReason, int closeCode, boolean wasClean) {
        switch (closeCode) {
            case 1000: {
                this.clearSessionData();
                this.assuranceSessionPresentationManager.onSessionDisconnected(closeCode);
                this.pluginManager.onSessionTerminated();
                this.notifyTerminationAndRemoveStatusListeners(null);
                break;
            }
            case 4400: 
            case 4900: 
            case 4901: 
            case 4902: 
            case 4903: {
                this.clearSessionData();
                this.assuranceSessionPresentationManager.onSessionDisconnected(closeCode);
                this.pluginManager.onSessionDisconnected(closeCode);
                this.pluginManager.onSessionTerminated();
                AssuranceConstants.AssuranceConnectionError error = AssuranceConstants.SocketCloseCode.toAssuranceConnectionError(closeCode);
                this.notifyTerminationAndRemoveStatusListeners(error);
                break;
            }
            default: {
                Log.warning((String)"Assurance", (String)LOG_TAG, (String)String.format("Abnornmal closure of websocket. Reason - %s and closeCode - %s", errorReason, closeCode), (Object[])new Object[0]);
                if (!this.isAttemptingToReconnect) {
                    this.outboundEventQueueWorker.block();
                    this.pluginManager.onSessionDisconnected(closeCode);
                    this.notifySessionDisconnection(AssuranceConstants.SocketCloseCode.toAssuranceConnectionError(closeCode));
                    if (this.assuranceSessionPresentationManager.isAuthorizingPresentationActive()) {
                        return;
                    }
                    this.isAttemptingToReconnect = true;
                    this.assuranceSessionPresentationManager.onSessionReconnecting();
                    Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Assurance disconnected, attempting to reconnect..", (Object[])new Object[0]);
                }
                long delayBeforeReconnect = this.isAttemptingToReconnect ? SOCKET_RECONNECT_TIME_DELAY : 0L;
                this.socketReconnectHandler.postDelayed(this::connect, delayBeforeReconnect);
            }
        }
    }

    @Override
    public void onSocketError(AssuranceWebViewSocket socket) {
    }

    @Override
    public void onSocketStateChange(AssuranceWebViewSocket socket, AssuranceWebViewSocket.SocketReadyState state) {
        this.assuranceSessionPresentationManager.onSessionStateChange(state);
    }

    void onActivityResumed(Activity activity2) {
        this.assuranceSessionPresentationManager.onActivityResumed(activity2);
    }

    void registerStatusListener(AssuranceSessionStatusListener sessionStatusListener) {
        if (sessionStatusListener != null) {
            this.sessionStatusListeners.add(sessionStatusListener);
        }
    }

    void unregisterStatusListener(AssuranceSessionStatusListener sessionStatusListener) {
        if (sessionStatusListener != null) {
            this.sessionStatusListeners.remove(sessionStatusListener);
        }
    }

    private void onStartForwardingEvent() {
        this.outboundEventQueueWorker.unblock();
        this.assuranceSessionPresentationManager.onSessionConnected();
        this.notifySessionConnection();
        if (this.didClearBootEvents) {
            for (AssuranceEvent stateEvent : this.assuranceStateManager.getAllExtensionStateData()) {
                this.queueOutboundEvent(stateEvent);
            }
        }
        this.pluginManager.onSessionConnected();
    }

    private void notifySessionConnection() {
        for (AssuranceSessionStatusListener listener : this.sessionStatusListeners) {
            if (listener == null) continue;
            listener.onSessionConnected();
        }
    }

    private void notifySessionDisconnection(@Nullable AssuranceConstants.AssuranceConnectionError error) {
        for (AssuranceSessionStatusListener listener : this.sessionStatusListeners) {
            if (listener == null) continue;
            listener.onSessionDisconnected(error);
        }
    }

    private void notifyTerminationAndRemoveStatusListeners(@Nullable AssuranceConstants.AssuranceConnectionError error) {
        this.notifySessionDisconnection(error);
        this.sessionStatusListeners.clear();
    }

    private void clearSessionData() {
        this.outboundEventQueueWorker.stop();
        this.inboundEventQueueWorker.stop();
        this.socketReconnectThread.quit();
        this.didClearBootEvents = true;
        this.connectionDataStore.saveConnectionURL(null);
        this.assuranceStateManager.clearAssuranceSharedState();
    }
}

