/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Activity;
import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.assurance.internal.AssuranceBlob;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

class AssurancePluginScreenshot
implements AssurancePlugin {
    private static final String LOG_TAG = "AssurancePluginScreenshot";
    private static final String PAYLOAD_BLOBID = "blobId";
    private static final String PAYLOAD_MIMETYPE = "mimeType";
    private static final String PAYLOAD_ERROR = "error";
    private AssuranceSession parentSession = null;
    private CaptureScreenShotListener listener;

    AssurancePluginScreenshot() {
    }

    @Override
    public String getVendor() {
        return "com.adobe.griffon.mobile";
    }

    @Override
    public String getControlType() {
        return "screenshot";
    }

    @Override
    public void onEventReceived(AssuranceEvent event) {
        this.listener = new CaptureScreenShotListener(){

            @Override
            public void onCaptureScreenshot(Bitmap bitmap) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int quality = 100;
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
                AssurancePluginScreenshot.this.sendScreenshot(baos);
            }
        };
        this.getCurrentScreenShot(this.listener);
    }

    @Override
    public void onRegistered(AssuranceSession parentSession) {
        this.parentSession = parentSession;
    }

    @Override
    public void onSessionConnected() {
    }

    @Override
    public void onSessionDisconnected(int code) {
        this.listener = null;
    }

    @Override
    public void onSessionTerminated() {
        this.parentSession = null;
    }

    private void getCurrentScreenShot(final CaptureScreenShotListener captureScreenShotListener) {
        if (this.parentSession == null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Unable to take screenshot, Assurance session instance unavailable.", (Object[])new Object[0]);
            return;
        }
        final Activity currentActivity = ServiceProvider.getInstance().getAppContextService().getCurrentActivity();
        if (currentActivity != null) {
            currentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    View currentWindow = currentActivity.getWindow().getDecorView().getRootView();
                    currentWindow.setDrawingCacheEnabled(true);
                    Bitmap bitmap = Bitmap.createBitmap((Bitmap)currentWindow.getDrawingCache());
                    currentWindow.setDrawingCacheEnabled(false);
                    if (captureScreenShotListener != null) {
                        captureScreenShotListener.onCaptureScreenshot(bitmap);
                    }
                }
            });
        }
    }

    private void sendScreenshot(ByteArrayOutputStream baos) {
        if (this.parentSession == null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Unable to send screenshot, Assurance session instance unavailable", (Object[])new Object[0]);
            return;
        }
        AssuranceBlob.upload(baos.toByteArray(), "image/jpeg", this.parentSession, new AssuranceBlob.BlobUploadCallback(){

            @Override
            public void onSuccess(String blobID) {
                HashMap<String, Object> responsePayload = new HashMap<String, Object>();
                responsePayload.put(AssurancePluginScreenshot.PAYLOAD_BLOBID, blobID);
                responsePayload.put(AssurancePluginScreenshot.PAYLOAD_MIMETYPE, "image/png");
                AssuranceEvent screenshotEvent = new AssuranceEvent("blob", responsePayload);
                if (AssurancePluginScreenshot.this.parentSession != null) {
                    AssurancePluginScreenshot.this.parentSession.logLocalUI(AssuranceConstants.UILogColorVisibility.LOW, "Screenshot taken");
                    AssurancePluginScreenshot.this.parentSession.queueOutboundEvent(screenshotEvent);
                } else {
                    Log.warning((String)"Assurance", (String)AssurancePluginScreenshot.LOG_TAG, (String)"Assurance Session instance is null for AssurancePluginScreenshot, Cannot send the screenshot event.", (Object[])new Object[0]);
                }
            }

            @Override
            public void onFailure(String reason) {
                HashMap<String, Object> responsePayload = new HashMap<String, Object>();
                responsePayload.put(AssurancePluginScreenshot.PAYLOAD_BLOBID, "");
                responsePayload.put(AssurancePluginScreenshot.PAYLOAD_ERROR, reason);
                AssuranceEvent screenshotFailEvent = new AssuranceEvent("blob", responsePayload);
                String error = String.format("Error while taking screenshot - Description: %s", reason);
                Log.error((String)"Assurance", (String)AssurancePluginScreenshot.LOG_TAG, (String)error, (Object[])new Object[0]);
                if (AssurancePluginScreenshot.this.parentSession != null) {
                    AssurancePluginScreenshot.this.parentSession.logLocalUI(AssuranceConstants.UILogColorVisibility.LOW, error);
                    AssurancePluginScreenshot.this.parentSession.queueOutboundEvent(screenshotFailEvent);
                }
            }
        });
    }

    @VisibleForTesting
    AssuranceSession getParentSession() {
        return this.parentSession;
    }

    @VisibleForTesting
    CaptureScreenShotListener getCaptureScreenShotListener() {
        return this.listener;
    }

    static interface CaptureScreenShotListener {
        public void onCaptureScreenshot(Bitmap var1);
    }
}

