/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.services.Log;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class AssurancePluginManager {
    private static final String LOG_TAG = "AssurancePluginManager";
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<AssurancePlugin>> plugins;
    private final AssuranceSession session;

    AssurancePluginManager(AssuranceSession session) {
        this(session, new ConcurrentHashMap<String, ConcurrentLinkedQueue<AssurancePlugin>>());
    }

    AssurancePluginManager(AssuranceSession session, ConcurrentHashMap<String, ConcurrentLinkedQueue<AssurancePlugin>> plugins) {
        this.session = session;
        this.plugins = plugins;
    }

    void addPlugin(AssurancePlugin plugin) {
        ConcurrentLinkedQueue<AssurancePlugin> newVendorQueue;
        if (plugin == null) {
            return;
        }
        String vendorID = plugin.getVendor();
        ConcurrentLinkedQueue<AssurancePlugin> existingQueue = this.plugins.putIfAbsent(vendorID, newVendorQueue = new ConcurrentLinkedQueue<AssurancePlugin>());
        if (existingQueue == null) {
            newVendorQueue.add(plugin);
        } else {
            existingQueue.add(plugin);
        }
        plugin.onRegistered(this.session);
    }

    void onAssuranceEvent(AssuranceEvent event) {
        ConcurrentLinkedQueue<AssurancePlugin> pluginsForVendor = this.plugins.get(event.getVendor());
        if (pluginsForVendor == null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)String.format("There are no plugins registered to handle incoming Assurance event with vendor : %s", event.getVendor()), (Object[])new Object[0]);
            return;
        }
        for (AssurancePlugin plugin : pluginsForVendor) {
            String pluginControlType = plugin.getControlType();
            if (pluginControlType == null || pluginControlType.isEmpty() || pluginControlType.equals("none") || !pluginControlType.equals("wildcard") && !pluginControlType.equals(event.getControlType())) continue;
            plugin.onEventReceived(event);
        }
    }

    void onSessionConnected() {
        for (ConcurrentLinkedQueue<AssurancePlugin> pluginQueue : this.plugins.values()) {
            for (AssurancePlugin plugin : pluginQueue) {
                plugin.onSessionConnected();
            }
        }
    }

    void onSessionTerminated() {
        for (ConcurrentLinkedQueue<AssurancePlugin> pluginQueue : this.plugins.values()) {
            for (AssurancePlugin plugin : pluginQueue) {
                plugin.onSessionTerminated();
            }
        }
    }

    void onSessionDisconnected(int closeCode) {
        for (ConcurrentLinkedQueue<AssurancePlugin> pluginQueue : this.plugins.values()) {
            for (AssurancePlugin plugin : pluginQueue) {
                plugin.onSessionDisconnected(closeCode);
            }
        }
    }
}

