/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.services.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AssurancePluginLogForwarder
implements AssurancePlugin {
    private static final String LOG_TAG = "AssurancePluginLogForwarder";
    private static final Pattern HEADER_MESSAGE = Pattern.compile("^\\[ \\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d.\\d\\d\\d {1,}\\d+: {0,}\\d+ [VDIWEAF]/[^ ]+ {1,}]$");
    private volatile boolean backgroundThreadRunning = false;
    private boolean logEnabled = false;
    private final AtomicReference<AssuranceSession> parentSession = new AtomicReference<Object>(null);

    AssurancePluginLogForwarder() {
    }

    boolean isBackgroundThreadRunning() {
        return this.backgroundThreadRunning;
    }

    @Override
    public String getVendor() {
        return "com.adobe.griffon.mobile";
    }

    @Override
    public String getControlType() {
        return "logForwarding";
    }

    @Override
    public void onEventReceived(AssuranceEvent event) {
        HashMap<String, Object> logForwardingDetails = event.getControlDetail();
        if (AssuranceUtil.isNullOrEmpty(logForwardingDetails)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Invalid details in payload. Ignoring to enable/disable logs.", (Object[])new Object[0]);
            return;
        }
        Object enabled = logForwardingDetails.get("enable");
        if (!(enabled instanceof Boolean)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Unable to forward the log, logForwardingValue is invalid", (Object[])new Object[0]);
            return;
        }
        this.logEnabled = (Boolean)enabled;
        AssuranceSession session = this.parentSession.get();
        if (this.logEnabled) {
            if (session != null) {
                session.logLocalUI(AssuranceConstants.UILogColorVisibility.HIGH, "Received Assurance command to start forwarding logs");
            }
            if (!this.backgroundThreadRunning) {
                this.backgroundThreadRunning = true;
                Thread logForwardThread = new Thread(new LogForwardThread());
                logForwardThread.start();
            }
        } else if (session != null) {
            session.logLocalUI(AssuranceConstants.UILogColorVisibility.HIGH, "Received Assurance command to stop forwarding logs");
        }
    }

    @Override
    public void onRegistered(AssuranceSession parentSession) {
        this.parentSession.set(parentSession);
    }

    @Override
    public void onSessionConnected() {
    }

    @Override
    public void onSessionDisconnected(int code) {
        this.logEnabled = false;
    }

    @Override
    public void onSessionTerminated() {
        this.parentSession.set(null);
    }

    private boolean checkIfHeader(String message) {
        Matcher matcher = HEADER_MESSAGE.matcher(message);
        return matcher.matches();
    }

    private boolean checkIfLogLinesAreEmpty(StringBuilder sb) {
        String[] a = sb.toString().split("\n");
        if (a.length < 2) {
            return true;
        }
        return a[1].equals("");
    }

    private final class LogForwardThread
    implements Runnable {
        private LogForwardThread() {
        }

        @Override
        public void run() {
            try {
                Process procRemoveUnecessaryLogs = new ProcessBuilder(new String[0]).command("logcat", "-P", "").start();
                String processIdCommand = String.format("--pid=%s", android.os.Process.myPid());
                Process proc = new ProcessBuilder(new String[0]).command("logcat", processIdCommand, "-bmain", "-vlong").start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                StringBuilder logLines = new StringBuilder();
                boolean isFirstLog = true;
                while (AssurancePluginLogForwarder.this.logEnabled && !Thread.interrupted()) {
                    try {
                        String logLine = reader.readLine();
                        if (logLine != null && logLine.contains("Assurance")) continue;
                        if (logLine != null && AssurancePluginLogForwarder.this.checkIfHeader(logLine)) {
                            if (isFirstLog) {
                                isFirstLog = false;
                                continue;
                            }
                            if (AssurancePluginLogForwarder.this.checkIfLogLinesAreEmpty(logLines)) continue;
                            HashMap<String, Object> eventPayload = new HashMap<String, Object>();
                            eventPayload.put("logline", logLines.toString());
                            AssuranceEvent logEvent = new AssuranceEvent("log", eventPayload);
                            AssuranceSession session = (AssuranceSession)AssurancePluginLogForwarder.this.parentSession.get();
                            if (session != null) {
                                session.queueOutboundEvent(logEvent);
                            }
                            logLines.setLength(0);
                        }
                        if (logLine == null || logLine.isEmpty()) continue;
                        logLines.append(logLine).append("\n");
                    }
                    catch (Exception ex) {
                        Log.error((String)"Assurance", (String)AssurancePluginLogForwarder.LOG_TAG, (String)String.format("Log forwarding error reading line: %s", ex.getLocalizedMessage()), (Object[])new Object[0]);
                    }
                }
                procRemoveUnecessaryLogs.destroy();
                proc.destroy();
            }
            catch (Exception ex) {
                Log.error((String)"Assurance", (String)AssurancePluginLogForwarder.LOG_TAG, (String)String.format("Log forwarding error while sending logs: %s" + ex.getLocalizedMessage(), new Object[0]), (Object[])new Object[0]);
            }
            AssurancePluginLogForwarder.this.backgroundThreadRunning = false;
        }
    }
}

