/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.services.Log;
import java.util.HashMap;
import java.util.Map;

class AssurancePluginFakeEventGenerator
implements AssurancePlugin {
    private static final String LOG_TAG = "AssurancePluginFakeEventGenerator";

    AssurancePluginFakeEventGenerator() {
    }

    @Override
    public String getVendor() {
        return "com.adobe.griffon.mobile";
    }

    @Override
    public String getControlType() {
        return "fakeEvent";
    }

    @Override
    public void onEventReceived(AssuranceEvent event) {
        HashMap<String, Object> fakeEventDetails = event.getControlDetail();
        if (fakeEventDetails == null || fakeEventDetails.isEmpty()) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"empty details obtained, Ignoring to generate fake event to eventHub", (Object[])new Object[0]);
            return;
        }
        if (!(fakeEventDetails.get("eventName") instanceof String)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Event name is invalid, Ignoring to generate fake event to eventHub", (Object[])new Object[0]);
            return;
        }
        if (!(fakeEventDetails.get("eventType") instanceof String)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Event type is invalid, Ignoring to generate fake event to eventHub", (Object[])new Object[0]);
            return;
        }
        if (!(fakeEventDetails.get("eventSource") instanceof String)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Event source is invalid, Ignoring to generate fake event to eventHub", (Object[])new Object[0]);
            return;
        }
        Map eventData = new HashMap();
        if (fakeEventDetails.get("eventData") instanceof Map) {
            eventData = (Map)fakeEventDetails.get("eventData");
        }
        Event fakeEvent = new Event.Builder((String)fakeEventDetails.get("eventName"), (String)fakeEventDetails.get("eventType"), (String)fakeEventDetails.get("eventSource")).setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)fakeEvent);
    }

    @Override
    public void onRegistered(AssuranceSession parentSession) {
    }

    @Override
    public void onSessionConnected() {
    }

    @Override
    public void onSessionDisconnected(int code) {
    }

    @Override
    public void onSessionTerminated() {
    }
}

