/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.content.SharedPreferences;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.services.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class AssurancePluginConfigSwitcher
implements AssurancePlugin {
    private static final String LOG_TAG = "AssurancePluginConfigSwitcher";
    private static final String PREF_KEY_MODIFIED_CONFIG_KEYS = "modifiedConfigKeys";
    private AssuranceSession session;
    private SharedPreferences pref = MobileCore.getApplication().getSharedPreferences("com.adobe.assurance.preferences", 0);

    AssurancePluginConfigSwitcher() {
    }

    @Override
    public String getVendor() {
        return "com.adobe.griffon.mobile";
    }

    @Override
    public String getControlType() {
        return "configUpdate";
    }

    @Override
    public void onEventReceived(AssuranceEvent event) {
        HashMap<String, Object> controlDetails = event.getControlDetail();
        if (AssuranceUtil.isNullOrEmpty(controlDetails)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"ConfigUpdate Control event details is empty, Ignoring to update config.", (Object[])new Object[0]);
            return;
        }
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Updating the configuration.", (Object[])new Object[0]);
        MobileCore.updateConfiguration(controlDetails);
        this.saveModifiedKeys(controlDetails.keySet());
    }

    @Override
    public void onRegistered(AssuranceSession parentSession) {
        this.session = parentSession;
    }

    @Override
    public void onSessionConnected() {
    }

    @Override
    public void onSessionDisconnected(int code) {
    }

    @Override
    public void onSessionTerminated() {
        if (this.pref == null) {
            return;
        }
        Set savedKeys = this.pref.getStringSet(PREF_KEY_MODIFIED_CONFIG_KEYS, null);
        if (savedKeys != null) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            for (String key : savedKeys) {
                config.put(key, null);
            }
            MobileCore.updateConfiguration(config);
        }
        this.clearModifiedKeys();
        this.session = null;
    }

    private void saveModifiedKeys(Set<String> payload) {
        if (this.pref == null) {
            return;
        }
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("ConfigUpdate - Configuration modified for keys");
        Set savedKeys = this.pref.getStringSet(PREF_KEY_MODIFIED_CONFIG_KEYS, null);
        HashSet<String> modifiedKeys = savedKeys == null ? new HashSet<String>() : new HashSet(savedKeys);
        modifiedKeys.addAll(payload);
        SharedPreferences.Editor editor = this.pref.edit();
        editor.putStringSet(PREF_KEY_MODIFIED_CONFIG_KEYS, modifiedKeys);
        editor.apply();
        for (String s : payload) {
            logBuilder.append("\n ").append(s);
        }
        if (this.session != null) {
            this.session.logLocalUI(AssuranceConstants.UILogColorVisibility.HIGH, logBuilder.toString());
        }
    }

    private void clearModifiedKeys() {
        SharedPreferences.Editor editor = this.pref.edit();
        editor.remove(PREF_KEY_MODIFIED_CONFIG_KEYS);
        editor.apply();
    }
}

