/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionEventListener;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceExtension;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class AssuranceListenerHubPlacesResponses
implements ExtensionEventListener {
    private static final String LOG_TAG = "AssuranceListenerHubPlacesResponses";
    private static final String REGION_NAME_KEY = "regionname";
    private static final String USER_WITHIN_KEY = "useriswithin";
    private static final String NEARBY_POI_KEY = "nearbypois";
    private static final String TRIGGERING_REGION_KEY = "triggeringregion";
    private static final String REGION_EVENT_TYPE_KEY = "regioneventtype";
    private static final String NEARBY_PLACES_EVENT_NAME = "responsegetnearbyplaces";
    private static final String REGION_EVENT_EVENT_NAME = "responseprocessregionevent";
    private final AssuranceExtension parent;

    AssuranceListenerHubPlacesResponses(AssuranceExtension extension) {
        this.parent = extension;
    }

    public void hear(Event event) {
        Map triggeringRegion;
        String regionName;
        String eventName = event.getName();
        Map eventData = event.getEventData();
        if (eventName == null || eventData == null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"[hear] Event data is null", (Object[])new Object[0]);
            return;
        }
        if (eventName.equals(NEARBY_PLACES_EVENT_NAME)) {
            List nearbyPois = DataReader.optTypedList(Map.class, (Map)eventData, (String)NEARBY_POI_KEY, new ArrayList());
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(Locale.US, "Places - Found %d nearby POIs%s", nearbyPois.size(), !nearbyPois.isEmpty() ? ":" : "."));
            for (Map poiMap : nearbyPois) {
                Map poi;
                String region;
                if (!AssuranceUtil.isStringMap(poiMap) || (region = DataReader.optString((Map)(poi = poiMap), (String)REGION_NAME_KEY, null)) == null) continue;
                boolean userIsInside = DataReader.optBoolean((Map)poi, (String)USER_WITHIN_KEY, (boolean)false);
                sb.append(String.format(Locale.US, "\n\t- %s%s", region, userIsInside ? " (inside)" : ""));
            }
            this.parent.logLocalUI(AssuranceConstants.UILogColorVisibility.NORMAL, sb.toString());
        } else if (eventName.equals(REGION_EVENT_EVENT_NAME) && (regionName = DataReader.optString((Map)(triggeringRegion = DataReader.optTypedMap(Object.class, (Map)eventData, (String)TRIGGERING_REGION_KEY, new HashMap())), (String)REGION_NAME_KEY, null)) != null) {
            String regionEventType = DataReader.optString((Map)eventData, (String)REGION_EVENT_TYPE_KEY, (String)"");
            String logMessage = String.format(Locale.US, "Places - Processed %s for region \"%s\".", regionEventType, regionName != null ? regionName : "");
            this.parent.logLocalUI(AssuranceConstants.UILogColorVisibility.HIGH, logMessage);
        }
    }
}

