/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionEventListener;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceExtension;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.Locale;
import java.util.Map;

class AssuranceListenerHubPlacesRequests
implements ExtensionEventListener {
    private static final String LOG_TAG = "AssuranceListenerHubPlacesRequests";
    private static final String COUNT_KEY = "count";
    private static final String LATITUDE_KEY = "latitude";
    private static final String LONGITUDE_KEY = "longitude";
    private static final String GET_NEARBY_PLACES_EVENT_NAME = "requestgetnearbyplaces";
    private static final String RESET_PLACES_EVENT_NAME = "requestreset";
    private final AssuranceExtension parent;

    AssuranceListenerHubPlacesRequests(AssuranceExtension extension) {
        this.parent = extension;
    }

    public void hear(Event event) {
        String eventName = event.getName();
        Map eventData = event.getEventData();
        if (eventName == null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"[hear] Event name is null", (Object[])new Object[0]);
            return;
        }
        if (eventName.equals(GET_NEARBY_PLACES_EVENT_NAME)) {
            if (AssuranceUtil.isNullOrEmpty(eventData)) {
                Log.debug((String)"Assurance", (String)LOG_TAG, (String)"[hear] for event requestgetnearbyplaces - Event data is null", (Object[])new Object[0]);
                return;
            }
            try {
                int count = DataReader.getInt((Map)eventData, (String)COUNT_KEY);
                double latitude = DataReader.getDouble((Map)eventData, (String)LATITUDE_KEY);
                double longitude = DataReader.getDouble((Map)eventData, (String)LONGITUDE_KEY);
                String logMessage = String.format(Locale.US, "Places - Requesting %d nearby POIs from (%.6f, %.6f)", count, latitude, longitude);
                this.parent.logLocalUI(AssuranceConstants.UILogColorVisibility.NORMAL, logMessage);
            }
            catch (DataReaderException ex) {
                Log.warning((String)"Assurance", (String)LOG_TAG, (String)("Unable to log-local Places event: " + ex.getLocalizedMessage()), (Object[])new Object[0]);
            }
        } else if (eventName.equals(RESET_PLACES_EVENT_NAME)) {
            this.parent.logLocalUI(AssuranceConstants.UILogColorVisibility.CRITICAL, "Places - Resetting Location");
        }
    }
}

