/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.content.Context;
import android.content.res.XmlResourceParser;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.IOException;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

final class AssuranceIOUtils {
    private static final String LOG_TAG = "AssuranceIOUtils";

    private AssuranceIOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONObject parseXMLResourceFileToJson(String xmlFileName) {
        try (XmlResourceParser xmlResParser = null;){
            Context appContext = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
            if (appContext == null) {
                JSONObject jSONObject = new JSONObject();
                return jSONObject;
            }
            xmlResParser = appContext.createPackageContext(appContext.getPackageName(), 0).getAssets().openXmlResourceParser(xmlFileName);
            xmlResParser.next();
            JSONObject jSONObject = AssuranceIOUtils.convertXMLToJSON((XmlPullParser)xmlResParser);
            return jSONObject;
        }
        return new JSONObject();
    }

    static JSONObject convertXMLToJSON(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException, JSONException {
        Stack<JSONObject> xmlJsonObjectStack = new Stack<JSONObject>();
        while (xmlPullParser.getEventType() != 1) {
            switch (xmlPullParser.getEventType()) {
                case 0: {
                    xmlJsonObjectStack.add(new JSONObject());
                    xmlPullParser.next();
                    break;
                }
                case 2: {
                    JSONObject jsonObject = new JSONObject();
                    int count = xmlPullParser.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        jsonObject.put(xmlPullParser.getAttributeName(i), (Object)xmlPullParser.getAttributeValue(i));
                    }
                    xmlJsonObjectStack.push(jsonObject);
                    xmlPullParser.next();
                    break;
                }
                case 4: {
                    JSONObject jsonObj = (JSONObject)xmlJsonObjectStack.peek();
                    String content = xmlPullParser.getText().trim();
                    if (!StringUtils.isNullOrEmpty((String)content)) {
                        jsonObj.put("content", (Object)content);
                    }
                    xmlPullParser.next();
                    break;
                }
                case 3: {
                    JSONObject jsonObjChild = (JSONObject)xmlJsonObjectStack.pop();
                    JSONObject jsonObjectParent = (JSONObject)xmlJsonObjectStack.peek();
                    if (jsonObjectParent.has(xmlPullParser.getName())) {
                        if (jsonObjectParent.get(xmlPullParser.getName()) instanceof JSONArray) {
                            JSONArray arr = (JSONArray)jsonObjectParent.get(xmlPullParser.getName());
                            arr.put((Object)jsonObjChild);
                        } else {
                            JSONObject obj = (JSONObject)jsonObjectParent.get(xmlPullParser.getName());
                            JSONArray jsonArray = new JSONArray();
                            jsonArray.put((Object)obj).put((Object)jsonObjChild);
                            jsonObjectParent.put(xmlPullParser.getName(), (Object)jsonArray);
                        }
                    } else {
                        jsonObjectParent.put(xmlPullParser.getName(), (Object)jsonObjChild);
                    }
                    xmlPullParser.next();
                }
            }
        }
        return (JSONObject)xmlJsonObjectStack.pop();
    }
}

