/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.ExtensionEventListener;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.assurance.internal.AssuranceAppState;
import com.adobe.marketing.mobile.assurance.internal.AssuranceComponentRegistry;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConnectionDataStore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceConstants;
import com.adobe.marketing.mobile.assurance.internal.AssuranceEvent;
import com.adobe.marketing.mobile.assurance.internal.AssuranceListenerHubPlacesRequests;
import com.adobe.marketing.mobile.assurance.internal.AssuranceListenerHubPlacesResponses;
import com.adobe.marketing.mobile.assurance.internal.AssurancePlugin;
import com.adobe.marketing.mobile.assurance.internal.AssurancePluginConfigSwitcher;
import com.adobe.marketing.mobile.assurance.internal.AssurancePluginFakeEventGenerator;
import com.adobe.marketing.mobile.assurance.internal.AssurancePluginLogForwarder;
import com.adobe.marketing.mobile.assurance.internal.AssurancePluginScreenshot;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSessionOrchestrator;
import com.adobe.marketing.mobile.assurance.internal.AssuranceStateManager;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.assurance.internal.ui.AssuranceActivity;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public final class AssuranceExtension
extends Extension {
    private static final String LOG_TAG = "AssuranceExtension";
    private static final long ASSURANCE_SHUTDOWN_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private final AssuranceStateManager assuranceStateManager;
    private final AssuranceSessionOrchestrator assuranceSessionOrchestrator;
    private final AssuranceConnectionDataStore assuranceConnectionDataStore;
    private static boolean shouldUnregisterOnTimeout = true;

    AssuranceExtension(ExtensionApi extensionApi) {
        this(extensionApi, new AssuranceStateManager(extensionApi), new AssuranceConnectionDataStore((Context)MobileCore.getApplication()), Collections.unmodifiableList(Arrays.asList(new AssurancePluginLogForwarder(), new AssurancePluginScreenshot(), new AssurancePluginConfigSwitcher(), new AssurancePluginFakeEventGenerator())));
    }

    @VisibleForTesting
    AssuranceExtension(ExtensionApi extensionApi, AssuranceStateManager assuranceStateManager2, AssuranceConnectionDataStore assuranceConnectionDataStore, List<AssurancePlugin> plugins) {
        this(extensionApi, assuranceStateManager2, assuranceConnectionDataStore, new AssuranceSessionOrchestrator(MobileCore.getApplication(), assuranceStateManager2, plugins, assuranceConnectionDataStore));
    }

    @VisibleForTesting
    AssuranceExtension(ExtensionApi extensionApi, AssuranceStateManager assuranceStateManager2, AssuranceConnectionDataStore assuranceConnectionDataStore, AssuranceSessionOrchestrator assuranceSessionOrchestrator) {
        super(extensionApi);
        this.assuranceStateManager = assuranceStateManager2;
        this.assuranceConnectionDataStore = assuranceConnectionDataStore;
        this.assuranceSessionOrchestrator = assuranceSessionOrchestrator;
    }

    void startSession(String deeplink) {
        shouldUnregisterOnTimeout = false;
        if (this.assuranceSessionOrchestrator == null) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Unable to start Assurance session. Make sure Assurance Extension is registered before startSession() is called.", (Object[])new Object[0]);
            return;
        }
        if (this.assuranceSessionOrchestrator.getActiveSession() != null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Unable to start Assurance session. Session already exists", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)deeplink)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Unable to start Assurance session. Obtained null or empty deeplink url", (Object[])new Object[0]);
            return;
        }
        Uri uri = Uri.parse((String)deeplink);
        String sessionId = AssuranceUtil.getValidSessionIDFromUri(uri);
        if (StringUtils.isNullOrEmpty((String)sessionId)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)String.format("Unable to start Assurance session. The assurance sessionId obtained deeplink is invalid. Deeplink : %s", deeplink), (Object[])new Object[0]);
            return;
        }
        AssuranceConstants.AssuranceEnvironment environment = AssuranceUtil.getEnvironmentFromQueryValue(uri.getQueryParameter("env"));
        Application hostApplication = MobileCore.getApplication();
        if (hostApplication == null) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Unable to start Assurance session. Host application is null", (Object[])new Object[0]);
            return;
        }
        AssuranceComponentRegistry.appState.onSessionPhaseChange(new AssuranceAppState.SessionPhase.Authorizing(new AssuranceAppState.AssuranceAuthorization.PinConnect(sessionId, environment)));
        Intent intent = new Intent((Context)hostApplication, AssuranceActivity.class);
        intent.addFlags(65536);
        intent.addFlags(131072);
        intent.addFlags(0x10000000);
        hostApplication.startActivity(intent);
    }

    void startSession() {
        shouldUnregisterOnTimeout = false;
        Application hostApplication = ServiceProvider.getInstance().getAppContextService().getApplication();
        if (hostApplication == null || !AssuranceUtil.isDebugBuild(hostApplication)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"startSession() API is available only on debug builds.", (Object[])new Object[0]);
            return;
        }
        if (this.assuranceSessionOrchestrator.getActiveSession() != null) {
            Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Unable to start Assurance session. Session already exists", (Object[])new Object[0]);
            return;
        }
        AssuranceComponentRegistry.appState.onSessionPhaseChange(new AssuranceAppState.SessionPhase.Authorizing(new AssuranceAppState.AssuranceAuthorization.QuickConnect(AssuranceConstants.AssuranceEnvironment.PROD)));
        Intent intent = new Intent((Context)hostApplication, AssuranceActivity.class);
        intent.addFlags(65536);
        intent.addFlags(131072);
        intent.addFlags(0x10000000);
        hostApplication.startActivity(intent);
    }

    protected String getName() {
        return "com.adobe.assurance";
    }

    protected String getFriendlyName() {
        return "Assurance";
    }

    protected String getVersion() {
        return "3.0.7";
    }

    protected void onRegistered() {
        super.onRegistered();
        this.getApi().registerEventListener("com.adobe.eventType._wildcard_", "com.adobe.eventSource._wildcard_", this::handleWildcardEvent);
        this.getApi().registerEventListener("com.adobe.eventType.assurance", "com.adobe.eventSource.requestContent", this::handleAssuranceRequestContent);
        this.getApi().registerEventListener("com.adobe.eventType.places", "com.adobe.eventSource.requestContent", (ExtensionEventListener)new AssuranceListenerHubPlacesRequests(this));
        this.getApi().registerEventListener("com.adobe.eventType.places", "com.adobe.eventSource.responseContent", (ExtensionEventListener)new AssuranceListenerHubPlacesResponses(this));
        this.publishAssuranceSharedState();
        if (this.attemptReconnect()) {
            return;
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (shouldUnregisterOnTimeout) {
                    AssuranceExtension.this.shutDownAssurance();
                }
            }
        }, ASSURANCE_SHUTDOWN_TIMEOUT);
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)String.format("Assurance extension version %s is successfully registered", "3.0.7"), (Object[])new Object[0]);
    }

    protected void onUnregistered() {
        super.onUnregistered();
    }

    public boolean readyForEvent(Event event) {
        return true;
    }

    void handleWildcardEvent(Event event) {
        this.assuranceStateManager.onSDKEvent(event);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("ACPExtensionEventName", event.getName());
        payload.put("ACPExtensionEventType", event.getType().toLowerCase());
        payload.put("ACPExtensionEventSource", event.getSource().toLowerCase());
        payload.put("ACPExtensionEventUniqueIdentifier", event.getUniqueIdentifier());
        payload.put("ACPExtensionEventData", event.getEventData());
        String parentId = event.getParentID();
        if (!StringUtils.isNullOrEmpty((String)parentId)) {
            payload.put("ACPExtensionEventParentIdentifier", parentId);
        }
        if ("com.adobe.eventSource.sharedState".equalsIgnoreCase(event.getSource())) {
            this.processSharedStateEvent(event, payload);
            return;
        }
        AssuranceEvent assuranceEvent = new AssuranceEvent("generic", payload);
        this.assuranceSessionOrchestrator.queueEvent(assuranceEvent);
    }

    void handleAssuranceRequestContent(Event event) {
        Map eventData = event.getEventData();
        boolean isQuickConnectEvent = DataReader.optBoolean((Map)eventData, (String)"quickConnect", (boolean)false);
        if (isQuickConnectEvent) {
            this.startSession();
            return;
        }
        String sessionURL = DataReader.optString((Map)eventData, (String)"startSessionURL", (String)"");
        if (!StringUtils.isNullOrEmpty((String)sessionURL)) {
            this.startSession(sessionURL);
            return;
        }
        Log.warning((String)"Assurance", (String)LOG_TAG, (String)"Unable to process start session event. Could find start session URL or quick connect flag in the event", (Object[])new Object[0]);
    }

    private void publishAssuranceSharedState() {
        String sessionID = this.assuranceStateManager.getSessionId();
        if (!StringUtils.isNullOrEmpty((String)sessionID)) {
            this.assuranceStateManager.shareAssuranceSharedState(sessionID);
        }
    }

    private void processSharedStateEvent(Event event, Map<String, Object> payload) {
        Map eventData = event.getEventData();
        if (AssuranceUtil.isNullOrEmpty(eventData)) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)"EventData for shared state change event is null. Ignoring event", (Object[])new Object[0]);
            return;
        }
        try {
            String stateDataKey;
            SharedStateResult sharedStateResult;
            String stateOwner = DataReader.getString((Map)eventData, (String)"stateowner");
            if ("Shared state change (XDM)".equals(event.getName())) {
                sharedStateResult = this.getApi().getXDMSharedState(stateOwner, event, false, SharedStateResolution.ANY);
                stateDataKey = "xdm.state.data";
            } else {
                sharedStateResult = this.getApi().getSharedState(stateOwner, event, false, SharedStateResolution.ANY);
                stateDataKey = "state.data";
            }
            if (sharedStateResult == null || sharedStateResult.getStatus() != SharedStateStatus.SET) {
                return;
            }
            payload.put("metadata", new HashMap<String, Object>(){
                {
                    this.put(stateDataKey, sharedStateResult.getValue());
                }
            });
            this.assuranceSessionOrchestrator.queueEvent(new AssuranceEvent("generic", payload));
        }
        catch (DataReaderException ex) {
            Log.warning((String)"Assurance", (String)LOG_TAG, (String)("Unable to extract state owner from shared state change event: " + ex.getLocalizedMessage()), (Object[])new Object[0]);
        }
    }

    private void shutDownAssurance() {
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)"Timeout - Assurance did not receive deeplink to start Assurance session within 5 seconds. Shutting down Assurance extension", (Object[])new Object[0]);
        this.assuranceSessionOrchestrator.terminateSession(true);
    }

    private boolean attemptReconnect() {
        return this.assuranceSessionOrchestrator.reconnectToStoredSession();
    }

    void logLocalUI(AssuranceConstants.UILogColorVisibility visibility, String message) {
        AssuranceSession session = this.assuranceSessionOrchestrator.getActiveSession();
        if (session != null) {
            session.logLocalUI(visibility, message);
        }
    }
}

