/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import com.adobe.marketing.mobile.util.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

final class AssuranceEvent {
    final String eventID;
    final String vendor;
    final String type;
    final Map<String, Object> metadata;
    final Map<String, Object> payload;
    final long timestamp;
    final int eventNumber;
    private static final AtomicInteger ASSURANCE_EVENT_SEQUENCE_COUNTER = new AtomicInteger(0);

    AssuranceEvent(String type, Map<String, Object> payload) {
        this("com.adobe.griffon.mobile", type, null, payload, System.currentTimeMillis());
    }

    AssuranceEvent(String vendor, String type, Map<String, Object> metadata, Map<String, Object> payload, long timestamp) {
        this(UUID.randomUUID().toString(), vendor, type, metadata, payload, timestamp, ASSURANCE_EVENT_SEQUENCE_COUNTER.addAndGet(1));
    }

    private AssuranceEvent(String eventID, String vendor, String type, Map<String, Object> metadata, Map<String, Object> payload, long timestamp, int eventNumber) {
        this.eventID = eventID;
        this.vendor = vendor;
        this.type = type;
        this.metadata = metadata;
        this.payload = payload;
        this.timestamp = timestamp;
        this.eventNumber = eventNumber;
    }

    AssuranceEvent(String json) throws JSONException {
        JSONObject eventMap = new JSONObject(json);
        this.eventID = eventMap.getString("eventID");
        this.vendor = eventMap.getString("vendor");
        this.type = eventMap.getString("type");
        JSONObject metadataObj = eventMap.optJSONObject("metadata");
        this.metadata = metadataObj != null ? JSONUtils.toMap((JSONObject)metadataObj) : null;
        JSONObject payloadObj = eventMap.optJSONObject("payload");
        this.payload = payloadObj != null ? JSONUtils.toMap((JSONObject)payloadObj) : null;
        this.timestamp = eventMap.optLong("timestamp", System.currentTimeMillis());
        this.eventNumber = eventMap.optInt("eventNumber", ASSURANCE_EVENT_SEQUENCE_COUNTER.addAndGet(1));
    }

    String getJSONRepresentation() {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("eventID", this.eventID);
        eventMap.put("vendor", this.vendor);
        eventMap.put("type", this.type);
        eventMap.put("timestamp", this.timestamp);
        eventMap.put("eventNumber", this.eventNumber);
        if (this.metadata != null) {
            eventMap.put("metadata", this.metadata);
        }
        if (this.payload != null) {
            eventMap.put("payload", this.payload);
        }
        JSONObject jsonObj = new JSONObject(eventMap);
        return jsonObj.toString();
    }

    String getControlType() {
        if (!"control".equals(this.type)) {
            return null;
        }
        if (this.payload == null || this.payload.isEmpty() || !this.payload.containsKey("type")) {
            return null;
        }
        if (!(this.payload.get("type") instanceof String)) {
            return null;
        }
        return (String)this.payload.get("type");
    }

    HashMap<String, Object> getControlDetail() {
        if (!"control".equals(this.type)) {
            return null;
        }
        if (this.payload == null || this.payload.isEmpty() || !this.payload.containsKey("detail")) {
            return null;
        }
        if (!(this.payload.get("detail") instanceof HashMap)) {
            return null;
        }
        return (HashMap)this.payload.get("detail");
    }

    String getVendor() {
        return this.vendor;
    }

    Map<String, Object> getMetadata() {
        return this.metadata;
    }

    Map<String, Object> getPayload() {
        return this.payload;
    }

    String getEventType() {
        return this.type;
    }
}

