/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.content.Context;
import com.adobe.marketing.mobile.assurance.R;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0015\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants;", "", "()V", "VENDOR_ASSURANCE_MOBILE", "", "AssuranceConnectionError", "AssuranceEnvironment", "AssuranceEventKeys", "AssuranceEventType", "BlobKeys", "ClientInfoKeys", "ControlType", "DataStoreKeys", "DeeplinkURLKeys", "DeviceInfoKeys", "GenericEventPayloadKey", "PayloadDataKeys", "QuickConnect", "SDKConfigurationKey", "SDKEventDataKey", "SDKEventName", "SDKSharedStateName", "SharedStateKeys", "SocketCloseCode", "SocketURLKeys", "UILogColorVisibility", "assurance_phoneRelease"})
public final class AssuranceConstants {
    @NotNull
    public static final AssuranceConstants INSTANCE = new AssuranceConstants();
    @NotNull
    public static final String VENDOR_ASSURANCE_MOBILE = "com.adobe.griffon.mobile";

    private AssuranceConstants() {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceConnectionError;", "", "errorResId", "", "descriptionResId", "isRetryable", "", "(Ljava/lang/String;IIIZ)V", "description", "", "getDescription", "()Ljava/lang/String;", "error", "getError", "GENERIC_ERROR", "NO_ORG_ID", "ORG_ID_MISMATCH", "CONNECTION_LIMIT", "EVENT_LIMIT", "CLIENT_ERROR", "SESSION_DELETED", "CREATE_DEVICE_REQUEST_MALFORMED", "STATUS_CHECK_REQUEST_MALFORMED", "RETRY_LIMIT_REACHED", "CREATE_DEVICE_REQUEST_FAILED", "DEVICE_STATUS_REQUEST_FAILED", "UNEXPECTED_ERROR", "assurance_phoneRelease"})
    public static final class AssuranceConnectionError
    extends Enum<AssuranceConnectionError> {
        private final int errorResId;
        private final int descriptionResId;
        @JvmField
        public final boolean isRetryable;
        public static final /* enum */ AssuranceConnectionError GENERIC_ERROR = new AssuranceConnectionError(R.string.error_title_incorrect_pin_or_network, R.string.error_desc_incorrect_pin_or_network, true);
        public static final /* enum */ AssuranceConnectionError NO_ORG_ID = new AssuranceConnectionError(R.string.error_title_invalid_org_id, R.string.error_desc_invalid_org_id, false);
        public static final /* enum */ AssuranceConnectionError ORG_ID_MISMATCH = new AssuranceConnectionError(R.string.error_title_unauthorized_access, R.string.error_desc_unauthorized_access, false);
        public static final /* enum */ AssuranceConnectionError CONNECTION_LIMIT = new AssuranceConnectionError(R.string.error_title_connection_limit, R.string.error_desc_connection_limit, false);
        public static final /* enum */ AssuranceConnectionError EVENT_LIMIT = new AssuranceConnectionError(R.string.error_title_event_limit, R.string.error_desc_event_limit, false);
        public static final /* enum */ AssuranceConnectionError CLIENT_ERROR = new AssuranceConnectionError(R.string.error_title_unexpected_error, R.string.error_desc_unexpected_error, false);
        public static final /* enum */ AssuranceConnectionError SESSION_DELETED = new AssuranceConnectionError(R.string.error_title_session_deleted, R.string.error_desc_session_deleted, false);
        public static final /* enum */ AssuranceConnectionError CREATE_DEVICE_REQUEST_MALFORMED = new AssuranceConnectionError(R.string.error_title_invalid_registration_request, R.string.error_desc_invalid_registration_request, false);
        public static final /* enum */ AssuranceConnectionError STATUS_CHECK_REQUEST_MALFORMED = new AssuranceConnectionError(R.string.error_title_invalid_registration_request, R.string.error_desc_invalid_registration_request, false);
        public static final /* enum */ AssuranceConnectionError RETRY_LIMIT_REACHED = new AssuranceConnectionError(R.string.error_title_retry_limit_reached, R.string.error_desc_retry_limit_reached, true);
        public static final /* enum */ AssuranceConnectionError CREATE_DEVICE_REQUEST_FAILED = new AssuranceConnectionError(R.string.error_title_registration_error, R.string.error_desc_registration_error, true);
        public static final /* enum */ AssuranceConnectionError DEVICE_STATUS_REQUEST_FAILED = new AssuranceConnectionError(R.string.error_title_registration_error, R.string.error_desc_registration_error, true);
        public static final /* enum */ AssuranceConnectionError UNEXPECTED_ERROR = new AssuranceConnectionError(R.string.error_title_invalid_registration_response, R.string.error_desc_invalid_registration_response, true);
        private static final /* synthetic */ AssuranceConnectionError[] $VALUES;

        private AssuranceConnectionError(int errorResId, int descriptionResId, boolean isRetryable) {
            this.errorResId = errorResId;
            this.descriptionResId = descriptionResId;
            this.isRetryable = isRetryable;
        }

        @NotNull
        public final String getError() {
            Context context;
            Context context2 = context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
            String string2 = context2 != null ? context2.getString(this.errorResId) : null;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @NotNull
        public final String getDescription() {
            Context context;
            Context context2 = context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
            String string2 = context2 != null ? context2.getString(this.descriptionResId) : null;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        public static AssuranceConnectionError[] values() {
            return (AssuranceConnectionError[])$VALUES.clone();
        }

        public static AssuranceConnectionError valueOf(String value) {
            return Enum.valueOf(AssuranceConnectionError.class, value);
        }

        static {
            $VALUES = assuranceConnectionErrorArray = new AssuranceConnectionError[]{AssuranceConnectionError.GENERIC_ERROR, AssuranceConnectionError.NO_ORG_ID, AssuranceConnectionError.ORG_ID_MISMATCH, AssuranceConnectionError.CONNECTION_LIMIT, AssuranceConnectionError.EVENT_LIMIT, AssuranceConnectionError.CLIENT_ERROR, AssuranceConnectionError.SESSION_DELETED, AssuranceConnectionError.CREATE_DEVICE_REQUEST_MALFORMED, AssuranceConnectionError.STATUS_CHECK_REQUEST_MALFORMED, AssuranceConnectionError.RETRY_LIMIT_REACHED, AssuranceConnectionError.CREATE_DEVICE_REQUEST_FAILED, AssuranceConnectionError.DEVICE_STATUS_REQUEST_FAILED, AssuranceConnectionError.UNEXPECTED_ERROR};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;", "", "stringValue", "", "(Ljava/lang/String;ILjava/lang/String;)V", "PROD", "STAGE", "QA", "DEV", "Companion", "assurance_phoneRelease"})
    @SourceDebugExtension(value={"SMAP\nAssuranceConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssuranceConstants.kt\ncom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,366:1\n8811#2,2:367\n9071#2,4:369\n*S KotlinDebug\n*F\n+ 1 AssuranceConstants.kt\ncom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment\n*L\n355#1:367,2\n355#1:369,4\n*E\n"})
    public static final class AssuranceEnvironment
    extends Enum<AssuranceEnvironment> {
        @NotNull
        public static final Companion Companion;
        @JvmField
        @NotNull
        public final String stringValue;
        @NotNull
        private static final Map<String, AssuranceEnvironment> lookup;
        public static final /* enum */ AssuranceEnvironment PROD;
        public static final /* enum */ AssuranceEnvironment STAGE;
        public static final /* enum */ AssuranceEnvironment QA;
        public static final /* enum */ AssuranceEnvironment DEV;
        private static final /* synthetic */ AssuranceEnvironment[] $VALUES;

        private AssuranceEnvironment(String stringValue) {
            this.stringValue = stringValue;
        }

        public static AssuranceEnvironment[] values() {
            return (AssuranceEnvironment[])$VALUES.clone();
        }

        public static AssuranceEnvironment valueOf(String value) {
            return Enum.valueOf(AssuranceEnvironment.class, value);
        }

        @JvmStatic
        @JvmName(name="get")
        @NotNull
        public static final AssuranceEnvironment get(@NotNull String stringValue) {
            return Companion.get(stringValue);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            PROD = new AssuranceEnvironment("prod");
            STAGE = new AssuranceEnvironment("stage");
            QA = new AssuranceEnvironment("qa");
            DEV = new AssuranceEnvironment("dev");
            $VALUES = assuranceEnvironmentArray = new AssuranceEnvironment[]{AssuranceEnvironment.PROD, AssuranceEnvironment.STAGE, AssuranceEnvironment.QA, AssuranceEnvironment.DEV};
            Companion = new Companion(null);
            AssuranceEnvironment[] $this$associateBy$iv = AssuranceEnvironment.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            AssuranceEnvironment[] assuranceEnvironmentArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.stringValue, element$iv$iv);
            }
            lookup = destination$iv$iv;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0081\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment$Companion;", "", "()V", "lookup", "", "", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEnvironment;", "get", "stringValue", "assurance_phoneRelease"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @JvmName(name="get")
            @NotNull
            public final AssuranceEnvironment get(@NotNull String stringValue) {
                Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
                AssuranceEnvironment enumValue = (AssuranceEnvironment)((Object)lookup.get(stringValue));
                AssuranceEnvironment assuranceEnvironment = enumValue;
                if (assuranceEnvironment == null) {
                    assuranceEnvironment = PROD;
                }
                return assuranceEnvironment;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEventKeys;", "", "()V", "CHUNK_DATA", "", "CHUNK_ID", "CHUNK_SEQUENCE_NUMBER", "CHUNK_TOTAL", "EVENT_ID", "EVENT_NUMBER", "METADATA", "PAYLOAD", "TIMESTAMP", "TYPE", "VENDOR", "assurance_phoneRelease"})
    public static final class AssuranceEventKeys {
        @NotNull
        public static final AssuranceEventKeys INSTANCE = new AssuranceEventKeys();
        @NotNull
        public static final String EVENT_ID = "eventID";
        @NotNull
        public static final String VENDOR = "vendor";
        @NotNull
        public static final String TYPE = "type";
        @NotNull
        public static final String PAYLOAD = "payload";
        @NotNull
        public static final String METADATA = "metadata";
        @NotNull
        public static final String TIMESTAMP = "timestamp";
        @NotNull
        public static final String EVENT_NUMBER = "eventNumber";
        @NotNull
        public static final String CHUNK_DATA = "chunkData";
        @NotNull
        public static final String CHUNK_ID = "chunkId";
        @NotNull
        public static final String CHUNK_TOTAL = "chunkTotal";
        @NotNull
        public static final String CHUNK_SEQUENCE_NUMBER = "chunkSequenceNumber";

        private AssuranceEventKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceEventType;", "", "()V", "BLOB", "", "CLIENT", "CONTROL", "GENERIC", "LOG", "assurance_phoneRelease"})
    public static final class AssuranceEventType {
        @NotNull
        public static final AssuranceEventType INSTANCE = new AssuranceEventType();
        @NotNull
        public static final String GENERIC = "generic";
        @NotNull
        public static final String LOG = "log";
        @NotNull
        public static final String CONTROL = "control";
        @NotNull
        public static final String CLIENT = "client";
        @NotNull
        public static final String BLOB = "blob";

        private AssuranceEventType() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$BlobKeys;", "", "()V", "RESPONSE_KEY_BLOB_ID", "", "RESPONSE_KEY_ERROR", "UPLOAD_ENDPOINT_FORMAT", "UPLOAD_HEADER_KEY_ACCEPT", "UPLOAD_HEADER_KEY_CONTENT_LENGTH", "UPLOAD_HEADER_KEY_CONTENT_TYPE", "UPLOAD_HEADER_KEY_FILE_CONTENT_TYPE", "UPLOAD_HTTP_METHOD", "UPLOAD_PATH_API", "UPLOAD_PATH_FILEUPLOAD", "UPLOAD_QUERY_KEY", "assurance_phoneRelease"})
    public static final class BlobKeys {
        @NotNull
        public static final BlobKeys INSTANCE = new BlobKeys();
        @NotNull
        public static final String UPLOAD_ENDPOINT_FORMAT = "https://blob%s.griffon.adobe.com";
        @NotNull
        public static final String UPLOAD_PATH_API = "api";
        @NotNull
        public static final String UPLOAD_PATH_FILEUPLOAD = "FileUpload";
        @NotNull
        public static final String UPLOAD_QUERY_KEY = "validationSessionId";
        @NotNull
        public static final String UPLOAD_HTTP_METHOD = "POST";
        @NotNull
        public static final String UPLOAD_HEADER_KEY_CONTENT_TYPE = "Content-Type";
        @NotNull
        public static final String UPLOAD_HEADER_KEY_FILE_CONTENT_TYPE = "File-Content-Type";
        @NotNull
        public static final String UPLOAD_HEADER_KEY_CONTENT_LENGTH = "Content-Length";
        @NotNull
        public static final String UPLOAD_HEADER_KEY_ACCEPT = "Accept";
        @NotNull
        public static final String RESPONSE_KEY_BLOB_ID = "id";
        @NotNull
        public static final String RESPONSE_KEY_ERROR = "error";

        private BlobKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$ClientInfoKeys;", "", "()V", "APP_SETTINGS", "", "DEVICE_INFO", "VERSION", "assurance_phoneRelease"})
    public static final class ClientInfoKeys {
        @NotNull
        public static final ClientInfoKeys INSTANCE = new ClientInfoKeys();
        @NotNull
        public static final String VERSION = "version";
        @NotNull
        public static final String DEVICE_INFO = "deviceInfo";
        @NotNull
        public static final String APP_SETTINGS = "appSettings";

        private ClientInfoKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$ControlType;", "", "()V", "CONFIG_UPDATE", "", "FAKE_EVENT", "LOG_FORWARDING", "NONE", "SCREENSHOT", "START_EVENT_FORWARDING", "WILDCARD", "assurance_phoneRelease"})
    public static final class ControlType {
        @NotNull
        public static final ControlType INSTANCE = new ControlType();
        @NotNull
        public static final String START_EVENT_FORWARDING = "startEventForwarding";
        @NotNull
        public static final String SCREENSHOT = "screenshot";
        @NotNull
        public static final String LOG_FORWARDING = "logForwarding";
        @NotNull
        public static final String FAKE_EVENT = "fakeEvent";
        @NotNull
        public static final String CONFIG_UPDATE = "configUpdate";
        @NotNull
        public static final String NONE = "none";
        @NotNull
        public static final String WILDCARD = "wildcard";

        private ControlType() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$DataStoreKeys;", "", "()V", "CLIENT_ID", "", "DATASTORE_NAME", "ENVIRONMENT", "SESSION_ID", "SESSION_URL", "TOKEN", "assurance_phoneRelease"})
    public static final class DataStoreKeys {
        @NotNull
        public static final DataStoreKeys INSTANCE = new DataStoreKeys();
        @NotNull
        public static final String DATASTORE_NAME = "com.adobe.assurance.preferences";
        @NotNull
        public static final String SESSION_URL = "reconnection.url";
        @NotNull
        public static final String ENVIRONMENT = "environment";
        @NotNull
        public static final String CLIENT_ID = "clientid";
        @NotNull
        public static final String SESSION_ID = "sessionid";
        @NotNull
        public static final String TOKEN = "token";

        private DataStoreKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$DeeplinkURLKeys;", "", "()V", "START_URL_QUERY_KEY_ENVIRONMENT", "", "START_URL_QUERY_KEY_SESSION_ID", "assurance_phoneRelease"})
    public static final class DeeplinkURLKeys {
        @NotNull
        public static final DeeplinkURLKeys INSTANCE = new DeeplinkURLKeys();
        @NotNull
        public static final String START_URL_QUERY_KEY_SESSION_ID = "adb_validation_sessionid";
        @NotNull
        public static final String START_URL_QUERY_KEY_ENVIRONMENT = "env";

        private DeeplinkURLKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$DeviceInfoKeys;", "", "()V", "BATTERY_LEVEL", "", "CARRIER_NAME", "DEVICE_MANUFACTURER", "DEVICE_NAME", "DEVICE_TYPE", "LOCATION_AUTHORIZATION_STATUS", "LOCATION_SERVICE_ENABLED", "LOW_POWER_BATTERY_ENABLED", "MODEL", "OPERATING_SYSTEM", "PLATFORM_NAME", "SCREEN_SIZE", "assurance_phoneRelease"})
    public static final class DeviceInfoKeys {
        @NotNull
        public static final DeviceInfoKeys INSTANCE = new DeviceInfoKeys();
        @NotNull
        public static final String PLATFORM_NAME = "Canonical platform name";
        @NotNull
        public static final String DEVICE_NAME = "Device name";
        @NotNull
        public static final String DEVICE_MANUFACTURER = "Device manufacturer";
        @NotNull
        public static final String OPERATING_SYSTEM = "Operating system";
        @NotNull
        public static final String CARRIER_NAME = "Carrier name";
        @NotNull
        public static final String DEVICE_TYPE = "Device type";
        @NotNull
        public static final String MODEL = "Model";
        @NotNull
        public static final String SCREEN_SIZE = "Screen size";
        @NotNull
        public static final String LOCATION_SERVICE_ENABLED = "Location service enabled";
        @NotNull
        public static final String LOCATION_AUTHORIZATION_STATUS = "Location authorization status";
        @NotNull
        public static final String LOW_POWER_BATTERY_ENABLED = "Low power mode enabled";
        @NotNull
        public static final String BATTERY_LEVEL = "Battery level";

        private DeviceInfoKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$GenericEventPayloadKey;", "", "()V", "ACP_EXTENSION_EVENT_DATA", "", "ACP_EXTENSION_EVENT_NAME", "ACP_EXTENSION_EVENT_PARENT_IDENTIFIER", "ACP_EXTENSION_EVENT_SOURCE", "ACP_EXTENSION_EVENT_TYPE", "ACP_EXTENSION_EVENT_UNIQUE_IDENTIFIER", "assurance_phoneRelease"})
    public static final class GenericEventPayloadKey {
        @NotNull
        public static final GenericEventPayloadKey INSTANCE = new GenericEventPayloadKey();
        @NotNull
        public static final String ACP_EXTENSION_EVENT_TYPE = "ACPExtensionEventType";
        @NotNull
        public static final String ACP_EXTENSION_EVENT_SOURCE = "ACPExtensionEventSource";
        @NotNull
        public static final String ACP_EXTENSION_EVENT_NAME = "ACPExtensionEventName";
        @NotNull
        public static final String ACP_EXTENSION_EVENT_DATA = "ACPExtensionEventData";
        @NotNull
        public static final String ACP_EXTENSION_EVENT_UNIQUE_IDENTIFIER = "ACPExtensionEventUniqueIdentifier";
        @NotNull
        public static final String ACP_EXTENSION_EVENT_PARENT_IDENTIFIER = "ACPExtensionEventParentIdentifier";

        private GenericEventPayloadKey() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$PayloadDataKeys;", "", "()V", "ANALYTICS_DEBUG_API_ENABLED", "", "DETAIL", "METADATA", "STATE_DATA", "TYPE", "XDM_STATE_DATA", "assurance_phoneRelease"})
    public static final class PayloadDataKeys {
        @NotNull
        public static final PayloadDataKeys INSTANCE = new PayloadDataKeys();
        @NotNull
        public static final String ANALYTICS_DEBUG_API_ENABLED = "analytics.debugApiEnabled";
        @NotNull
        public static final String STATE_DATA = "state.data";
        @NotNull
        public static final String XDM_STATE_DATA = "xdm.state.data";
        @NotNull
        public static final String METADATA = "metadata";
        @NotNull
        public static final String TYPE = "type";
        @NotNull
        public static final String DETAIL = "detail";

        private PayloadDataKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$QuickConnect;", "", "()V", "BASE_DEVICE_API_URL", "", "CONNECTION_TIMEOUT_MS", "", "getCONNECTION_TIMEOUT_MS", "()I", "DEVICE_API_PATH_CREATE", "DEVICE_API_PATH_STATUS", "KEY_CLIENT_ID", "KEY_DEVICE_NAME", "KEY_ORG_ID", "KEY_SESSION_ID", "KEY_SESSION_TOKEN", "MAX_RETRY_COUNT", "READ_TIMEOUT_MS", "getREAD_TIMEOUT_MS", "STATUS_CHECK_DELAY_MS", "", "getSTATUS_CHECK_DELAY_MS", "()J", "assurance_phoneRelease"})
    public static final class QuickConnect {
        @NotNull
        public static final QuickConnect INSTANCE = new QuickConnect();
        @NotNull
        public static final String BASE_DEVICE_API_URL = "https://device.griffon.adobe.com/device";
        @NotNull
        public static final String DEVICE_API_PATH_CREATE = "create";
        @NotNull
        public static final String DEVICE_API_PATH_STATUS = "status";
        @NotNull
        public static final String KEY_SESSION_ID = "sessionUuid";
        @NotNull
        public static final String KEY_SESSION_TOKEN = "token";
        @NotNull
        public static final String KEY_ORG_ID = "orgId";
        @NotNull
        public static final String KEY_DEVICE_NAME = "deviceName";
        @NotNull
        public static final String KEY_CLIENT_ID = "clientId";
        private static final int CONNECTION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(5L);
        private static final int READ_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(5L);
        private static final long STATUS_CHECK_DELAY_MS = TimeUnit.SECONDS.toMillis(2L);
        public static final int MAX_RETRY_COUNT = 300;

        private QuickConnect() {
        }

        public final int getCONNECTION_TIMEOUT_MS() {
            return CONNECTION_TIMEOUT_MS;
        }

        public final int getREAD_TIMEOUT_MS() {
            return READ_TIMEOUT_MS;
        }

        public final long getSTATUS_CHECK_DELAY_MS() {
            return STATUS_CHECK_DELAY_MS;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SDKConfigurationKey;", "", "()V", "ORG_ID", "", "assurance_phoneRelease"})
    public static final class SDKConfigurationKey {
        @NotNull
        public static final SDKConfigurationKey INSTANCE = new SDKConfigurationKey();
        @NotNull
        public static final String ORG_ID = "experienceCloud.org";

        private SDKConfigurationKey() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SDKEventDataKey;", "", "()V", "EXTENSIONS", "", "FRIENDLY_NAME", "IS_QUICK_CONNECT", "START_SESSION_URL", "STATE_OWNER", "assurance_phoneRelease"})
    public static final class SDKEventDataKey {
        @NotNull
        public static final SDKEventDataKey INSTANCE = new SDKEventDataKey();
        @NotNull
        public static final String START_SESSION_URL = "startSessionURL";
        @NotNull
        public static final String IS_QUICK_CONNECT = "quickConnect";
        @NotNull
        public static final String EXTENSIONS = "extensions";
        @NotNull
        public static final String STATE_OWNER = "stateowner";
        @NotNull
        public static final String FRIENDLY_NAME = "friendlyName";

        private SDKEventDataKey() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SDKEventName;", "", "()V", "SHARED_STATE_CHANGE", "", "XDM_SHARED_STATE_CHANGE", "assurance_phoneRelease"})
    public static final class SDKEventName {
        @NotNull
        public static final SDKEventName INSTANCE = new SDKEventName();
        @NotNull
        public static final String XDM_SHARED_STATE_CHANGE = "Shared state change (XDM)";
        @NotNull
        public static final String SHARED_STATE_CHANGE = "Shared state change";

        private SDKEventName() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SDKSharedStateName;", "", "()V", "CONFIGURATION", "", "EVENTHUB", "assurance_phoneRelease"})
    public static final class SDKSharedStateName {
        @NotNull
        public static final SDKSharedStateName INSTANCE = new SDKSharedStateName();
        @NotNull
        public static final String CONFIGURATION = "com.adobe.module.configuration";
        @NotNull
        public static final String EVENTHUB = "com.adobe.module.eventhub";

        private SDKSharedStateName() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SharedStateKeys;", "", "()V", "ASSURANCE_STATE_CLIENT_ID", "", "ASSURANCE_STATE_INTEGRATION_ID", "ASSURANCE_STATE_SESSION_ID", "assurance_phoneRelease"})
    public static final class SharedStateKeys {
        @NotNull
        public static final SharedStateKeys INSTANCE = new SharedStateKeys();
        @NotNull
        public static final String ASSURANCE_STATE_SESSION_ID = "sessionid";
        @NotNull
        public static final String ASSURANCE_STATE_CLIENT_ID = "clientid";
        @NotNull
        public static final String ASSURANCE_STATE_INTEGRATION_ID = "integrationid";

        private SharedStateKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SocketCloseCode;", "", "()V", "ABNORMAL", "", "CLIENT_ERROR", "CONNECTION_LIMIT", "EVENT_LIMIT", "NORMAL", "ORG_MISMATCH", "SESSION_DELETED", "toAssuranceConnectionError", "Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$AssuranceConnectionError;", "closeCode", "assurance_phoneRelease"})
    public static final class SocketCloseCode {
        @NotNull
        public static final SocketCloseCode INSTANCE = new SocketCloseCode();
        public static final int NORMAL = 1000;
        public static final int ABNORMAL = 1006;
        public static final int ORG_MISMATCH = 4900;
        public static final int CLIENT_ERROR = 4400;
        public static final int CONNECTION_LIMIT = 4901;
        public static final int EVENT_LIMIT = 4902;
        public static final int SESSION_DELETED = 4903;

        private SocketCloseCode() {
        }

        @JvmStatic
        @Nullable
        public static final AssuranceConnectionError toAssuranceConnectionError(int closeCode) {
            AssuranceConnectionError assuranceConnectionError;
            switch (closeCode) {
                case 4900: {
                    assuranceConnectionError = AssuranceConnectionError.ORG_ID_MISMATCH;
                    break;
                }
                case 4400: {
                    assuranceConnectionError = AssuranceConnectionError.CLIENT_ERROR;
                    break;
                }
                case 4901: {
                    assuranceConnectionError = AssuranceConnectionError.CONNECTION_LIMIT;
                    break;
                }
                case 4902: {
                    assuranceConnectionError = AssuranceConnectionError.EVENT_LIMIT;
                    break;
                }
                case 4903: {
                    assuranceConnectionError = AssuranceConnectionError.SESSION_DELETED;
                    break;
                }
                case 1006: {
                    assuranceConnectionError = AssuranceConnectionError.GENERIC_ERROR;
                    break;
                }
                default: {
                    assuranceConnectionError = null;
                }
            }
            return assuranceConnectionError;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$SocketURLKeys;", "", "()V", "CLIENT_ID", "", "ORG_ID", "SESSION_ID", "TOKEN", "assurance_phoneRelease"})
    public static final class SocketURLKeys {
        @NotNull
        public static final SocketURLKeys INSTANCE = new SocketURLKeys();
        @NotNull
        public static final String SESSION_ID = "sessionId";
        @NotNull
        public static final String CLIENT_ID = "clientId";
        @NotNull
        public static final String ORG_ID = "orgId";
        @NotNull
        public static final String TOKEN = "token";

        private SocketURLKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/adobe/marketing/mobile/assurance/internal/AssuranceConstants$UILogColorVisibility;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "LOW", "NORMAL", "HIGH", "CRITICAL", "assurance_phoneRelease"})
    public static final class UILogColorVisibility
    extends Enum<UILogColorVisibility> {
        private final int value;
        public static final /* enum */ UILogColorVisibility LOW = new UILogColorVisibility(0);
        public static final /* enum */ UILogColorVisibility NORMAL = new UILogColorVisibility(1);
        public static final /* enum */ UILogColorVisibility HIGH = new UILogColorVisibility(2);
        public static final /* enum */ UILogColorVisibility CRITICAL = new UILogColorVisibility(3);
        private static final /* synthetic */ UILogColorVisibility[] $VALUES;

        private UILogColorVisibility(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static UILogColorVisibility[] values() {
            return (UILogColorVisibility[])$VALUES.clone();
        }

        public static UILogColorVisibility valueOf(String value) {
            return Enum.valueOf(UILogColorVisibility.class, value);
        }

        static {
            $VALUES = uILogColorVisibilityArray = new UILogColorVisibility[]{UILogColorVisibility.LOW, UILogColorVisibility.NORMAL, UILogColorVisibility.HIGH, UILogColorVisibility.CRITICAL};
        }
    }
}

