/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.adobe.marketing.mobile.services.Log;

class AssuranceConnectionDataStore {
    private static final String LOG_TAG = "AssuranceConnectionDataStore";
    private final SharedPreferences sharedPreferences;

    AssuranceConnectionDataStore(Context context) {
        this.sharedPreferences = context == null ? null : context.getSharedPreferences("com.adobe.assurance.preferences", 0);
    }

    String getStoredConnectionURL() {
        if (this.sharedPreferences == null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Unable to get connection URL from persistence, SharedPreference instance is null", (Object[])new Object[0]);
            return null;
        }
        return this.sharedPreferences.getString("reconnection.url", null);
    }

    void saveConnectionURL(String url) {
        if (this.sharedPreferences == null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Unable to get connection URL from persistence, SharedPreference instance is null", (Object[])new Object[0]);
            return;
        }
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        if (editor == null) {
            Log.error((String)"Assurance", (String)LOG_TAG, (String)"Unable to get connection URL from persistence, SharedPreference Editor instance is null", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Assurance", (String)LOG_TAG, (String)("Session URL stored is:" + url), (Object[])new Object[0]);
        editor.putString("reconnection.url", url);
        editor.apply();
    }
}

