/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.location.LocationManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.ActivityCompat;
import com.adobe.marketing.mobile.Assurance;
import com.adobe.marketing.mobile.assurance.internal.AssuranceIOUtils;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

final class AssuranceClientInfo {
    private static final String VALUE_UNKNOWN = "Unknown";
    private static final String MANIFEST_FILE_NAME = "AndroidManifest.xml";
    private static final String EVENT_TYPE_CONNECT = "connect";
    private static final String KEY_MANIFEST = "manifest";
    private static final String KEY_PACKAGE = "package";
    private static final String FALLBACK_KEY_VERSION_NAME = "versionName";
    private static final String FALLBACK_KEY_VERSION_CODE = "versionCode";
    private static final String FALLBACK_KEY_APPLICATION = "application";
    private static final String FALLBACK_KEY_APPLICATION_NAME = "name";
    private final JSONObject manifestData;

    AssuranceClientInfo() {
        JSONObject parsedManifest = AssuranceIOUtils.parseXMLResourceFileToJson(MANIFEST_FILE_NAME);
        boolean isValid = this.validateManifestData(parsedManifest);
        this.manifestData = isValid ? parsedManifest : this.getFallbackManifestData();
    }

    Map<String, Object> getData() {
        HashMap<String, Object> eventPayload = new HashMap<String, Object>();
        eventPayload.put("version", Assurance.extensionVersion());
        eventPayload.put("deviceInfo", this.getDeviceInfo());
        eventPayload.put("type", EVENT_TYPE_CONNECT);
        eventPayload.put("appSettings", this.manifestData);
        return eventPayload;
    }

    private HashMap<String, Object> getDeviceInfo() {
        HashMap<String, Object> deviceInfo = new HashMap<String, Object>();
        deviceInfo.put("Canonical platform name", "Android");
        deviceInfo.put("Device name", Build.MODEL);
        deviceInfo.put("Device type", Build.DEVICE);
        deviceInfo.put("Device manufacturer", Build.MANUFACTURER);
        deviceInfo.put("Operating system", "Android " + Build.VERSION.RELEASE);
        deviceInfo.put("Carrier name", this.getMobileCarrierName());
        deviceInfo.put("Battery level", this.getBatteryPercentage());
        deviceInfo.put("Screen size", this.getScreenSize());
        deviceInfo.put("Location service enabled", this.isLocationEnabled());
        deviceInfo.put("Location authorization status", this.getCurrentLocationPermission());
        deviceInfo.put("Low power mode enabled", this.isPowerSaveModeEnabled());
        return deviceInfo;
    }

    private String getMobileCarrierName() {
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return VALUE_UNKNOWN;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getNetworkOperatorName() : VALUE_UNKNOWN;
    }

    private int getBatteryPercentage() {
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            BatteryManager bm = (BatteryManager)context.getSystemService("batterymanager");
            return bm.getIntProperty(4);
        }
        IntentFilter iFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = context.registerReceiver(null, iFilter);
        int level = batteryStatus != null ? batteryStatus.getIntExtra("level", -1) : -1;
        int scale = batteryStatus != null ? batteryStatus.getIntExtra("scale", -1) : -1;
        double batteryPct = (double)level / (double)scale;
        return (int)(batteryPct * 100.0);
    }

    private String getScreenSize() {
        int height = Resources.getSystem().getDisplayMetrics().heightPixels;
        int width = Resources.getSystem().getDisplayMetrics().widthPixels;
        return String.format(Locale.US, "%dx%d", width, height);
    }

    private Boolean isLocationEnabled() {
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            LocationManager lm = (LocationManager)context.getSystemService("location");
            return lm.isLocationEnabled();
        }
        int mode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode", (int)0);
        return mode != 0;
    }

    private String getCurrentLocationPermission() {
        if (!this.isRuntimePermissionRequired()) {
            return "Always";
        }
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return VALUE_UNKNOWN;
        }
        int permissionStatus = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
        if (permissionStatus == 0) {
            if (this.isBackgroundLocationAccessGrantedByDefault() || this.isBackgroundPermissionGranted()) {
                return "Always";
            }
            return "When in use";
        }
        if (permissionStatus == -1) {
            return "Denied";
        }
        return "unknown";
    }

    private boolean isRuntimePermissionRequired() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private boolean isBackgroundLocationAccessGrantedByDefault() {
        return Build.VERSION.SDK_INT < 29;
    }

    private boolean isBackgroundPermissionGranted() {
        if (!this.isRuntimePermissionRequired()) {
            return true;
        }
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return false;
        }
        int permissionState = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
        if (permissionState == 0) {
            if (!this.isBackgroundLocationAccessGrantedByDefault()) {
                int bgLocationPermissionState = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION");
                return bgLocationPermissionState == 0;
            }
            return true;
        }
        return false;
    }

    private boolean isPowerSaveModeEnabled() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return false;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isPowerSaveMode();
    }

    @VisibleForTesting
    boolean validateManifestData(JSONObject manifestData) {
        if (manifestData == null) {
            return false;
        }
        JSONObject manifest = manifestData.optJSONObject(KEY_MANIFEST);
        if (manifest == null) {
            return false;
        }
        String parsedPackageName = manifest.optString(KEY_PACKAGE, "");
        Application app = ServiceProvider.getInstance().getAppContextService().getApplication();
        return app != null && parsedPackageName.equals(app.getPackageName());
    }

    @VisibleForTesting
    JSONObject getFallbackManifestData() {
        Application app = ServiceProvider.getInstance().getAppContextService().getApplication();
        JSONObject result = new JSONObject();
        JSONObject manifestJson = new JSONObject();
        if (app == null) {
            return manifestJson;
        }
        try {
            String appPackageName = app.getPackageName();
            manifestJson.put(KEY_PACKAGE, (Object)appPackageName);
            PackageManager pm = app.getApplicationContext().getPackageManager();
            try {
                PackageInfo packageInfo = pm.getPackageInfo(appPackageName, 4096);
                String versionName = packageInfo.versionName;
                String versionCode = String.valueOf(packageInfo.versionCode);
                manifestJson.put(FALLBACK_KEY_VERSION_NAME, (Object)versionName);
                manifestJson.put(FALLBACK_KEY_VERSION_CODE, (Object)versionCode);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.d((String)"Assurance", (String)("Failed to get package info for " + appPackageName));
            }
            ApplicationInfo appInfo = app.getApplicationInfo();
            if (appInfo != null) {
                String applicationName = appInfo.name;
                JSONObject applicationJson = new JSONObject();
                applicationJson.put(FALLBACK_KEY_APPLICATION_NAME, (Object)applicationName);
                manifestJson.put(FALLBACK_KEY_APPLICATION, (Object)applicationJson);
            }
            result.put(KEY_MANIFEST, (Object)manifestJson);
        }
        catch (JSONException e) {
            Log.d((String)"Assurance", (String)"Failed to put version details into fallbackManifestData");
        }
        return result;
    }
}

