/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.assurance.internal;

import android.net.Uri;
import com.adobe.marketing.mobile.assurance.internal.AssuranceSession;
import com.adobe.marketing.mobile.assurance.internal.AssuranceUtil;
import com.adobe.marketing.mobile.services.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

class AssuranceBlob {
    private static final String LOG_TAG = "AssuranceBlob";

    AssuranceBlob() {
    }

    static void upload(final byte[] blobData, final String contentType, final AssuranceSession session, final BlobUploadCallback callback) {
        if (blobData == null) {
            AssuranceBlob.uploadFailure(callback, "Sending Blob failed, blobData is null");
            return;
        }
        if (session == null) {
            AssuranceBlob.uploadFailure(callback, "Unable to upload blob, assurance session instance unavailable");
            AssuranceBlob.uploadFailure(callback, "Unable to upload blob, assurance session instance unavailable");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String error;
                    String inputLine;
                    String environmentFormat = AssuranceUtil.getURLFormatForEnvironment(session.getAssuranceEnvironment());
                    String sessionId = session.getSessionId();
                    String endpoint = String.format("https://blob%s.griffon.adobe.com", environmentFormat);
                    Uri uri = new Uri.Builder().encodedPath(endpoint).appendPath("api").appendPath("FileUpload").appendQueryParameter("validationSessionId", sessionId != null && !sessionId.isEmpty() ? sessionId : "").build();
                    URL destinationURL = new URL(uri.toString());
                    HttpURLConnection connection = (HttpURLConnection)destinationURL.openConnection();
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setUseCaches(false);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/octet-stream");
                    connection.setRequestProperty("File-Content-Type", contentType);
                    connection.setRequestProperty("Content-Length", "" + blobData.length);
                    connection.setRequestProperty("Accept", "application/json");
                    DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
                    outputStream.write(blobData);
                    int responseCode = connection.getResponseCode();
                    String responseMessage = connection.getResponseMessage();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = bufferedReader.readLine()) != null) {
                        response.append(inputLine);
                    }
                    outputStream.flush();
                    outputStream.close();
                    JSONObject jsonResponse = new JSONObject(response.toString());
                    if (jsonResponse.has("error") && !(error = jsonResponse.getString("error")).isEmpty()) {
                        callback.onFailure("Error occurred when posting blob, error - " + error);
                        return;
                    }
                    if (jsonResponse.has("id")) {
                        String value = jsonResponse.getString("id");
                        if (value.isEmpty()) {
                            AssuranceBlob.uploadFailure(callback, "Uploading Blob failed, Invalid BlobId returned from the fileStorage server");
                            return;
                        }
                        AssuranceBlob.uploadSuccess(callback, value);
                    }
                }
                catch (JSONException ex) {
                    AssuranceBlob.uploadFailure(callback, "Uploading Blob failed, Json exception while parsing response, Error - " + (Object)((Object)ex));
                }
                catch (MalformedURLException ex) {
                    AssuranceBlob.uploadFailure(callback, String.format("Uploading Blob failed, MalformedURLException %s", ex));
                }
                catch (IOException ex) {
                    AssuranceBlob.uploadFailure(callback, String.format("Uploading Blob failed, IOException %s", ex));
                }
                catch (Exception ex) {
                    AssuranceBlob.uploadFailure(callback, String.format("Uploading Blob failed with Exception : %s", ex));
                }
            }
        }).start();
    }

    private static void uploadFailure(BlobUploadCallback callback, String reason) {
        Log.error((String)"Assurance", (String)LOG_TAG, (String)reason, (Object[])new Object[0]);
        if (callback != null) {
            callback.onFailure(reason);
        }
    }

    private static void uploadSuccess(BlobUploadCallback callback, String blobId) {
        Log.debug((String)"Assurance", (String)LOG_TAG, (String)("Blob upload successfull for id:" + blobId), (Object[])new Object[0]);
        if (callback != null) {
            callback.onSuccess(blobId);
        }
    }

    static interface BlobUploadCallback {
        public void onSuccess(String var1);

        public void onFailure(String var1);
    }
}

