/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.assurance.internal.AssuranceExtension;
import com.adobe.marketing.mobile.services.Log;
import java.util.Collections;
import java.util.HashMap;

public class Assurance {
    public static final Class<? extends Extension> EXTENSION = AssuranceExtension.class;
    public static final String LOG_TAG = "Assurance";
    public static final String EXTENSION_VERSION = "3.0.7";
    public static final String EXTENSION_NAME = "com.adobe.assurance";
    public static final String EXTENSION_FRIENDLY_NAME = "Assurance";
    private static final String DEEPLINK_SESSION_ID_KEY = "adb_validation_sessionid";
    private static final String START_SESSION_URL = "startSessionURL";
    private static final String IS_QUICK_CONNECT = "quickConnect";

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void startSession(@NonNull String url) {
        if (url == null || !url.contains(DEEPLINK_SESSION_ID_KEY)) {
            Log.warning((String)"Assurance", (String)"Assurance", (String)String.format("Not a valid Assurance deeplink, Ignorning start session API call. URL : %s", url), (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> startSessionEventData = new HashMap<String, String>();
        startSessionEventData.put(START_SESSION_URL, url);
        Event startSessionEvent = new Event.Builder("Assurance Start Session", "com.adobe.eventType.assurance", "com.adobe.eventSource.requestContent").setEventData(startSessionEventData).build();
        MobileCore.dispatchEvent((Event)startSessionEvent);
    }

    public static void startSession() {
        Log.debug((String)"Assurance", (String)"Assurance", (String)"QuickConnect api triggered.", (Object[])new Object[0]);
        Event startSessionEvent = new Event.Builder("Assurance Start Session (Quick Connect)", "com.adobe.eventType.assurance", "com.adobe.eventSource.requestContent").setEventData(Collections.singletonMap(IS_QUICK_CONNECT, true)).build();
        MobileCore.dispatchEvent((Event)startSessionEvent);
    }
}

