/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.commons.auth.Authenticator;
import org.apache.sling.commons.auth.NoAuthenticationHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends SlingSafeMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String[] LOGIN_SERVLET_PATH = new String[]{"/bin/login", "/login"};
    private Authenticator authenticator;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String resourcePath;
        if (request.getAuthType() != null && this.isSelf(resourcePath = request.getParameter("resource"))) {
            String redirectTarget = request.getContextPath() + "/";
            this.log.warn("doGet: Redirecting to {} to prevent login loop for resource {}", (Object)redirectTarget, (Object)resourcePath);
            response.sendRedirect(redirectTarget);
            return;
        }
        Authenticator authenticator = this.authenticator;
        if (authenticator != null) {
            try {
                request.setAttribute("cq.authhandler.dologin", (Object)true);
                AbstractAuthenticationHandler.setLoginResourceAttribute((HttpServletRequest)request, (String)request.getContextPath());
                authenticator.login((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IllegalStateException ise) {
                this.log.error("doGet: Response already committed, cannot login");
                return;
            }
            catch (NoAuthenticationHandlerException nahe) {
                this.log.error("doGet: No AuthenticationHandler to login registered");
            }
        } else {
            this.log.error("doGet: Authenticator service missing, cannot request authentication");
        }
        response.sendError(403, "Cannot login");
    }

    private boolean isSelf(String resourcePath) {
        if (resourcePath == null) {
            return true;
        }
        for (String servletPath : LOGIN_SERVLET_PATH) {
            if (!resourcePath.startsWith(servletPath)) continue;
            return true;
        }
        return false;
    }
}

