/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceListener {
    private BundleContext ctx;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void start(BundleContext bc) throws Exception {
        ConfigurationAdmin ca;
        this.ctx = bc;
        boolean done = false;
        ServiceReference ref = bc.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref != null && (ca = (ConfigurationAdmin)bc.getService(ref)) != null) {
            this.log.info("ConfigurationAdmin available at startup, trying to rebind config");
            this.rebindConfig(ca);
            done = true;
        }
        if (!done) {
            this.log.info("ConfigurationAdmin not available at startup, will rebind when it is registered");
            bc.addServiceListener((ServiceListener)this);
        }
    }

    public void stop(BundleContext bc) throws Exception {
        bc.removeServiceListener((ServiceListener)this);
        this.ctx = null;
    }

    public void serviceChanged(ServiceEvent e) {
        ServiceReference ref;
        Object o;
        if (e.getType() == 1 && this.ctx != null && (o = this.ctx.getService(ref = e.getServiceReference())) instanceof ConfigurationAdmin) {
            this.log.info("ConfigurationAdmin registered, trying to rebind config");
            this.rebindConfig((ConfigurationAdmin)o);
            this.log.info("Deactivating ServiceListener");
            this.ctx.removeServiceListener((ServiceListener)this);
        }
    }

    protected void rebindConfig(ConfigurationAdmin ca) {
        try {
            String pid1 = "com.day.cq.wcm.foundation.impl.HTTPAuthHandler";
            String pid2 = "com.day.cq.wcm.foundation.impl.SsoAuthenticationHandler";
            String filter = "(|(service.pid=com.day.cq.wcm.foundation.impl.HTTPAuthHandler)(service.pid=com.day.cq.wcm.foundation.impl.SsoAuthenticationHandler))";
            Configuration[] cfgs = ca.listConfigurations("(|(service.pid=com.day.cq.wcm.foundation.impl.HTTPAuthHandler)(service.pid=com.day.cq.wcm.foundation.impl.SsoAuthenticationHandler))");
            if (cfgs != null) {
                for (Configuration cfg : cfgs) {
                    String myLocation = this.ctx.getBundle().getLocation();
                    if (cfg.getBundleLocation() == null) {
                        this.log.info("Config {} is not bound, no changes needed", (Object)cfg.getPid());
                        continue;
                    }
                    if (cfg.getBundleLocation().equals(myLocation)) {
                        this.log.info("Config {} already bound to this bundle, no changes needed", (Object)cfg.getPid());
                        continue;
                    }
                    cfg.setBundleLocation(null);
                    cfg.update();
                    this.log.info("Config {} unbound and updated", (Object)cfg.getPid());
                }
            } else {
                this.log.info("No configuration to rebind");
            }
        }
        catch (Exception e) {
            this.log.error("Exception in rebindConfig", (Throwable)e);
        }
    }
}

