/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractService
extends ManageableComponent
implements Service {
    public static final String LOG_CATEGORY = "Service.General";
    public static final String LOG_CATEGORY_STARTUP_DESTINATION = "Startup.Destination";
    protected static final int UNKNOWN_MESSAGE_TYPE = 10454;
    protected Map<String, String> adapterClasses = new HashMap<String, String>();
    protected String defaultAdapterId;
    protected List<String> defaultChannels;
    protected Map<String, Destination> destinations = new ConcurrentHashMap<String, Destination>();

    public AbstractService() {
        this(false);
    }

    public AbstractService(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        if (this.defaultChannels != null) {
            Iterator<String> iter = this.defaultChannels.iterator();
            while (iter.hasNext()) {
                String id = iter.next();
                if (this.getMessageBroker().getChannelIds().contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)this.getLogCategory()).warn("Removing the Channel " + id + " from Destination " + this.getId() + "as MessageBroker does not know the channel");
            }
        } else {
            this.defaultChannels = this.getMessageBroker().getDefaultChannels();
        }
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            this.startDestinations();
            return;
        }
        MessageBroker broker = this.getMessageBroker();
        if (!broker.isStarted()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Service with id '{0}' cannot be started when the MessageBroker is not started.", new Object[]{this.getId()});
            }
            return;
        }
        if (this.isManaged() && broker.isManaged()) {
            this.setupServiceControl(broker);
            MessageBrokerControl controller = (MessageBrokerControl)broker.getControl();
            if (this.getControl() != null) {
                controller.addService(this.getControl().getObjectName());
            }
        }
        super.start();
        this.startDestinations();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.stopDestinations();
        super.stop();
        if (this.isManaged() && this.getMessageBroker().isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    @Override
    public Map<String, String> getRegisteredAdapters() {
        return this.adapterClasses;
    }

    @Override
    public String registerAdapter(String id, String adapterClass) {
        return this.adapterClasses.put(id, adapterClass);
    }

    @Override
    public String unregisterAdapter(String id) {
        if (id != null && id.equals(this.defaultAdapterId)) {
            this.defaultAdapterId = null;
        }
        return this.adapterClasses.remove(id);
    }

    @Override
    public String getDefaultAdapter() {
        return this.defaultAdapterId;
    }

    @Override
    public void setDefaultAdapter(String id) {
        if (this.adapterClasses.get(id) == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11114, new Object[]{id, this.getId()});
            throw ex;
        }
        this.defaultAdapterId = id;
    }

    @Override
    public List<String> getDefaultChannels() {
        return this.defaultChannels;
    }

    @Override
    public void addDefaultChannel(String id) {
        List<String> channelIds;
        if (this.defaultChannels == null) {
            this.defaultChannels = new ArrayList<String>();
        } else if (this.defaultChannels.contains(id)) {
            return;
        }
        if (this.isStarted() && ((channelIds = this.getMessageBroker().getChannelIds()) == null || !channelIds.contains(id))) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
            return;
        }
        this.defaultChannels.add(id);
    }

    @Override
    public void setDefaultChannels(List<String> ids) {
        if (ids != null && this.isStarted()) {
            List<String> channelIds = this.getMessageBroker().getChannelIds();
            Iterator<String> iter = ids.iterator();
            while (iter.hasNext()) {
                String id = iter.next();
                if (channelIds != null && channelIds.contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
        }
        this.defaultChannels = ids;
    }

    @Override
    public boolean removeDefaultChannel(String id) {
        return this.defaultChannels != null && this.defaultChannels.remove(id);
    }

    @Override
    public Destination getDestination(Message message) {
        String id = message.getDestination();
        Destination result = this.getDestination(id);
        if (result == null) {
            throw new MessageException("No destination '" + id + "' exists in service " + this.getClass().getName());
        }
        return result;
    }

    @Override
    public Destination getDestination(String id) {
        return this.destinations.get(id);
    }

    @Override
    public Map<String, Destination> getDestinations() {
        return this.destinations;
    }

    @Override
    public Destination createDestination(String id) {
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Destination", "Service"});
            throw ex;
        }
        this.getMessageBroker().isDestinationRegistered(id, this.getId(), true);
        Destination destination = new Destination();
        destination.setId(id);
        destination.setManaged(this.isManaged());
        destination.setService(this);
        return destination;
    }

    @Override
    public void addDestination(Destination destination) {
        if (destination == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{"Destination", "Service"});
            throw ex;
        }
        String id = destination.getId();
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Destination", "Service"});
            throw ex;
        }
        if (this.getDestination(id) == destination) {
            return;
        }
        this.getMessageBroker().registerDestination(id, this.getId());
        this.destinations.put(id, destination);
        if (destination.getService() == null || destination.getService() != this) {
            destination.setService(this);
        }
    }

    @Override
    public Destination removeDestination(String id) {
        Destination destination = this.destinations.get(id);
        if (destination != null) {
            destination.stop();
            this.destinations.remove(id);
            this.getMessageBroker().unregisterDestination(id);
        }
        return destination;
    }

    @Override
    public void setId(String id) {
        String oldId = this.getId();
        super.setId(id);
        MessageBroker broker = this.getMessageBroker();
        if (broker != null) {
            broker.removeService(oldId);
            broker.addService(this);
        }
    }

    @Override
    public MessageBroker getMessageBroker() {
        return (MessageBroker)this.getParent();
    }

    @Override
    public void setMessageBroker(MessageBroker broker) {
        MessageBroker oldBroker = this.getMessageBroker();
        this.setParent(broker);
        if (oldBroker != null) {
            oldBroker.removeService(this.getId());
        }
        if (broker.getService(this.getId()) != this) {
            broker.addService(this);
        }
    }

    @Override
    public ConfigMap describeService(Endpoint endpoint) {
        return this.describeService(endpoint, true);
    }

    public ConfigMap describeService(Endpoint endpoint, boolean onlyReliable) {
        ConfigMap serviceConfig = null;
        for (Destination destination : this.destinations.values()) {
            ConfigMap destinationConfig;
            boolean endpointIdMatches = false;
            if (endpoint == null) {
                endpointIdMatches = true;
            } else {
                List<String> channels = destination.getChannels();
                if (channels != null) {
                    for (String channelId : channels) {
                        if (!channelId.equals(endpoint.getId())) continue;
                        endpointIdMatches = true;
                        break;
                    }
                }
            }
            if (!endpointIdMatches || (destinationConfig = destination.describeDestination(onlyReliable)) == null || destinationConfig.size() <= 0) continue;
            if (serviceConfig == null) {
                serviceConfig = new ConfigMap();
                serviceConfig.addProperty("id", this.getId());
            }
            serviceConfig.addProperty("destination", destinationConfig);
        }
        return serviceConfig;
    }

    @Override
    public abstract Object serviceMessage(Message var1);

    @Override
    public Object serviceCommand(CommandMessage message) {
        Object result = this.serviceCommonCommands(message);
        if (result != null) {
            return result;
        }
        throw new MessageException("Service Does Not Support Command Type " + message.getOperation());
    }

    protected Object serviceCommonCommands(CommandMessage message) {
        Object commandResult = null;
        if (message.getOperation() == 5) {
            commandResult = Boolean.TRUE;
        } else if (message.getOperation() == 7) {
            String destinationName;
            String serviceType;
            ClusterManager clusterManager = this.getMessageBroker().getClusterManager();
            commandResult = clusterManager.isDestinationClustered(serviceType = this.getClass().getName(), destinationName = message.getDestination()) ? clusterManager.getEndpointsForDestination(serviceType, destinationName) : Boolean.FALSE;
        }
        return commandResult;
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected abstract void setupServiceControl(MessageBroker var1);

    private void startDestinations() {
        for (Destination destination : this.destinations.values()) {
            long timeBeforeStartup = 0L;
            if (Log.isDebug()) {
                timeBeforeStartup = System.currentTimeMillis();
            }
            destination.start();
            if (!Log.isDebug()) continue;
            long timeAfterStartup = System.currentTimeMillis();
            Long diffMillis = timeAfterStartup - timeBeforeStartup;
            Log.getLogger((String)LOG_CATEGORY_STARTUP_DESTINATION).debug("Destination with id '{0}' is ready (startup time: '{1}' ms)", new Object[]{destination.getId(), diffMillis});
        }
    }

    private void stopDestinations() {
        for (Destination destination : this.destinations.values()) {
            destination.stop();
        }
    }
}

