/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.CachedFontFace;
import flash.fonts.DefineFont3Face;
import flash.fonts.FontDescription;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.fonts.FontSet;
import flash.swf.builder.tags.FontBuilder;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont3;
import flash.swf.types.GlyphEntry;
import flash.util.LRUCache;
import java.net.URL;
import java.util.Map;

public abstract class CachedFontManager
extends FontManager {
    public static final short PURGE_SIZE = 2;
    public static final float DEFAULT_FONT_SIZE = 240.0f;
    public static final Float DEFAULT_FONT_SIZE_OBJECT = new Float(240.0f);
    public static final String DEFAULT_FONT_SIZE_STRING = "240";
    public static final String COMPATIBILITY_VERSION = "CompatibilityVersion";
    public static final String MAX_CACHED_FONTS_KEY = "max-cached-fonts";
    public static final String MAX_GLYPHS_PER_FACE_KEY = "max-glyphs-per-face";
    public short maxEntries = (short)20;
    public short maxGlyphsPerFace = (short)1000;
    public short maxFacesPerFont = (short)4;
    private FontCache fontCache;
    private FontFileCache fontFileCache;

    protected CachedFontManager() {
    }

    public void initialize(Map map) {
        super.initialize(map);
        if (map != null) {
            String prop = (String)map.get(MAX_CACHED_FONTS_KEY);
            if (prop != null) {
                try {
                    this.maxEntries = Short.parseShort(prop);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if ((prop = (String)map.get(MAX_GLYPHS_PER_FACE_KEY)) != null) {
                try {
                    this.maxGlyphsPerFace = Short.parseShort(prop);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.fontCache = new FontCache(this);
        this.fontFileCache = new FontFileCache(this);
    }

    public DefineFont createDefineFont(int tagCode, FontDescription font) {
        FontFace fontFace;
        boolean useTwips;
        boolean bl = useTwips = tagCode == 75;
        if (font.source instanceof URL) {
            URL location = (URL)font.source;
            fontFace = this.getEntryFromLocation(location, font.style, useTwips);
            if (font.alias == null) {
                font.alias = fontFace.getFamily();
            }
            if (fontFace == null) {
                FontManager.throwFontNotFound(font.alias, null, font.style, location.toString());
            }
        } else {
            String fontFamily = font.source.toString();
            fontFace = this.getEntryFromSystem(fontFamily, font.style, useTwips);
            if (font.alias == null) {
                font.alias = fontFace.getFamily();
            }
            if (fontFace == null) {
                FontManager.throwFontNotFound(font.alias, fontFamily, font.style, null);
            }
        }
        FontBuilder builder = new FontBuilder(tagCode, fontFace, font.alias, font.advancedAntiAliasing);
        int[][] ranges = this.getUnicodeRanges(font.unicodeRanges);
        if (ranges != null) {
            for (int i = 0; i < ranges.length; ++i) {
                int[] range = ranges[i];
                if (range == null || range.length != 2) continue;
                int count = range[1] - range[0] + 1;
                builder.addCharset(range[0], count);
            }
        } else {
            builder.addAllChars();
        }
        return (DefineFont)builder.build();
    }

    public void loadDefineFont(DefineFont tag, Object location) {
        if (tag instanceof DefineFont3) {
            this.loadDefineFont3((DefineFont3)tag, location);
        }
    }

    protected void loadDefineFont3(DefineFont3 tag, Object location) {
        FontFace face;
        String family = null;
        String locationKey = null;
        if (location != null) {
            locationKey = location instanceof URL ? ((URL)location).toExternalForm() : location.toString();
            family = (String)this.getFontFileCache().get(locationKey);
        }
        if (family == null) {
            family = DefineFont3Face.getFamily(tag);
            if (locationKey != null) {
                this.getFontFileCache().put(locationKey, family);
            }
        }
        int style = DefineFont3Face.getStyle(tag);
        FontSet fontSet = (FontSet)this.getFontCache().get(family);
        if (fontSet == null) {
            fontSet = new FontSet(this.maxFacesPerFont);
            this.getFontCache().put(family, fontSet);
        }
        if ((face = fontSet.get(style)) == null) {
            face = new DefineFont3Face(tag);
            fontSet.put(style, face);
        } else if (face instanceof CachedFontFace) {
            CachedFontFace cachedFontFace = (CachedFontFace)face;
            char[] codepoints = tag.codeTable;
            if (codepoints != null) {
                for (char i = '\u0000'; i < codepoints.length; i = (char)(i + 1)) {
                    char c = codepoints[i];
                    GlyphEntry ge = cachedFontFace.getGlyphEntry(c);
                    if (ge != null) continue;
                    ge = DefineFont3Face.createGlyphEntryFromDefineFont(c, i, tag);
                    cachedFontFace.glyphCache.put(c, ge);
                }
            }
        }
    }

    protected FontCache getFontCache() {
        if (this.fontCache == null) {
            this.initialize(null);
        }
        return this.fontCache;
    }

    protected FontFileCache getFontFileCache() {
        if (this.fontFileCache == null) {
            this.initialize(null);
        }
        return this.fontFileCache;
    }

    protected abstract String createFontFromLocation(Object var1, int var2, boolean var3);

    protected abstract FontSet createSetForSystemFont(String var1, int var2, boolean var3);

    static class FontFileCache
    extends LRUCache {
        private static final long serialVersionUID = 5379979428987581921L;

        FontFileCache(CachedFontManager manager) {
            super(manager.maxEntries / 2, manager.maxEntries, 2);
        }

        protected Object fetch(Object key) {
            return null;
        }
    }

    static class FontCache
    extends LRUCache {
        private static final long serialVersionUID = -2402480346505475961L;

        FontCache(CachedFontManager manager) {
            super(manager.maxEntries / 2, manager.maxEntries, 2);
        }

        protected Object fetch(Object key) {
            return null;
        }
    }
}

