/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.SwfFormatException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public final class SwfDecoder
extends BufferedInputStream {
    private int offset;
    private int bitBuf;
    private int bitPos;
    int swfVersion;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream(256){

        public byte[] toByteArray() {
            return this.buf;
        }
    };
    private int markOffset;

    public SwfDecoder(byte[] b, int swfVersion) {
        this((InputStream)null, swfVersion);
        this.buf = b;
        this.count = b.length;
        this.pos = 0;
    }

    public SwfDecoder(InputStream in, int swfVersion) {
        super(in);
        this.swfVersion = swfVersion;
    }

    public SwfDecoder(InputStream in, int swfVersion, int offset) {
        this(in, swfVersion);
        this.offset = offset;
    }

    public void readFully(byte[] b) throws IOException {
        int count;
        int off = 0;
        for (int remain = b.length; remain > 0; remain -= count) {
            count = this.read(b, off, remain);
            if (count > 0) {
                off += count;
                continue;
            }
            throw new SwfFormatException("couldn't read " + remain);
        }
    }

    public int read() throws IOException {
        ++this.offset;
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        this.offset += n;
        return n;
    }

    public synchronized long skip(long len) throws IOException {
        long n = super.skip(len);
        this.offset = (int)((long)this.offset + n);
        return n;
    }

    public float readFixed8() throws IOException {
        int val = this.readUI16();
        return (float)((double)val / 256.0);
    }

    public int readUI8() throws IOException {
        if (this.pos < this.count) {
            ++this.offset;
            return this.buf[this.pos++] & 0xFF;
        }
        if (this.in != null) {
            ++this.offset;
            return super.read();
        }
        return -1;
    }

    public int readUI16() throws IOException {
        int i;
        this.syncBits();
        if (this.count - this.pos >= 2) {
            i = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
            this.pos += 2;
            this.offset += 2;
        } else if (this.in != null) {
            i = super.read() | super.read() << 8;
            this.offset += 2;
        } else {
            return -1;
        }
        return i;
    }

    public long readUI32() throws IOException {
        long i = (long)this.readSI32() & 0xFFFFFFFFL;
        return i;
    }

    public int readSI32() throws IOException {
        int i;
        this.syncBits();
        if (this.count - this.pos >= 4) {
            i = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8 | (this.buf[this.pos + 2] & 0xFF) << 16 | this.buf[this.pos + 3] << 24;
            this.offset += 4;
            this.pos += 4;
        } else if (this.in != null) {
            i = super.read() | super.read() << 8 | super.read() << 16 | super.read() << 24;
            this.offset += 4;
        } else {
            i = -1;
        }
        return i;
    }

    public long read64() throws IOException {
        return this.readUI32() & 0xFFFFFFFFL | this.readUI32() << 32;
    }

    public boolean readBit() throws IOException {
        return this.readUBits(1) != 0;
    }

    public int readUBits(int numBits) throws IOException {
        int shift;
        if (numBits == 0) {
            return 0;
        }
        int bitsLeft = numBits;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.readUI8();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = this.readUI8();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public int readSBits(int numBits) throws IOException {
        if (numBits > 32) {
            throw new SwfFormatException("Number of bits > 32");
        }
        int num = this.readUBits(numBits);
        int shift = 32 - numBits;
        num = num << shift >> shift;
        return num;
    }

    public int readSI16() throws IOException {
        return (short)this.readUI16();
    }

    public float readFloat() throws IOException {
        int bits = this.readSI32();
        return Float.intBitsToFloat(bits);
    }

    public String readLengthString() throws IOException {
        int length = this.readUI8();
        byte[] b = new byte[length];
        this.readFully(b);
        if (this.swfVersion >= 6) {
            return new String(b, 0, length - 1, "UTF8").intern();
        }
        return new String(b, 0, length - 1).intern();
    }

    public String readString() throws IOException {
        int ch;
        if (this.swfVersion >= 6) {
            return this.readUTF().intern();
        }
        while ((ch = this.readUI8()) > 0) {
            this.out.write(ch);
        }
        String s = new String(this.out.toByteArray(), 0, this.out.size());
        this.out.reset();
        return s.intern();
    }

    private String readUTF() throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        block5: while ((c = this.readUI8()) > 0) {
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    b.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int c2 = this.readUI8();
                    if (c2 <= 0 || (c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    b.append((char)((c & 0x1F) << 6 | c2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    int c2 = this.readUI8();
                    int c3 = this.readUI8();
                    if (c2 <= 0 || c3 <= 0 || (c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    b.append((char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return b.toString();
    }

    public void syncBits() {
        this.bitPos = 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void mark(int readlimit) {
        this.markOffset = this.offset;
        super.mark(readlimit);
    }

    public void reset() throws IOException {
        this.offset = this.markOffset;
        super.reset();
    }
}

