/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class FileUtils {
    private static HashMap filemap = null;
    private static boolean checkCase = false;

    public static final String canonicalPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        return FileUtils.canonicalPath(new File(rootPath));
    }

    public static String canonicalPath(File file) {
        return FileUtils.canonicalFile(file).getPath();
    }

    public static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static synchronized String getTheRealPathBecauseCanonicalizeDoesNotFixCase(File f) {
        if (filemap == null) {
            filemap = new HashMap();
            checkCase = System.getProperty("os.name").toLowerCase().startsWith("windows");
        }
        String path = FileUtils.canonicalPath(f);
        if (!checkCase || !f.exists()) {
            return path;
        }
        if (filemap.containsKey(path)) {
            return (String)filemap.get(path);
        }
        String file = f.getName();
        File canonfile = new File(path);
        File dir = new File(canonfile.getParent());
        String[] ss = dir.list();
        if (ss != null) {
            int i;
            int n = ss.length;
            File[] files = new File[n];
            for (i = 0; i < n; ++i) {
                files[i] = new File(canonfile.getPath(), ss[i]);
            }
            for (i = 0; i < files.length; ++i) {
                if (!files[i].getName().equalsIgnoreCase(file)) continue;
                filemap.put(path, files[i].getAbsolutePath());
                return files[i].getAbsolutePath();
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String default_encoding) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            StringBuffer returnVal = new StringBuffer((int)file.length());
            BufferedInputStream in = new BufferedInputStream(fileInputStream);
            in.mark(3);
            InputStreamReader reader = new InputStreamReader((InputStream)in, FileUtils.consumeBOM(in, default_encoding));
            char[] line = new char[2000];
            int count = 0;
            while ((count = ((Reader)reader).read(line, 0, line.length)) >= 0) {
                returnVal.append(line, 0, count);
            }
            String string = returnVal.toString();
            return string;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static String readFile(String filename, String default_encoding) throws IOException {
        return FileUtils.readFile(new File(filename), default_encoding);
    }

    public static final String consumeBOM(InputStream in, String default_encoding) throws IOException {
        in.mark(3);
        if (in.read() == 239 && in.read() == 187 && in.read() == 191) {
            if (System.getProperty("flex.platform.CLR") != null) {
                return "UTF8";
            }
            return "UTF-8";
        }
        in.reset();
        int b0 = in.read();
        int b1 = in.read();
        if (b0 == 255 && b1 == 254 || b0 == 254 && b1 == 255) {
            in.reset();
            if (System.getProperty("flex.platform.CLR") != null) {
                return "UTF16";
            }
            return "UTF-16";
        }
        in.reset();
        if (default_encoding != null && default_encoding.length() != 0) {
            return default_encoding;
        }
        return System.getProperty("file.encoding");
    }

    public static File getAbsoluteFile(File f) {
        File absolute;
        block2: {
            absolute = null;
            try {
                absolute = f == null ? null : f.getAbsoluteFile();
            }
            catch (SecurityException se) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(se.getMessage());
            }
        }
        return absolute;
    }

    public static File getCanonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public static File getParentFile(File f) {
        String p = f.getParent();
        if (p == null) {
            return null;
        }
        return new File(p);
    }

    public static File[] listFiles(File dir) {
        String[] fileNames = dir.list();
        if (fileNames == null) {
            return null;
        }
        File[] fileList = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            fileList[i] = new File(dir.getPath(), fileNames[i]);
        }
        return fileList;
    }

    public static File[] listFiles(File dir, FilenameFilter filter) {
        String[] fileNames = dir.list();
        if (fileNames == null) {
            return null;
        }
        ArrayList<File> filteredFiles = new ArrayList<File>();
        for (int i = 0; i < fileNames.length; ++i) {
            if (filter != null && !filter.accept(dir, fileNames[i])) continue;
            filteredFiles.add(new File(dir.getPath(), fileNames[i]));
        }
        return filteredFiles.toArray(new File[0]);
    }

    public static URL toURL(File f) throws MalformedURLException {
        String s = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            s = s.replace(File.separatorChar, '/');
        }
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        if (!s.endsWith("/") && f.isDirectory()) {
            s = s + "/";
        }
        return new URL("file", "", s);
    }

    public static String addPathComponents(String p1, String p2, char sepchar) {
        int r2;
        int r1;
        if (p1 == null) {
            p1 = "";
        }
        if (p2 == null) {
            p2 = "";
        }
        for (r1 = p1.length() - 1; r1 >= 0 && p1.charAt(r1) == sepchar; --r1) {
        }
        for (r2 = 0; r2 < p2.length() && p2.charAt(r2) == sepchar; ++r2) {
        }
        String left = p1.substring(0, r1 + 1);
        String right = p2.substring(r2);
        String sep = "";
        if (left.length() > 0 && right.length() > 0) {
            sep = sep + sepchar;
        }
        return left + sep + right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean renameFile(File from, File to) {
        if (!from.exists()) {
            return false;
        }
        long length = from.length();
        try {
            if (to.exists() && !to.delete()) {
                File old = new File(to.getAbsolutePath() + ".old");
                if (old.exists()) {
                    old.delete();
                }
                if (to.renameTo(old) && old.delete()) {
                    // empty if block
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (from.renameTo(to)) {
                return true;
            }
            FileInputStream in = new FileInputStream(from);
            FileOutputStream out = new FileOutputStream(to);
            byte[] buf = new byte[8192];
            try {
                int r;
                for (long remain = from.length(); remain > 0L; remain -= (long)r) {
                    r = ((InputStream)in).read(buf);
                    if (r < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    ((OutputStream)out).write(buf, 0, r);
                    out.flush();
                }
            }
            finally {
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            long tolength = to.length();
            if (tolength != length) return false;
            from.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int num = 0;
        BufferedInputStream inputStream = new BufferedInputStream(in);
        try {
            while ((num = ((InputStream)inputStream).read(buffer)) != -1) {
                baos.write(buffer, 0, num);
            }
        }
        catch (IOException ex) {
            if (Trace.error) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in, int length) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(in);
        byte[] buffer = new byte[length];
        try {
            int bytesRead = 0;
            for (int index = 0; bytesRead >= 0 && index < buffer.length; index += bytesRead) {
                bytesRead = inputStream.read(buffer, index, buffer.length - index);
            }
        }
        finally {
            inputStream.close();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeClassToFile(String baseDir, String packageName, String className, String str) throws IOException {
        String reldir = packageName.replace('.', File.separatorChar);
        String dir = FileUtils.addPathComponents(baseDir, reldir, File.separatorChar);
        new File(dir).mkdirs();
        String generatedName = FileUtils.addPathComponents(dir, className, File.separatorChar);
        BufferedWriter fileWriter = null;
        try {
            fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(generatedName), "UTF-8"));
            fileWriter.write(str);
            fileWriter.flush();
            Object var9_8 = null;
            if (fileWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileWriter.close();
            return;
        }
        catch (IOException ex) {}
    }

    public static boolean isAbsolute(File f) {
        boolean absolute;
        block2: {
            absolute = false;
            try {
                absolute = f.isAbsolute();
            }
            catch (SecurityException se) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(se.getMessage());
            }
        }
        return absolute;
    }

    public static boolean exists(File f) {
        boolean exists;
        block2: {
            exists = false;
            try {
                exists = f.exists();
            }
            catch (SecurityException se) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(se.getMessage());
            }
        }
        return exists;
    }

    public static boolean isFile(File f) {
        boolean isFile;
        block2: {
            isFile = false;
            try {
                isFile = f.isFile();
            }
            catch (SecurityException se) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(se.getMessage());
            }
        }
        return isFile;
    }

    public static boolean isDirectory(File f) {
        boolean isDirectory;
        block2: {
            isDirectory = false;
            try {
                isDirectory = f.isDirectory();
            }
            catch (SecurityException se) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(se.getMessage());
            }
        }
        return isDirectory;
    }
}

