/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.builder.tags;

import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.fonts.flashtype.ADFAlgnZones;
import flash.fonts.flashtype.ADFTypeSystem;
import flash.fonts.flashtype.FlexADFData;
import flash.swf.builder.tags.TagBuilder;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFontAlignZones;
import flash.swf.tags.DefineFontName;
import flash.swf.tags.DefineTag;
import flash.swf.tags.ZoneRecord;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.GlyphEntry;
import flash.swf.types.KerningRecord;
import flash.swf.types.Rect;
import flash.swf.types.Shape;
import flash.swf.types.ShapeRecord;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.util.IntMap;
import flash.util.Trace;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class FontBuilder
implements TagBuilder {
    private boolean flashType;
    private IntMap adfGlyphs;
    private static boolean outputForFlashTypeTestC;
    private static boolean outputForFlashTypeTestJava;
    private static boolean useLicenseTag;
    public DefineFont tag;
    private IntMap glyphEntryMap;
    private FontFace defaultFace;
    private double fontHeight;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FontBuilder(int code, boolean hasLayout, boolean useFlashType) {
        this.tag = new DefineFont(code);
        this.tag.hasLayout = hasLayout;
        this.glyphEntryMap = new IntMap(100);
        this.flashType = useFlashType;
    }

    public FontBuilder(int code, FontManager manager, String alias, String fontFamily, int style, boolean hasLayout, boolean flashType) {
        this(code, hasLayout, flashType);
        boolean useTwips;
        FontFace fontFace;
        if (manager == null) {
            throw new NoFontManagerException();
        }
        if (Trace.font) {
            Trace.trace("Locating font using FontManager '" + manager.getClass().getName() + "'");
        }
        if ((fontFace = manager.getEntryFromSystem(fontFamily, style, useTwips = code != 10 && code != 48)) == null) {
            StringBuffer message = new StringBuffer("Font for alias '");
            message.append(alias).append("' ");
            if (style == 1) {
                message.append("with bold weight ");
            } else if (style == 2) {
                message.append("with italic style ");
            } else if (style == 3) {
                message.append("with bold weight and italic style ");
            } else {
                message.append("with plain weight and style ");
            }
            message.append("was not found by family name '").append(fontFamily).append("'");
            throw new FontNotFoundException(message.toString());
        }
        if (Trace.font) {
            Trace.trace("Initializing font '" + fontFamily + "' as '" + alias + "'");
        }
        this.defaultFace = fontFace;
        this.init(alias);
    }

    public FontBuilder(int code, FontManager manager, String alias, URL location, int style, boolean hasLayout, boolean flashType) {
        this(code, hasLayout, flashType);
        boolean useTwips;
        FontFace fontFace;
        if (manager == null) {
            throw new NoFontManagerException();
        }
        if (Trace.font) {
            Trace.trace("Locating font using FontManager '" + manager.getClass().getName() + "'");
        }
        if ((fontFace = manager.getEntryFromLocation(location, style, useTwips = code != 10 && code != 48)) == null) {
            StringBuffer message = new StringBuffer("Font for alias '");
            message.append(alias).append("' ");
            if (style == 1) {
                message.append("with bold weight ");
            } else if (style == 2) {
                message.append("with italic style ");
            } else if (style == 3) {
                message.append("with bold weight and italic style ");
            } else {
                message.append("with plain weight and style ");
            }
            message.append("was not found at: ").append(location.toString());
            throw new FontNotFoundException(message.toString());
        }
        if (Trace.font) {
            Trace.trace("Initializing font at '" + location.toString() + "' as '" + alias + "'");
        }
        this.defaultFace = fontFace;
        this.init(alias);
    }

    private void init(String alias) {
        this.fontHeight = this.defaultFace.getPointSize();
        if (this.tag.code != 10) {
            this.tag.fontName = alias;
            this.tag.bold = this.defaultFace.isBold();
            this.tag.italic = this.defaultFace.isItalic();
            if (this.tag.hasLayout) {
                this.tag.ascent = this.defaultFace.getAscent();
                this.tag.descent = this.defaultFace.getDescent();
                this.tag.leading = this.defaultFace.getLineGap();
                if (Trace.font) {
                    Trace.trace("\tBold: " + this.tag.bold);
                    Trace.trace("\tItalic: " + this.tag.italic);
                    Trace.trace("\tAscent: " + this.tag.ascent);
                    Trace.trace("\tDescent: " + this.tag.descent);
                    Trace.trace("\tLeading: " + this.tag.leading);
                }
            }
        }
        this.addDefaultChars();
    }

    private void addDefaultChars() {
        this.addChar(' ');
    }

    public DefineTag build() {
        int count = this.glyphEntryMap.size();
        if (Trace.font) {
            Trace.trace("Building font '" + this.tag.fontName + "' with " + count + " characters.");
        }
        ADFAlgnZones.AlgnZoneState mpZoneInst = null;
        if (this.flashType) {
            long time0 = 0L;
            if (Trace.font) {
                time0 = System.currentTimeMillis();
            }
            Method method = null;
            Method[] methodArr = this.getClass().getMethods();
            for (int i = 0; i < methodArr.length; ++i) {
                if (!methodArr[i].getName().equals("getFontOutline")) continue;
                method = methodArr[i];
                break;
            }
            try {
                mpZoneInst = (ADFAlgnZones.AlgnZoneState)ADFAlgnZones.ADFInitAlgnZoneDetection(null, new FlexADFData(), null, method, this);
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                throw new RuntimeException("Could not initialize FlashType for font " + this.tag.fontName);
            }
            this.tag.zones = new DefineFontAlignZones();
            this.tag.zones.font = this.tag;
            this.tag.zones.zoneTable = new ZoneRecord[count];
            this.tag.zones.csmTableHint = 1;
            if (Trace.font) {
                Trace.trace("FlashType initialization: " + (System.currentTimeMillis() - time0) + "ms");
            }
        }
        this.tag.glyphShapeTable = new Shape[count];
        if (this.tag.code != 10) {
            this.tag.codeTable = new char[count];
            if (this.tag.hasLayout) {
                this.tag.advanceTable = new short[count];
                this.tag.boundsTable = new Rect[count];
            }
        }
        Iterator it = this.glyphEntryMap.iterator();
        long flashTypeTime = 0L;
        for (int i = 0; it.hasNext() && i < count; ++i) {
            GlyphEntry ge = (GlyphEntry)((Map.Entry)it.next()).getValue();
            if (this.flashType) {
                long time0 = 0L;
                if (Trace.font) {
                    time0 = System.currentTimeMillis();
                }
                this.tag.zones.zoneTable[i] = new ZoneRecord();
                if (ge.character == ' ') {
                    this.tag.zones.zoneTable[i].numZoneData = 2;
                    this.tag.zones.zoneTable[i].zoneData = new long[]{0L, 0L};
                    this.tag.zones.zoneTable[i].zoneMask = 0;
                } else {
                    FlexADFData data = new FlexADFData();
                    ADFTypeSystem.ADFPath pOnePath = this.getFontOutline(null, data, ge.character);
                    try {
                        ADFAlgnZones.ADFDetectAlgnZones(null, mpZoneInst, pOnePath);
                    }
                    catch (Exception e) {
                        if (Trace.error) {
                            e.printStackTrace();
                        }
                        throw new RuntimeException("Could not create ZoneTable for character " + ge.character + " in font " + this.tag.fontName);
                    }
                    if (pOnePath.algnZones == null) {
                        this.tag.zones.zoneTable[i].numZoneData = 2;
                        this.tag.zones.zoneTable[i].zoneData = new long[]{0L, 0L};
                        this.tag.zones.zoneTable[i].zoneMask = 0;
                    } else {
                        this.tag.zones.zoneTable[i].numZoneData = pOnePath.algnZones.length;
                        this.tag.zones.zoneTable[i].zoneData = pOnePath.algnZones;
                        this.tag.zones.zoneTable[i].zoneMask = pOnePath.algnZonesMask;
                    }
                }
                if (Trace.font) {
                    flashTypeTime += System.currentTimeMillis() - time0;
                }
            }
            this.tag.glyphShapeTable[i] = ge.getShape();
            ge.setIndex(i);
            if (this.tag.code == 10) continue;
            this.tag.codeTable[i] = ge.character;
            if (this.tag.hasLayout) {
                this.tag.advanceTable[i] = (short)ge.advance;
                this.tag.boundsTable[i] = new Rect();
                continue;
            }
            if (!Trace.font) continue;
            Trace.trace("Warning: font tag created without layout information.");
        }
        if (this.flashType && Trace.font) {
            Trace.trace("FlashType generation time: " + flashTypeTime + "ms");
        }
        if (this.tag.hasLayout) {
            this.tag.kerningTable = new KerningRecord[0];
        }
        if (useLicenseTag && (this.getFSType() != null && !this.getFSType().installable || this.getCopyright() != null || this.getName() != null)) {
            this.tag.license = new DefineFontName();
            this.tag.license.font = this.tag;
            this.tag.license.fontName = this.getName();
            this.tag.license.copyright = this.getCopyright();
        }
        return this.tag;
    }

    public void addAllChars() {
        this.addAllChars(this.defaultFace);
    }

    public void addAllChars(FontFace face) {
        int min = face.getFirstChar();
        int count = face.getNumGlyphs();
        if (Trace.font) {
            Trace.trace("\tAdding " + count + " chars, starting from " + min);
        }
        this.addCharset(min, count);
    }

    public void addCharset(int fromChar, int count) {
        this.addCharset(this.defaultFace, fromChar, count);
    }

    public void addCharset(FontFace face, int fromChar, int count) {
        int remaining = count;
        for (int i = fromChar; remaining > 0 && i < 65535; ++i) {
            char c = (char)i;
            GlyphEntry ge = this.addChar(face, c);
            if (ge == null) continue;
            if (outputForFlashTypeTestC) {
                this.outputForFlashTypeTestC(i, ge);
            }
            if (outputForFlashTypeTestJava) {
                this.outputForFlashTypeTestJava(i, ge);
            }
            --remaining;
        }
    }

    public void addCharset(char[] chars) {
        this.addCharset(this.defaultFace, chars);
    }

    public void addCharset(FontFace face, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.addChar(face, c);
        }
    }

    public void addChar(char c) {
        this.addChar(this.defaultFace, c);
    }

    public GlyphEntry addChar(FontFace face, char c) {
        GlyphEntry ge = null;
        if (this.glyphEntryMap.get(c) == null && (ge = face.getGlyphEntry(c)) != null) {
            this.glyphEntryMap.put(c, ge);
        }
        if (this.flashType && this.adfGlyphs == null) {
            this.adfGlyphs = new IntMap(4);
            this.addADFGlyph(face, 'z');
            this.addADFGlyph(face, 'Z');
            this.addADFGlyph(face, 'l');
            this.addADFGlyph(face, 'L');
        }
        return ge;
    }

    private void addADFGlyph(FontFace face, char c) {
        GlyphEntry adfGE = face.getGlyphEntry(c);
        if (adfGE == null) {
            this.flashType = false;
        } else {
            this.adfGlyphs.put(c, adfGE);
        }
    }

    public String getCopyright() {
        return this.defaultFace.getCopyright();
    }

    public String getName() {
        return this.defaultFace.getFamily();
    }

    public FSType getFSType() {
        return this.defaultFace.getFSType();
    }

    public void setLangcode(int code) {
        if (code >= 0 && code < 6) {
            this.tag.langCode = code;
        }
    }

    public GlyphEntry getGlyph(char c) {
        return (GlyphEntry)this.glyphEntryMap.get(c);
    }

    public double getFontHeight() {
        return this.fontHeight;
    }

    public int size() {
        return this.glyphEntryMap.size();
    }

    public ADFTypeSystem.ADFPath getFontOutline(Object libInst, Object fontID, char charCode) {
        FlexADFData data = (FlexADFData)fontID;
        GlyphEntry ge = (GlyphEntry)this.glyphEntryMap.get(charCode);
        if (ge == null) {
            ge = (GlyphEntry)this.adfGlyphs.get(charCode);
        }
        if (!$assertionsDisabled && ge == null) {
            throw new AssertionError((Object)("Glyph entry " + charCode + " not found as expected in map."));
        }
        data.mPath.fontUnitsPerEM = 20480.0f;
        data.mPath.charCode = charCode;
        float xMin = 10000.0f;
        float yMin = 10000.0f;
        float xMax = -10000.0f;
        float yMax = -10000.0f;
        int numCountours = 0;
        int numPenCmds = 0;
        int x = 0;
        int y = 0;
        boolean previousMove = false;
        int prevX = 0;
        int prevY = 0;
        data.mPath.penCmds = new ArrayList(ge.getShape().shapeRecords.size() * 2);
        Iterator iterator = ge.getShape().shapeRecords.iterator();
        while (iterator.hasNext()) {
            ShapeRecord r = (ShapeRecord)iterator.next();
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                ADFTypeSystem.ADFPenCmd penCmd;
                StyleChangeRecord scr = (StyleChangeRecord)r;
                if (previousMove && x != prevX && y != prevY) {
                    penCmd = new ADFTypeSystem.ADFPenCmd();
                    penCmd.opCode = 1L;
                    penCmd.x = prevX;
                    penCmd.y = prevY * -1;
                    data.mPath.penCmds.add(penCmd);
                    ++numPenCmds;
                }
                x = scr.moveDeltaX;
                y = scr.moveDeltaY;
                previousMove = true;
                prevX = x;
                prevY = y;
                penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 0L;
                penCmd.x = x;
                penCmd.y = y * -1;
                data.mPath.penCmds.add(penCmd);
                ++numCountours;
                ++numPenCmds;
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 1L;
                penCmd.x = x += ser.deltaX;
                penCmd.y = (y += ser.deltaY) * -1;
                data.mPath.penCmds.add(penCmd);
                ++numPenCmds;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                int cx = x + cer.controlDeltaX;
                int cy = y + cer.controlDeltaY;
                x = cx + cer.anchorDeltaX;
                y = cy + cer.anchorDeltaY;
                ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 2L;
                penCmd.x = x;
                penCmd.y = y * -1;
                penCmd.cx = cx;
                penCmd.cy = cy * -1;
                data.mPath.penCmds.add(penCmd);
                ++numPenCmds;
                if ((float)cx < xMin) {
                    xMin = cx;
                }
                if ((float)cx > xMax) {
                    xMax = cx;
                }
                if ((float)cy < yMin) {
                    yMin = cy;
                }
                if ((float)cy > yMax) {
                    yMax = cy;
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unknown ShapeRecord: " + r.getClass()));
            }
            if ((float)x < xMin) {
                xMin = x;
            }
            if ((float)x > xMax) {
                xMax = x;
            }
            if ((float)y < yMin) {
                yMin = y;
            }
            if (!((float)y > yMax)) continue;
            yMax = y;
        }
        if (previousMove && x != prevX && y != prevY) {
            ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
            penCmd.opCode = 1L;
            penCmd.x = prevX;
            penCmd.y = prevY * -1;
            data.mPath.penCmds.add(penCmd);
            ++numPenCmds;
        }
        data.mPath.glyphMinX = xMin;
        data.mPath.glyphMinY = yMax * -1.0f;
        data.mPath.glyphMaxX = xMax;
        data.mPath.glyphMaxY = yMin * -1.0f;
        data.mPath.numContours = numCountours;
        data.mPath.numPenCmds = numPenCmds;
        return data.mPath;
    }

    private void outputForFlashTypeTestC(int i, GlyphEntry ge) {
        char c = (char)i;
        System.out.println("//*********ADD CHAR: " + c + " : " + i);
        System.out.println("if (charCode == " + i + ") {");
        System.out.println("data->mPath.fontUnitsPerEM = 20480;");
        System.out.println("data->mPath.charCode = " + i + ";");
        float xMin = 10000.0f;
        float yMin = 10000.0f;
        float xMax = -10000.0f;
        float yMax = -10000.0f;
        int numCountours = 0;
        int numPenCmds = 0;
        int x = 0;
        int y = 0;
        boolean previousMove = false;
        int prevX = 0;
        int prevY = 0;
        Iterator iterator = ge.getShape().shapeRecords.iterator();
        while (iterator.hasNext()) {
            ShapeRecord r = (ShapeRecord)iterator.next();
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)r;
                if (previousMove && x != prevX && y != prevY) {
                    System.out.println("ADFPenCmd penCmd" + numPenCmds + ";");
                    System.out.println("penCmd" + numPenCmds + ".opCode = ADF_PEN_LINETO_CMD;");
                    System.out.println("penCmd" + numPenCmds + ".x = " + prevX + ";");
                    System.out.println("penCmd" + numPenCmds + ".y = " + prevY * -1 + ";");
                    ++numPenCmds;
                }
                x = scr.moveDeltaX;
                y = scr.moveDeltaY;
                previousMove = true;
                prevX = x;
                prevY = y;
                System.out.println("ADFPenCmd penCmd" + numPenCmds + ";");
                System.out.println("penCmd" + numPenCmds + ".opCode = ADF_PEN_MOVETO_CMD;");
                System.out.println("penCmd" + numPenCmds + ".x = " + x + ";");
                System.out.println("penCmd" + numPenCmds + ".y = " + y * -1 + ";");
                ++numCountours;
                ++numPenCmds;
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                System.out.println("ADFPenCmd penCmd" + numPenCmds + ";");
                System.out.println("penCmd" + numPenCmds + ".opCode = ADF_PEN_LINETO_CMD;");
                System.out.println("penCmd" + numPenCmds + ".x = " + (x += ser.deltaX) + ";");
                System.out.println("penCmd" + numPenCmds + ".y = " + (y += ser.deltaY) * -1 + ";");
                ++numPenCmds;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                int cx = x + cer.controlDeltaX;
                int cy = y + cer.controlDeltaY;
                x = cx + cer.anchorDeltaX;
                y = cy + cer.anchorDeltaY;
                System.out.println("ADFPenCmd penCmd" + numPenCmds + ";");
                System.out.println("penCmd" + numPenCmds + ".opCode = ADF_PEN_CURVTO_CMD;");
                System.out.println("penCmd" + numPenCmds + ".x = " + x + ";");
                System.out.println("penCmd" + numPenCmds + ".y = " + y * -1 + ";");
                System.out.println("penCmd" + numPenCmds + ".cx = " + cx + ";");
                System.out.println("penCmd" + numPenCmds + ".cy = " + cy * -1 + ";");
                if ((float)cx < xMin) {
                    xMin = cx;
                }
                if ((float)cx > xMax) {
                    xMax = cx;
                }
                if ((float)cy < yMin) {
                    yMin = cy;
                }
                if ((float)cy > yMax) {
                    yMax = cy;
                }
                ++numPenCmds;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unknown ShapeRecord: " + r.getClass()));
            }
            if ((float)x < xMin) {
                xMin = x;
            }
            if ((float)x > xMax) {
                xMax = x;
            }
            if ((float)y < yMin) {
                yMin = y;
            }
            if (!((float)y > yMax)) continue;
            yMax = y;
        }
        if (previousMove && x != prevX && y != prevY) {
            System.out.println("ADFPenCmd penCmd" + numPenCmds + ";");
            System.out.println("penCmd" + numPenCmds + ".opCode = ADF_PEN_LINETO_CMD;");
            System.out.println("penCmd" + numPenCmds + ".x = " + prevX + ";");
            System.out.println("penCmd" + numPenCmds + ".y = " + prevY * -1 + ";");
            ++numPenCmds;
        }
        System.out.println("data->mPath.penCmds = (ADFPenCmd *)malloc(" + numPenCmds + " * sizeof(ADFPenCmd));");
        for (int j = 0; j < numPenCmds; ++j) {
            System.out.println("*(data->mPath.penCmds + " + j + ") = penCmd" + j + ";");
        }
        System.out.println("data->mPath.glyphMinX = " + xMin + ";");
        System.out.println("data->mPath.glyphMinY = " + yMax * -1.0f + ";");
        System.out.println("data->mPath.glyphMaxX = " + xMax + ";");
        System.out.println("data->mPath.glyphMaxY = " + yMin * -1.0f + ";");
        System.out.println("data->mPath.numContours = " + numCountours + ";");
        System.out.println("data->mPath.numPenCmds = " + numPenCmds + ";");
        System.out.println("}");
    }

    private void outputForFlashTypeTestJava(int i, GlyphEntry ge) {
        char c = (char)i;
        System.out.println("//*********ADD CHAR: " + c + " : " + i);
        System.out.println("if (charCode == " + i + ") {");
        System.out.println("data.mPath.fontUnitsPerEM = 20480;");
        System.out.println("data.mPath.charCode = " + i + ";");
        float xMin = 10000.0f;
        float yMin = 10000.0f;
        float xMax = -10000.0f;
        float yMax = -10000.0f;
        int numCountours = 0;
        int numPenCmds = 0;
        int x = 0;
        int y = 0;
        boolean previousMove = false;
        int prevX = 0;
        int prevY = 0;
        Iterator iterator = ge.getShape().shapeRecords.iterator();
        while (iterator.hasNext()) {
            ShapeRecord r = (ShapeRecord)iterator.next();
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)r;
                if (previousMove && x != prevX && y != prevY) {
                    System.out.println("ADFTypeSystem.ADFPenCmd penCmd" + numPenCmds + " = new ADFTypeSystem.ADFPenCmd();");
                    System.out.println("penCmd" + numPenCmds + ".opCode = ADFTypeSystem.ADF_PEN_LINETO_CMD;");
                    System.out.println("penCmd" + numPenCmds + ".x = " + prevX + ";");
                    System.out.println("penCmd" + numPenCmds + ".y = " + prevY * -1 + ";");
                    ++numPenCmds;
                }
                x = scr.moveDeltaX;
                y = scr.moveDeltaY;
                previousMove = true;
                prevX = x;
                prevY = y;
                System.out.println("ADFTypeSystem.ADFPenCmd penCmd" + numPenCmds + " = new ADFTypeSystem.ADFPenCmd();");
                System.out.println("penCmd" + numPenCmds + ".opCode = ADFTypeSystem.ADF_PEN_MOVETO_CMD;");
                System.out.println("penCmd" + numPenCmds + ".x = " + x + ";");
                System.out.println("penCmd" + numPenCmds + ".y = " + y * -1 + ";");
                ++numCountours;
                ++numPenCmds;
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                System.out.println("ADFTypeSystem.ADFPenCmd penCmd" + numPenCmds + " = new ADFTypeSystem.ADFPenCmd();");
                System.out.println("penCmd" + numPenCmds + ".opCode = ADFTypeSystem.ADF_PEN_LINETO_CMD;");
                System.out.println("penCmd" + numPenCmds + ".x = " + (x += ser.deltaX) + ";");
                System.out.println("penCmd" + numPenCmds + ".y = " + (y += ser.deltaY) * -1 + ";");
                ++numPenCmds;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                int cx = x + cer.controlDeltaX;
                int cy = y + cer.controlDeltaY;
                x = cx + cer.anchorDeltaX;
                y = cy + cer.anchorDeltaY;
                System.out.println("ADFTypeSystem.ADFPenCmd penCmd" + numPenCmds + " = new ADFTypeSystem.ADFPenCmd();");
                System.out.println("penCmd" + numPenCmds + ".opCode = ADFTypeSystem.ADF_PEN_CURVTO_CMD;");
                System.out.println("penCmd" + numPenCmds + ".x = " + x + ";");
                System.out.println("penCmd" + numPenCmds + ".y = " + y * -1 + ";");
                System.out.println("penCmd" + numPenCmds + ".cx = " + cx + ";");
                System.out.println("penCmd" + numPenCmds + ".cy = " + cy * -1 + ";");
                if ((float)cx < xMin) {
                    xMin = cx;
                }
                if ((float)cx > xMax) {
                    xMax = cx;
                }
                if ((float)cy < yMin) {
                    yMin = cy;
                }
                if ((float)cy > yMax) {
                    yMax = cy;
                }
                ++numPenCmds;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unknown ShapeRecord: " + r.getClass()));
            }
            if ((float)x < xMin) {
                xMin = x;
            }
            if ((float)x > xMax) {
                xMax = x;
            }
            if ((float)y < yMin) {
                yMin = y;
            }
            if (!((float)y > yMax)) continue;
            yMax = y;
        }
        if (previousMove && x != prevX && y != prevY) {
            System.out.println("ADFTypeSystem.ADFPenCmd penCmd" + numPenCmds + " = new ADFTypeSystem.ADFPenCmd();");
            System.out.println("penCmd" + numPenCmds + ".opCode = ADFTypeSystem.ADF_PEN_LINETO_CMD;");
            System.out.println("penCmd" + numPenCmds + ".x = " + prevX + ";");
            System.out.println("penCmd" + numPenCmds + ".y = " + prevY * -1 + ";");
            ++numPenCmds;
        }
        System.out.println("data.mPath.penCmds = new ArrayList(" + numPenCmds + ");");
        for (int j = 0; j < numPenCmds; ++j) {
            System.out.println("data.mPath.penCmds.add(" + j + ", penCmd" + j + ");");
        }
        System.out.println("data.mPath.glyphMinX = " + xMin + "f;");
        System.out.println("data.mPath.glyphMinY = " + yMax * -1.0f + "f;");
        System.out.println("data.mPath.glyphMaxX = " + xMax + "f;");
        System.out.println("data.mPath.glyphMaxY = " + yMin * -1.0f + "f;");
        System.out.println("data.mPath.numContours = " + numCountours + ";");
        System.out.println("data.mPath.numPenCmds = " + numPenCmds + ";");
        System.out.println("}");
    }

    static {
        $assertionsDisabled = !FontBuilder.class.desiredAssertionStatus();
        outputForFlashTypeTestC = false;
        outputForFlashTypeTestJava = false;
        useLicenseTag = true;
    }

    public static final class NoFontManagerException
    extends RuntimeException {
        public NoFontManagerException() {
            super("No FontManager provided. Cannot build font.");
        }
    }

    public static final class FontNotFoundException
    extends RuntimeException {
        public FontNotFoundException(String message) {
            super(message);
        }
    }
}

