/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.FontFace;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class FontManager {
    protected Properties languageRanges;
    protected FontManager parent;

    protected FontManager() {
    }

    public void setParent(FontManager parent) {
        this.parent = parent;
    }

    public void setLanguageRange(Properties languageRanges) {
        this.languageRanges = languageRanges;
    }

    public String getLanguageRange(String lang) {
        String range = null;
        if (this.languageRanges != null) {
            range = this.languageRanges.getProperty(lang);
        }
        return range;
    }

    public abstract void initialize(Map var1);

    public abstract FontFace getEntryFromLocation(URL var1, int var2, boolean var3);

    public abstract FontFace getEntryFromSystem(String var1, int var2, boolean var3);

    public static FontManager create(List managerClasses, Map map) {
        FontManager manager = null;
        if (managerClasses != null) {
            for (int i = 0; i < managerClasses.size(); ++i) {
                try {
                    Class<?> clazz;
                    Object obj;
                    Object className = managerClasses.get(i);
                    if (className == null || !((obj = (clazz = Class.forName(className.toString())).newInstance()) instanceof FontManager)) continue;
                    FontManager fm = (FontManager)obj;
                    fm.initialize(map);
                    if (manager != null) {
                        fm.setParent(manager);
                    }
                    manager = fm;
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return manager;
    }
}

