/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.ContinueInstr;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.SaxonBreak;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class SaxonContinue
extends SaxonBreak {
    public void validate() throws XPathException {
        NodeInfo child;
        this.validatePosition();
        if (this.saxonIterate == null) {
            this.compileError("saxon:continue must be a descendant of a saxon:iterate instruction");
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback && this.mayContainFallback()) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within saxon:continue", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed within saxon:continue", "XTSE0010");
        }
    }

    public void postValidate() throws XPathException {
        if (this.saxonIterate != null) {
            NodeInfo w;
            NodeInfo param;
            AxisIterator declaredParams = this.saxonIterate.iterateAxis((byte)3);
            while ((param = (NodeInfo)declaredParams.next()) != null) {
                NodeInfo withParam;
                if (!(param instanceof XSLParam) || !((XSLParam)param).isRequiredParam()) continue;
                AxisIterator actualParams = this.iterateAxis((byte)3);
                boolean ok = false;
                while ((withParam = (NodeInfo)actualParams.next()) != null) {
                    if (!(withParam instanceof XSLWithParam) || !((XSLWithParam)withParam).getVariableQName().equals(((XSLParam)param).getVariableQName())) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                this.compileError("No value supplied for required parameter " + Err.wrap(((XSLParam)param).getVariableDisplayName(), 5), "XTSE0690");
            }
            AxisIterator actualParams = this.iterateAxis((byte)3);
            while ((w = (NodeInfo)actualParams.next()) != null) {
                NodeInfo param2;
                if (!(w instanceof XSLWithParam) || ((XSLWithParam)w).isTunnelParam()) continue;
                XSLWithParam withParam = (XSLWithParam)w;
                AxisIterator formalParams = this.saxonIterate.iterateAxis((byte)3);
                boolean ok = false;
                while ((param2 = (NodeInfo)formalParams.next()) != null) {
                    if (!(param2 instanceof XSLParam) || !((XSLParam)param2).getVariableQName().equals(withParam.getVariableQName())) continue;
                    ok = true;
                    SequenceType required = ((XSLParam)param2).getRequiredType();
                    withParam.checkAgainstRequiredType(required);
                    break;
                }
                if (ok || this.backwardsCompatibleModeIsEnabled()) continue;
                this.compileError("Parameter " + withParam.getVariableDisplayName() + " is not declared in the containing saxon:iterate instruction", "XTSE0680");
            }
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        ContinueInstr call = new ContinueInstr(null);
        call.setParameters(this.getWithParamInstructions(exec, false, call));
        return call;
    }
}

