/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.Stack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayListStack
implements Stack,
List,
Serializable {
    private ArrayList items;
    private static final long serialVersionUID = 1L;

    public ArrayListStack() {
        this.items = new ArrayList();
    }

    public ArrayListStack(int n) {
        this.items = new ArrayList(n);
    }

    public ArrayListStack(ArrayList arrayList) {
        this.items = arrayList;
    }

    public ArrayList getArrayList() {
        return this.items;
    }

    public Object push(Object object) {
        this.items.add(object);
        return object;
    }

    public Object pop() throws EmptyStackException {
        int n = this.size();
        Object object = this.peek();
        this.items.remove(n - 1);
        return object;
    }

    public Object peek() throws EmptyStackException {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException();
        }
        return this.items.get(n - 1);
    }

    public boolean empty() {
        return this.items.isEmpty();
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.size() - 1; i >= 0; --i) {
            stringBuffer.append(this.items.get(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayListStack)) {
            return false;
        }
        ArrayListStack arrayListStack = (ArrayListStack)object;
        if (this.items.size() != arrayListStack.size()) {
            return false;
        }
        ListIterator listIterator = this.items.listIterator();
        ListIterator listIterator2 = arrayListStack.getArrayList().listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public int hashCode() {
        int n = 1;
        for (Object e : this.items) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public int search(Object object) {
        int n = this.items.lastIndexOf(object);
        if (n >= 0) {
            return this.size() - n;
        }
        return -1;
    }

    public void add(int n, Object object) {
        this.items.add(n, object);
    }

    public boolean add(Object object) {
        return this.items.add(object);
    }

    public boolean addAll(Collection collection) {
        return this.items.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.items.addAll(n, collection);
    }

    public boolean contains(Object object) {
        return this.items.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.items.containsAll(collection);
    }

    public Object get(int n) {
        return this.items.get(n);
    }

    public int indexOf(Object object) {
        return this.items.indexOf(object);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Iterator iterator() {
        return this.items.iterator();
    }

    public int lastIndexOf(Object object) {
        return this.items.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.items.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.items.listIterator(n);
    }

    public Object remove(int n) {
        return this.items.remove(n);
    }

    public boolean remove(Object object) {
        return this.items.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.items.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.retainAll(collection);
    }

    public Object set(int n, Object object) {
        return this.items.set(n, object);
    }

    public List subList(int n, int n2) {
        return this.subList(n, n2);
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.items.toArray(objectArray);
    }
}

