/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputByteStreamImpl;
import com.adobe.internal.io.stream.StreamManager;
import java.io.IOException;

final class ByteReaderInputByteStream
extends InputByteStreamImpl {
    private StreamManager streamManager;
    private boolean isSlice = false;
    public ByteReader byteReader = null;
    private long position;
    private long start;
    private long length;
    public boolean lengthInitialized;
    private boolean registered = false;

    ByteReaderInputByteStream(StreamManager streamManager, ByteReader byteReader, boolean bl) throws IOException {
        this(streamManager, byteReader, 0L, -1L, bl);
    }

    ByteReaderInputByteStream(StreamManager streamManager, ByteReader byteReader, long l, long l2, boolean bl) throws IOException {
        if (byteReader == null) {
            throw new IOException("Null ByteReader parameter.");
        }
        this.streamManager = streamManager;
        this.byteReader = byteReader;
        this.start = l;
        this.length = l2;
        this.lengthInitialized = false;
        this.registered = bl;
        if (this.registered) {
            this.streamManager.registerInputByteStream(this, this.byteReader, this.isSlice);
        }
    }

    ByteReaderInputByteStream(ByteReaderInputByteStream byteReaderInputByteStream, long l, long l2) throws IOException {
        if (l < 0L || l2 < 0L || l + l2 > byteReaderInputByteStream.length()) {
            throw new IOException("Invalid slice of Bytestream");
        }
        this.streamManager = byteReaderInputByteStream.streamManager;
        this.byteReader = byteReaderInputByteStream.byteReader;
        this.start = byteReaderInputByteStream.start + l;
        this.length = l2;
        this.position = this.start;
        this.lengthInitialized = byteReaderInputByteStream.lengthInitialized;
        this.isSlice = true;
        this.registered = byteReaderInputByteStream.registered;
        if (this.registered) {
            this.streamManager.registerInputByteStream(this, this.byteReader, this.isSlice);
        }
    }

    public InputByteStream slice(long l, long l2) throws IOException {
        return new ByteReaderInputByteStream(this, l, l2);
    }

    public void close() throws IOException {
        if (this.registered) {
            this.streamManager.deregisterInputByteStream(this, this.byteReader, this.isSlice);
        } else if (!this.isSlice) {
            this.byteReader.close();
        }
        this.byteReader = null;
    }

    public InputByteStream seek(long l) throws IOException {
        if (l < 0L) {
            l = 0L;
        }
        if (l > this.length()) {
            l = this.length();
        }
        this.position = l + this.start;
        return this;
    }

    public long getPosition() throws IOException {
        return this.position - this.start;
    }

    public long length() throws IOException {
        if (!this.lengthInitialized) {
            this.length = this.length == -1L ? this.byteReader.length() : Math.min(this.byteReader.length() - this.start, this.length);
            this.lengthInitialized = true;
        }
        return this.length;
    }

    public int read() throws IOException {
        int n = -1;
        if (this.position - this.start < this.length || !this.lengthInitialized && this.getPosition() < this.length()) {
            n = this.byteReader.read(this.position);
            ++this.position;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((n2 = (int)Math.min((long)n2, this.length() - this.getPosition())) == 0) {
            return -1;
        }
        int n3 = this.byteReader.read(this.position, byArray, n, n2);
        this.seek(this.getPosition() + (long)n3);
        return n3;
    }
}

